/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.index.IndexCommitPoint;
import org.apache.lucene.index.IndexDeletionPolicy;

public class SnapshotDeletionPolicy
implements IndexDeletionPolicy {
    private IndexCommitPoint lastCommit;
    private IndexDeletionPolicy primary;
    private IndexCommitPoint snapshot;

    public SnapshotDeletionPolicy(IndexDeletionPolicy primary) {
        this.primary = primary;
    }

    @Override
    public synchronized void onInit(List commits) throws IOException {
        this.primary.onInit(this.wrapCommits(commits));
        this.lastCommit = (IndexCommitPoint)commits.get(commits.size() - 1);
    }

    @Override
    public synchronized void onCommit(List commits) throws IOException {
        this.primary.onCommit(this.wrapCommits(commits));
        this.lastCommit = (IndexCommitPoint)commits.get(commits.size() - 1);
    }

    public synchronized IndexCommitPoint snapshot() {
        if (this.snapshot != null) {
            throw new IllegalStateException("snapshot is already set; please call release() first");
        }
        this.snapshot = this.lastCommit;
        return this.snapshot;
    }

    public synchronized void release() {
        if (this.snapshot == null) {
            throw new IllegalStateException("snapshot was not set; please call snapshot() first");
        }
        this.snapshot = null;
    }

    private List wrapCommits(List commits) {
        int count = commits.size();
        ArrayList<MyCommitPoint> myCommits = new ArrayList<MyCommitPoint>(count);
        for (int i = 0; i < count; ++i) {
            myCommits.add(new MyCommitPoint((IndexCommitPoint)commits.get(i)));
        }
        return myCommits;
    }

    private class MyCommitPoint
    implements IndexCommitPoint {
        IndexCommitPoint cp;

        MyCommitPoint(IndexCommitPoint cp) {
            this.cp = cp;
        }

        @Override
        public String getSegmentsFileName() {
            return this.cp.getSegmentsFileName();
        }

        @Override
        public Collection getFileNames() throws IOException {
            return this.cp.getFileNames();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void delete() {
            SnapshotDeletionPolicy snapshotDeletionPolicy = SnapshotDeletionPolicy.this;
            synchronized (snapshotDeletionPolicy) {
                if (SnapshotDeletionPolicy.this.snapshot != this.cp) {
                    this.cp.delete();
                }
            }
        }
    }
}

