/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class StandardAnalyzer
extends Analyzer {
    private Set stopSet;
    private boolean replaceInvalidAcronym = false;
    public static final String[] STOP_WORDS = StopAnalyzer.ENGLISH_STOP_WORDS;
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private int maxTokenLength = 255;

    public StandardAnalyzer() {
        this(STOP_WORDS);
    }

    public StandardAnalyzer(Set stopWords) {
        this.stopSet = stopWords;
    }

    public StandardAnalyzer(String[] stopWords) {
        this.stopSet = StopFilter.makeStopSet(stopWords);
    }

    public StandardAnalyzer(File stopwords) throws IOException {
        this.stopSet = WordlistLoader.getWordSet(stopwords);
    }

    public StandardAnalyzer(Reader stopwords) throws IOException {
        this.stopSet = WordlistLoader.getWordSet(stopwords);
    }

    public StandardAnalyzer(boolean replaceInvalidAcronym) {
        this(STOP_WORDS);
        this.replaceInvalidAcronym = replaceInvalidAcronym;
    }

    public StandardAnalyzer(Reader stopwords, boolean replaceInvalidAcronym) throws IOException {
        this(stopwords);
        this.replaceInvalidAcronym = replaceInvalidAcronym;
    }

    public StandardAnalyzer(File stopwords, boolean replaceInvalidAcronym) throws IOException {
        this(stopwords);
        this.replaceInvalidAcronym = replaceInvalidAcronym;
    }

    public StandardAnalyzer(String[] stopwords, boolean replaceInvalidAcronym) throws IOException {
        this(stopwords);
        this.replaceInvalidAcronym = replaceInvalidAcronym;
    }

    public StandardAnalyzer(Set stopwords, boolean replaceInvalidAcronym) throws IOException {
        this(stopwords);
        this.replaceInvalidAcronym = replaceInvalidAcronym;
    }

    @Override
    public TokenStream tokenStream(String fieldName, Reader reader) {
        StandardTokenizer tokenStream = new StandardTokenizer(reader, this.replaceInvalidAcronym);
        tokenStream.setMaxTokenLength(this.maxTokenLength);
        TokenFilter result = new StandardFilter(tokenStream);
        result = new LowerCaseFilter(result);
        result = new StopFilter((TokenStream)result, this.stopSet);
        return result;
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    @Override
    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            this.setPreviousTokenStream(streams);
            streams.tokenStream = new StandardTokenizer(reader);
            streams.filteredTokenStream = new StandardFilter(streams.tokenStream);
            streams.filteredTokenStream = new LowerCaseFilter(streams.filteredTokenStream);
            streams.filteredTokenStream = new StopFilter(streams.filteredTokenStream, this.stopSet);
        } else {
            streams.tokenStream.reset(reader);
        }
        streams.tokenStream.setMaxTokenLength(this.maxTokenLength);
        streams.tokenStream.setReplaceInvalidAcronym(this.replaceInvalidAcronym);
        return streams.filteredTokenStream;
    }

    public boolean isReplaceInvalidAcronym() {
        return this.replaceInvalidAcronym;
    }

    public void setReplaceInvalidAcronym(boolean replaceInvalidAcronym) {
        this.replaceInvalidAcronym = replaceInvalidAcronym;
    }

    private static final class SavedStreams {
        StandardTokenizer tokenStream;
        TokenStream filteredTokenStream;

        private SavedStreams() {
        }
    }
}

