/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fr;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class ElisionFilter
extends TokenFilter {
    private Set articles = null;
    private static String apostrophes = "'\u2019";

    public void setArticles(Set articles) {
        this.articles = new HashSet();
        Iterator iter = articles.iterator();
        while (iter.hasNext()) {
            this.articles.add(((String)iter.next()).toLowerCase());
        }
    }

    protected ElisionFilter(TokenStream input) {
        super(input);
        this.articles = new HashSet<String>(Arrays.asList("l", "m", "t", "qu", "n", "s", "j"));
    }

    public ElisionFilter(TokenStream input, Set articles) {
        super(input);
        this.setArticles(articles);
    }

    public ElisionFilter(TokenStream input, String[] articles) {
        super(input);
        this.setArticles(new HashSet<String>(Arrays.asList(articles)));
    }

    @Override
    public Token next() throws IOException {
        Token t = this.input.next();
        if (t == null) {
            return null;
        }
        String text = t.termText();
        System.out.println(text);
        int minPoz = -1;
        for (int i = 0; i < apostrophes.length(); ++i) {
            int poz = text.indexOf(apostrophes.charAt(i));
            if (poz == -1) continue;
            minPoz = minPoz == -1 ? poz : Math.min(poz, minPoz);
        }
        if (minPoz != -1 && this.articles.contains(text.substring(0, minPoz).toLowerCase())) {
            text = text.substring(minPoz + 1);
        }
        return new Token(text, t.startOffset(), t.endOffset(), t.type());
    }
}

