/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.el;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.el.GreekCharsets;

public final class GreekLowerCaseFilter
extends TokenFilter {
    char[] charset;

    public GreekLowerCaseFilter(TokenStream in, char[] charset) {
        super(in);
        this.charset = charset;
    }

    @Override
    public final Token next() throws IOException {
        Token t = this.input.next();
        if (t == null) {
            return null;
        }
        String txt = t.termText();
        char[] chArray = txt.toCharArray();
        for (int i = 0; i < chArray.length; ++i) {
            chArray[i] = GreekCharsets.toLowerCase(chArray[i], this.charset);
        }
        String newTxt = new String(chArray);
        Token newToken = new Token(newTxt, t.startOffset(), t.endOffset());
        return newToken;
    }
}

