/*
 * Decompiled with CFR 0.152.
 */
package tig.maths;

import tig.maths.Matrix3;

public class Vector3 {
    public double x0;
    public double x1;
    public double x2;

    public Vector3(double a0, double a1, double a2) {
        this.x0 = a0;
        this.x1 = a1;
        this.x2 = a2;
    }

    public Vector3(double[] coords) {
        if (coords.length != 3) {
            throw new IllegalArgumentException("Array passed to Vector3 constructor must have 3 elements");
        }
        this.x0 = coords[0];
        this.x1 = coords[1];
        this.x2 = coords[2];
    }

    public String toString() {
        return "(" + this.x0 + ", " + this.x1 + ", " + this.x2 + ")";
    }

    public static double norm(Vector3 v) {
        return Math.sqrt(v.x0 * v.x0 + v.x1 * v.x1 + v.x2 * v.x2);
    }

    public static Vector3 mul(Matrix3 M, Vector3 a) {
        return new Vector3(M.m00 * a.x0 + M.m01 * a.x1 + M.m02 * a.x2, M.m10 * a.x0 + M.m11 * a.x1 + M.m12 * a.x2, M.m20 * a.x0 + M.m21 * a.x1 + M.m22 * a.x2);
    }

    public static Vector3 mul(double k, Vector3 a) {
        return new Vector3(k * a.x0, k * a.x1, k * a.x2);
    }

    public static Vector3 sub(Vector3 a, Vector3 b) {
        return new Vector3(a.x0 - b.x0, a.x1 - b.x1, a.x2 - b.x2);
    }

    public static Vector3 add(Vector3 a, Vector3 b) {
        return new Vector3(a.x0 + b.x0, a.x1 + b.x1, a.x2 + b.x2);
    }

    public static Vector3 negate(Vector3 a) {
        return new Vector3(-a.x0, -a.x1, -a.x2);
    }

    public static Vector3 doClone(Vector3 a) {
        return a;
    }
}

