/*
 * Decompiled with CFR 0.152.
 */
package tig;

import java.lang.reflect.Field;
import java.util.Properties;
import tig.Strings;

public class TigProperties
extends Properties {
    public static int getIntConstant(String constantName, String className) {
        try {
            Class<?> theClass = Class.forName(className);
            Field field = theClass.getDeclaredField(constantName);
            return field.getInt(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public int getIntProperty(String key) {
        return Integer.parseInt(this.getProperty(key));
    }

    public int getIntProperty(String key, int defaultValue) {
        try {
            int i = Integer.parseInt(this.getProperty(key));
            return i;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void setIntProperty(String key, int intValue) {
        this.setProperty(key, Integer.toString(intValue));
    }

    public double getDoubleProperty(String key) {
        return Double.parseDouble(this.getProperty(key));
    }

    public double getDoubleProperty(String key, double defaultValue) {
        try {
            double d = Double.parseDouble(this.getProperty(key));
            return d;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void setDoubleProperty(String key, double doubleValue) {
        this.setProperty(key, Double.toString(doubleValue));
    }

    public boolean getBooleanProperty(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            throw new RuntimeException("Parameter 'key' can't be converted to a boolean");
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new RuntimeException("Parameter 'key' can't be converted to a boolean");
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        return defaultValue;
    }

    public void setBooleanProperty(String key, boolean booleanValue) {
        String strValue = booleanValue ? "true" : "false";
        this.setProperty(key, strValue);
    }

    public int[] getIntArrayProperty(String key) {
        String[] values = Strings.stringToStringArray(this.getProperty(key), ',');
        int[] res = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            try {
                res[i] = Integer.parseInt(values[i]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("'" + values[i] + "' can't be converted to an integer");
            }
        }
        return res;
    }

    public int[] getIntArrayProperty(String key, int[] defaultValue) {
        try {
            String[] values = Strings.stringToStringArray(this.getProperty(key), ',');
            int[] res = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                res[i] = Integer.parseInt(values[i]);
            }
            return res;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void setIntArrayProperty(String key, int[] intArray) {
        this.setProperty(key, Strings.intArrayToString(intArray));
    }
}

