/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.beans;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sgtplot.beans.AxisHolder;
import sgtplot.beans.DataGroup;
import sgtplot.beans.PanelHolder;
import sgtplot.beans.PropertyPanel;
import sgtplot.swing.prop.ColorDialog;
import sgtplot.swing.prop.FontDialog;
import sgtplot.swing.prop.SGLabelDialog;
import sgtplot.util.GeoDate;
import sgtplot.util.IllegalTimeValue;
import sgtplot.util.Rectangle2D;
import sgtplot.util.SoTRange;

class AxisHolderPropertyPanel
extends PropertyPanel
implements ActionListener,
FocusListener,
ChangeListener {
    private boolean expert_ = false;
    private String[] pNames_ = new String[]{"AutoScale", "AxisColor", "Axis Position", "Axis Location", "AxisType", "Bounds", "Label Color", "Label Font", "Label Format", "Label Height", "Label Interval", "Label Position", "Label SignificantDigits", "Large TicHeight", "Location At Origin", "Major Format", "Major Interval", "Minor Format", "Minor Interval", "Num Small Tics", "OriginP", "Selectable", "Small TicHeight", "Tic Position", "Time AxisStyle", "Title Auto", "Title", "Transform Type", "User Range", "Visible"};
    private boolean[] expertItem = new boolean[]{false, true, false, true, false, true, true, false, true, false, false, true, false, true, true, true, true, true, true, false, true, true, true, true, false, false, false, false, false, false};
    private JComponent[] comps_ = new JComponent[this.pNames_.length];
    private AxisHolder axHolder_;
    private PanelHolder pHolder_;
    private boolean suppressEvent_ = false;
    private int autoScale;
    private int userRange;
    private int titleAuto;
    private int title;
    private String format_ = "yyyy-MM-dd hh:mm";
    private String[] xAxisPosition = new String[]{"Bottom", "Top", "Manual"};
    private String[] yAxisPosition = new String[]{"Left", "Right", "Manual"};

    public AxisHolderPropertyPanel(AxisHolder axHolder, boolean expert) {
        this.axHolder_ = axHolder;
        this.axHolder_.addChangeListener(this);
        this.expert_ = expert;
        this.pHolder_ = this.axHolder_.getDataGroup().getPanelHolder();
        this.create();
    }

    public void setAxisHolder(AxisHolder axHolder, boolean expert) {
        if (this.axHolder_ != null) {
            this.axHolder_.removeChangeListener(this);
        }
        this.axHolder_ = axHolder;
        this.axHolder_.addChangeListener(this);
        this.expert_ = expert;
        this.reset();
    }

    @Override
    void update() {
        int i = -1;
        this.suppressEvent_ = true;
        int item = -1;
        ((JCheckBox)this.comps_[++i]).setSelected(this.axHolder_.isAutoRange());
        this.updateColor((JButton)this.comps_[++i], this.axHolder_.getAxisColor());
        switch (this.axHolder_.getAxisPosition()) {
            default: {
                item = 0;
                break;
            }
            case 0: {
                item = 1;
                break;
            }
            case 2: {
                item = 0;
                break;
            }
            case 3: {
                item = 1;
                break;
            }
            case 4: {
                item = 2;
            }
        }
        ((JComboBox)this.comps_[++i]).setSelectedIndex(item);
        ((JLabel)this.comps_[++i]).setText(this.format(this.axHolder_.getAxisOriginP(), true));
        switch (this.axHolder_.getAxisType()) {
            default: {
                item = 0;
                break;
            }
            case 3: {
                item = 1;
                break;
            }
            case 1: {
                item = 2;
            }
        }
        ((JComboBox)this.comps_[++i]).setSelectedIndex(item);
        ((JLabel)this.comps_[++i]).setText(this.format((Rectangle2D.Double)this.axHolder_.getBoundsP(), true));
        this.updateColor((JButton)this.comps_[++i], this.axHolder_.getLabelColor());
        this.updateFont((JButton)this.comps_[++i], this.axHolder_.getLabelFont());
        ((JTextField)this.comps_[++i]).setText(this.axHolder_.getLabelFormat());
        ((JTextField)this.comps_[++i]).setText(this.format(this.axHolder_.getLabelHeightP()));
        ((JTextField)this.comps_[++i]).setText(this.format(this.axHolder_.getLabelInterval()));
        if (this.axHolder_.isLabelPositionAuto()) {
            item = 0;
        } else {
            switch (this.axHolder_.getLabelPosition()) {
                default: {
                    break;
                }
                case 1: {
                    item = 1;
                    break;
                }
                case 0: {
                    item = 2;
                    break;
                }
                case 2: {
                    item = 3;
                }
            }
        }
        ((JComboBox)this.comps_[++i]).setSelectedIndex(item);
        ((JTextField)this.comps_[++i]).setText(this.format(this.axHolder_.getLabelSignificantDigits()));
        ((JTextField)this.comps_[++i]).setText(this.format(this.axHolder_.getLargeTicHeightP()));
        ((JCheckBox)this.comps_[++i]).setSelected(this.axHolder_.isLocationAtOrigin());
        ((JTextField)this.comps_[++i]).setText(this.axHolder_.getMajorFormat());
        ((JTextField)this.comps_[++i]).setText(this.format(this.axHolder_.getMajorInterval()));
        ((JTextField)this.comps_[++i]).setText(this.axHolder_.getMajorFormat());
        ((JTextField)this.comps_[++i]).setText(this.format(this.axHolder_.getMinorInterval()));
        ((JTextField)this.comps_[++i]).setText(this.format(this.axHolder_.getNumSmallTics()));
        ((JTextField)this.comps_[++i]).setText(this.format(this.axHolder_.getAxisOriginP(), true));
        ((JCheckBox)this.comps_[++i]).setSelected(this.axHolder_.isSelectable());
        ((JTextField)this.comps_[++i]).setText(this.format(this.axHolder_.getSmallTicHeightP()));
        if (this.axHolder_.isTicPositionAuto()) {
            item = 0;
        } else {
            switch (this.axHolder_.getTicPosition()) {
                default: {
                    break;
                }
                case 1: {
                    item = 1;
                    break;
                }
                case 0: {
                    item = 2;
                    break;
                }
                case 2: {
                    item = 3;
                }
            }
        }
        ((JComboBox)this.comps_[++i]).setSelectedIndex(item);
        switch (this.axHolder_.getTimeAxisStyle()) {
            default: {
                item = 0;
                break;
            }
            case 3: {
                item = 1;
                break;
            }
            case 4: {
                item = 2;
                break;
            }
            case 5: {
                item = 3;
                break;
            }
            case 2: {
                item = 4;
                break;
            }
            case 1: {
                item = 5;
            }
        }
        ((JComboBox)this.comps_[++i]).setSelectedIndex(item);
        ((JCheckBox)this.comps_[++i]).setSelected(this.axHolder_.isTitleAuto());
        this.updateSGLabel((JButton)this.comps_[++i], this.axHolder_.getTitle());
        Vector<String> transItems = new Vector<String>(5);
        transItems.add("LinearTransform");
        transItems.add("LogTransform");
        this.addOtherDataGroupTransforms(transItems);
        item = this.findTransformItem(transItems, this.axHolder_.getTransformType(), this.axHolder_.getTransformGroup());
        ((JComboBox)this.comps_[++i]).setSelectedIndex(item);
        ((JTextField)this.comps_[++i]).setText(this.format(this.axHolder_.getUserRange(), false));
        ((JCheckBox)this.comps_[++i]).setSelected(this.axHolder_.isVisible());
        this.suppressEvent_ = false;
    }

    @Override
    void create() {
        int i = -1;
        int item = -1;
        this.comps_[++i] = this.createCheckBox(this.axHolder_.isAutoRange(), this.pNames_[i], this);
        this.autoScale = i++;
        this.comps_[i] = this.createColor(this.axHolder_.getAxisColor(), this.pNames_[i], this);
        Object[] axisPosition = this.axHolder_.getAxisOrientation() == 0 ? this.xAxisPosition : this.yAxisPosition;
        switch (this.axHolder_.getAxisPosition()) {
            default: {
                item = 0;
                break;
            }
            case 0: {
                item = 1;
                break;
            }
            case 2: {
                item = 0;
                break;
            }
            case 3: {
                item = 1;
                break;
            }
            case 4: {
                item = 2;
            }
        }
        this.comps_[++i] = this.createComboBox(axisPosition, item, this.pNames_[i], (ActionListener)this, true);
        this.comps_[++i] = this.createLabel(this.format(this.axHolder_.getAxisOriginP(), true));
        Object[] axisItems = new String[]{"PlainAxis", "TimeAxis", "LogAxis"};
        switch (this.axHolder_.getAxisType()) {
            default: {
                item = 0;
                break;
            }
            case 3: {
                item = 1;
                break;
            }
            case 1: {
                item = 2;
            }
        }
        this.comps_[++i] = this.createComboBox(axisItems, item, this.pNames_[i], (ActionListener)this, true);
        this.comps_[++i] = this.createLabel(this.format((Rectangle2D.Double)this.axHolder_.getBoundsP(), true));
        this.comps_[++i] = this.createColor(this.axHolder_.getLabelColor(), this.pNames_[i], this);
        this.comps_[++i] = this.createFont(this.axHolder_.getLabelFont(), this.pNames_[i], this);
        this.comps_[++i] = this.createTextField(this.axHolder_.getLabelFormat(), this.pNames_[i], this, true);
        this.comps_[++i] = this.createTextField(this.format(this.axHolder_.getLabelHeightP()), this.pNames_[i], this, true);
        this.comps_[++i] = this.createTextField(this.format(this.axHolder_.getLabelInterval()), this.pNames_[i], this, true);
        Object[] labelPos = new String[]{"Auto", "Negative Side", "Positive Side", "No Label"};
        if (this.axHolder_.isLabelPositionAuto()) {
            item = 0;
        } else {
            switch (this.axHolder_.getLabelPosition()) {
                default: {
                    break;
                }
                case 1: {
                    item = 1;
                    break;
                }
                case 0: {
                    item = 2;
                    break;
                }
                case 2: {
                    item = 3;
                }
            }
        }
        this.comps_[++i] = this.createComboBox(labelPos, item, this.pNames_[i], (ActionListener)this, true);
        this.comps_[++i] = this.createTextField(this.format(this.axHolder_.getLabelSignificantDigits()), this.pNames_[i], this, true);
        this.comps_[++i] = this.createTextField(this.format(this.axHolder_.getLargeTicHeightP()), this.pNames_[i], this, true);
        this.comps_[++i] = this.createCheckBox(this.axHolder_.isLocationAtOrigin(), this.pNames_[i], this);
        this.comps_[++i] = this.createTextField(this.axHolder_.getMajorFormat(), this.pNames_[i], this, true);
        this.comps_[++i] = this.createTextField(this.format(this.axHolder_.getMajorInterval()), this.pNames_[i], this, true);
        this.comps_[++i] = this.createTextField(this.axHolder_.getMinorFormat(), this.pNames_[i], this, true);
        this.comps_[++i] = this.createTextField(this.format(this.axHolder_.getMinorInterval()), this.pNames_[i], this, true);
        this.comps_[++i] = this.createTextField(this.format(this.axHolder_.getNumSmallTics()), this.pNames_[i], this, true);
        this.comps_[++i] = this.createTextField(this.format(this.axHolder_.getAxisOriginP(), true), this.pNames_[i], this, true);
        this.comps_[++i] = this.createCheckBox(this.axHolder_.isSelectable(), this.pNames_[i], this);
        this.comps_[++i] = this.createTextField(this.format(this.axHolder_.getSmallTicHeightP()), this.pNames_[i], this, true);
        Object[] ticPos = new String[]{"Auto", "Negative Side", "Positive Side", "Both Sides"};
        if (this.axHolder_.isTicPositionAuto()) {
            item = 0;
        } else {
            switch (this.axHolder_.getTicPosition()) {
                default: {
                    break;
                }
                case 1: {
                    item = 1;
                    break;
                }
                case 0: {
                    item = 2;
                    break;
                }
                case 2: {
                    item = 3;
                }
            }
        }
        this.comps_[++i] = this.createComboBox(ticPos, item, this.pNames_[i], (ActionListener)this, true);
        Object[] timeStyle = new String[]{"Auto", "Day-Month", "Hour-Day", "Minute-Hour", "Month-Year", "Year-Decade"};
        switch (this.axHolder_.getTimeAxisStyle()) {
            default: {
                item = 0;
                break;
            }
            case 3: {
                item = 1;
                break;
            }
            case 4: {
                item = 2;
                break;
            }
            case 5: {
                item = 3;
                break;
            }
            case 2: {
                item = 4;
                break;
            }
            case 1: {
                item = 5;
            }
        }
        this.comps_[++i] = this.createComboBox(timeStyle, item, this.pNames_[i], (ActionListener)this, true);
        this.comps_[++i] = this.createCheckBox(this.axHolder_.isTitleAuto(), this.pNames_[i], this);
        this.titleAuto = i++;
        this.comps_[i] = this.createSGLabel(this.axHolder_.getTitle(), this.pNames_[i], this);
        this.title = i++;
        Vector<String> transItems = new Vector<String>(5);
        transItems.add("LinearTransform");
        transItems.add("LogTransform");
        this.addOtherDataGroupTransforms(transItems);
        item = this.findTransformItem(transItems, this.axHolder_.getTransformType(), this.axHolder_.getTransformGroup());
        this.comps_[i] = this.createComboBox(transItems, item, this.pNames_[i], (ActionListener)this, true);
        this.comps_[++i] = this.createTextField(this.format(this.axHolder_.getUserRange(), false), this.pNames_[i], this, true);
        this.userRange = i++;
        this.comps_[i] = this.createCheckBox(this.axHolder_.isVisible(), this.pNames_[i], this);
        this.setFieldsEnabled();
        int row = 0;
        for (i = 0; i < this.comps_.length; ++i) {
            if (!this.expert_ && this.expertItem[i]) continue;
            this.addProperty(++row, this.pNames_[i], this.comps_[i], false);
        }
        this.addProperty(row + 1, " ", new JLabel(" "), true);
    }

    @Override
    void resetFields() {
        for (int i = 0; i < this.comps_.length; ++i) {
            if (this.comps_[i] instanceof JTextField) {
                ((JTextField)this.comps_[i]).removeActionListener(this);
                ((JTextField)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (this.comps_[i] instanceof JCheckBox) {
                ((JCheckBox)this.comps_[i]).removeActionListener(this);
                ((JCheckBox)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (this.comps_[i] instanceof JComboBox) {
                ((JComboBox)this.comps_[i]).removeActionListener(this);
                ((JComboBox)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (!(this.comps_[i] instanceof JButton)) continue;
            ((JButton)this.comps_[i]).removeActionListener(this);
            ((JButton)this.comps_[i]).removeFocusListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.suppressEvent_) {
            return;
        }
        Object obj = e.getSource();
        String command = e.getActionCommand();
        this.processEvent(obj, command);
        this.setFieldsEnabled();
    }

    private void setFieldsEnabled() {
        ((JTextField)this.comps_[this.userRange]).setEnabled(!((JCheckBox)this.comps_[this.autoScale]).isSelected());
    }

    private void processEvent(Object obj, String command) {
        int item = -1;
        String str = null;
        SoTRange range = null;
        if (command.equals("AutoScale")) {
            this.axHolder_.setAutoRange(((JCheckBox)obj).isSelected());
        } else if (command.equals("AxisColor")) {
            ColorDialog cd = new ColorDialog(this.getFrame(), "Select Axis Color", true);
            cd.setColor(this.axHolder_.getAxisColor());
            cd.setVisible(true);
            Color newcolor = cd.getColor();
            if (newcolor != null) {
                this.axHolder_.setAxisColor(newcolor);
            }
        } else if (command.equals("Axis Position")) {
            str = (String)((JComboBox)obj).getSelectedItem();
            item = -1;
            if (str.equals("Bottom")) {
                item = 1;
            } else if (str.equals("Top")) {
                item = 0;
            } else if (str.equals("Left")) {
                item = 2;
            } else if (str.equals("Right")) {
                item = 3;
            } else if (str.equals("Manual")) {
                item = 4;
            }
            this.axHolder_.setAxisPosition(item);
        } else if (!command.equals("Axis Location")) {
            if (command.equals("AxisType")) {
                str = (String)((JComboBox)obj).getSelectedItem();
                this.axHolder_.setAxisType(this.axis(str));
                if (str.equals("PlainAxis") || str.equals("TimeAxis")) {
                    this.axHolder_.setTransformType(0);
                } else if (str.equals("LogAxis")) {
                    this.axHolder_.setTransformType(1);
                }
                if (str.equals("TimeAxis") && !this.axHolder_.getUserRange().isTime()) {
                    try {
                        range = new SoTRange.Time(new GeoDate("2000-01-01 00:00", this.format_), new GeoDate("2001-01-01 00:00", this.format_), new GeoDate(172800000L));
                    }
                    catch (IllegalTimeValue itv) {
                        itv.printStackTrace();
                    }
                    this.axHolder_.setUserRange(range);
                }
            } else if (command.equals("Bounds")) {
                Rectangle2D bounds = this.parseBounds(((JTextField)obj).getText());
                if (bounds != null) {
                    this.axHolder_.setBoundsP(bounds);
                }
            } else if (command.equals("Label Color")) {
                ColorDialog cd = new ColorDialog(this.getFrame(), "Select Label Color", true);
                cd.setColor(this.axHolder_.getAxisColor());
                cd.setVisible(true);
                Color newcolor = cd.getColor();
                if (newcolor != null) {
                    this.axHolder_.setLabelColor(newcolor);
                }
            } else if (command.equals("Label Font")) {
                FontDialog fd = new FontDialog("Label Font");
                int result = fd.showDialog(this.axHolder_.getLabelFont());
                if (result == FontDialog.OK_RESPONSE) {
                    this.axHolder_.setLabelFont(fd.getFont());
                }
            } else if (command.equals("Label Format")) {
                this.axHolder_.setLabelFormat(((JTextField)obj).getText());
            } else if (command.equals("Label Height")) {
                this.axHolder_.setLabelHeightP(Double.parseDouble(((JTextField)obj).getText()));
            } else if (command.equals("Label Interval")) {
                this.axHolder_.setLabelInterval(Integer.parseInt(((JTextField)obj).getText()));
            } else if (command.equals("Label Position")) {
                str = (String)((JComboBox)obj).getSelectedItem();
                item = -1;
                if (str.equals("Auto")) {
                    item = 3;
                } else if (str.equals("Negative Side")) {
                    item = 1;
                } else if (str.equals("Positive Side")) {
                    item = 0;
                } else if (str.equals("No Label")) {
                    item = 2;
                }
                this.axHolder_.setLabelPosition(item);
            } else if (command.equals("Label SignificantDigits")) {
                this.axHolder_.setLabelSignificantDigits(Integer.parseInt(((JTextField)obj).getText()));
            } else if (command.equals("Large TicHeight")) {
                this.axHolder_.setLargeTicHeightP(Double.parseDouble(((JTextField)obj).getText()));
            } else if (command.equals("Location At Origin")) {
                this.axHolder_.setLocationAtOrigin(((JCheckBox)obj).isSelected());
            } else if (command.equals("Major Format")) {
                this.axHolder_.setMajorFormat(((JTextField)obj).getText());
            } else if (command.equals("Major Interval")) {
                this.axHolder_.setMajorInterval(Integer.parseInt(((JTextField)obj).getText()));
            } else if (command.equals("Minor Format")) {
                this.axHolder_.setMinorFormat(((JTextField)obj).getText());
            } else if (command.equals("Minor Interval")) {
                this.axHolder_.setMinorInterval(Integer.parseInt(((JTextField)obj).getText()));
            } else if (command.equals("Num Small Tics")) {
                this.axHolder_.setNumSmallTics(Integer.parseInt(((JTextField)obj).getText()));
            } else if (command.equals("OriginP")) {
                this.axHolder_.setAxisOriginP(this.parsePoint2D(((JTextField)obj).getText()));
            } else if (command.equals("Selectable")) {
                this.axHolder_.setSelectable(((JCheckBox)obj).isSelected());
            } else if (command.equals("Small TicHeight")) {
                this.axHolder_.setSmallTicHeightP(Double.parseDouble(((JTextField)obj).getText()));
            } else if (command.equals("Tic Position")) {
                str = (String)((JComboBox)obj).getSelectedItem();
                item = -1;
                if (str.equals("Auto")) {
                    item = 3;
                } else if (str.equals("Negative Side")) {
                    item = 1;
                } else if (str.equals("Positive Side")) {
                    item = 0;
                } else if (str.equals("Both Sides")) {
                    item = 2;
                }
                this.axHolder_.setTicPosition(item);
            } else if (command.equals("Time AxisStyle")) {
                str = (String)((JComboBox)obj).getSelectedItem();
                item = -1;
                if (str.equals("Auto")) {
                    item = 0;
                } else if (str.equals("Day-Month")) {
                    item = 3;
                } else if (str.equals("Hour-Day")) {
                    item = 4;
                } else if (str.equals("Minute-Hour")) {
                    item = 5;
                } else if (str.equals("Month-Year")) {
                    item = 2;
                } else if (str.equals("Year-Decade")) {
                    item = 1;
                }
                this.axHolder_.setTimeAxisStyle(item);
            } else if (command.equals("Title Auto")) {
                this.axHolder_.setTitleAuto(((JCheckBox)obj).isSelected());
            } else if (command.equals("Title")) {
                SGLabelDialog sgd = new SGLabelDialog("Axis Title");
                sgd.setSGLabel(this.axHolder_.getTitle());
                sgd.setModal(true);
                sgd.setVisible(true);
                this.axHolder_.fireStateChanged();
            } else if (command.equals("Transform Type")) {
                str = (String)((JComboBox)obj).getSelectedItem();
                int trans = this.transform(str);
                if (trans == 2) {
                    this.axHolder_.setTransformGroup(str.substring(5));
                }
                this.axHolder_.setTransformType(trans);
                if (trans == 2 && this.circularReference(0, str.substring(5))) {
                    JOptionPane.showMessageDialog(this, "Creates a circular reference in DataGroup transform", "Error Selecting Transform", 0);
                    this.axHolder_.setTransformType(-1);
                    this.axHolder_.setTransformGroup(null);
                    ((JComboBox)obj).setSelectedIndex(-1);
                    return;
                }
            } else if (command.equals("User Range")) {
                range = this.parseRange(((JTextField)obj).getText(), this.axHolder_.isTime());
                if (range != null) {
                    this.axHolder_.setUserRange(range);
                }
            } else if (command.equals("Visible")) {
                this.axHolder_.setVisible(((JCheckBox)obj).isSelected());
            }
        }
        this.update();
    }

    private int axis(String value) {
        if (value.equals("PlainAxis")) {
            return 4;
        }
        if (value.equals("TimeAxis")) {
            return 3;
        }
        if (value.equals("LogAxis")) {
            return 1;
        }
        return -1;
    }

    private int transform(String value) {
        if (value.equals("LinearTransform")) {
            return 0;
        }
        if (value.equals("LogTransform")) {
            return 1;
        }
        return 2;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JTextField) {
            JTextField tf = (JTextField)obj;
            String name = tf.getName();
            this.processEvent(obj, name);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.update();
    }

    void addOtherDataGroupTransforms(Vector list) {
        if (this.pHolder_.getDataGroupSize() <= 1) {
            return;
        }
        Iterator iter = this.pHolder_.dataGroupIterator();
        while (iter.hasNext()) {
            DataGroup dg = (DataGroup)iter.next();
            if (dg.getId().equals(this.axHolder_.getDataGroup().getId())) continue;
            list.add("Use: " + dg.getId());
        }
    }

    int findTransformItem(Vector transItems, int transType, String transformGroup) {
        int item = -1;
        switch (transType) {
            default: {
                item = 0;
                break;
            }
            case 1: {
                item = 1;
                break;
            }
            case 2: {
                if (transItems.size() < 3) break;
                for (int i = 2; i < transItems.size(); ++i) {
                    if (!((String)transItems.get(i)).endsWith(transformGroup)) continue;
                    return i;
                }
            }
        }
        return item;
    }

    boolean circularReference(int dir, String datagroup) {
        String dgLast = datagroup;
        boolean stillLooking = true;
        int tType = -1;
        String newDG = null;
        while (stillLooking) {
            DataGroup dg = this.pHolder_.findDataGroup(dgLast);
            tType = dir == 0 ? dg.getXAxisHolder().getTransformType() : dg.getYAxisHolder().getTransformType();
            if (tType != 2) {
                return false;
            }
            newDG = dir == 0 ? dg.getXAxisHolder().getTransformGroup() : dg.getYAxisHolder().getTransformGroup();
            if (datagroup.equals(newDG)) {
                return true;
            }
            dgLast = newDG;
        }
        return false;
    }

    @Override
    public void setExpert(boolean expert) {
        boolean save = this.expert_;
        this.expert_ = expert;
        if (this.expert_ != save) {
            this.reset();
        }
    }

    @Override
    public boolean isExpert() {
        return this.expert_;
    }
}

