/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import sgtplot.SGLabel;
import sgtplot.dm.Collection;
import sgtplot.dm.SGTData;
import sgtplot.dm.SGTMetaData;
import sgtplot.dm.SimpleGrid;
import sgtplot.dm.SimpleLine;
import sgtplot.dm.SimplePoint;
import sgtplot.util.GeoDate;
import sgtplot.util.GeoDateArray;
import sgtplot.util.Point2D;
import sgtplot.util.Range2D;
import sgtplot.util.TimeRange;

public class TestData {
    public static final int PROFILE = 1;
    public static final int X_SERIES = 2;
    public static final int Y_SERIES = 3;
    public static final int TIME_SERIES = 4;
    public static final int XY_GRID = 5;
    public static final int XZ_GRID = 6;
    public static final int YZ_GRID = 7;
    public static final int ZT_GRID = 10;
    public static final int LOG_LOG = 11;
    public static final int SINE = 1;
    public static final int RANDOM = 2;
    public static final int SINE_RAMP = 3;
    private int dataType_;
    private SGTData data_;
    private Collection coll_;

    public TestData() {
        this(1, new Range2D(0.0, 100.0, 10.0), 1, 1.0f, 0.0f, 25.0f);
    }

    public TestData(int dir, Range2D range, int type, float amp, float off, float per) {
        SimpleLine sl;
        SGTMetaData yMeta;
        SGTMetaData xMeta;
        double[] values;
        double[] axis;
        GeoDate[] tzero = new GeoDate[1];
        double[] zero = new double[1];
        tzero[0] = new GeoDate();
        zero[0] = 0.0;
        tzero[0].now();
        if (dir != 11) {
            int num = (int)((range.end - range.start) / range.delta) + 1;
            axis = new double[num];
            for (int count = 0; count < num; ++count) {
                axis[count] = range.start + (double)count * range.delta;
            }
            values = this.getValues(axis, num, type, amp, off, per);
        } else {
            int count;
            double log10 = Math.log(10.0);
            double end10 = Math.log(range.end) / log10;
            double start10 = Math.log(range.start) / log10;
            double delta10 = Math.log(range.delta) / log10;
            float amp10 = (float)(Math.log(amp) / log10);
            float off10 = (float)(Math.log(off) / log10);
            float per10 = (float)(Math.log(per) / log10);
            int num = (int)((end10 - start10) / delta10) + 1;
            axis = new double[num];
            for (count = 0; count < num; ++count) {
                axis[count] = start10 + (double)count * delta10;
            }
            values = this.getValues(axis, num, type, amp10, off10, per10);
            for (count = 0; count < num; ++count) {
                axis[count] = Math.pow(10.0, axis[count]);
                values[count] = Math.pow(10.0, values[count]);
            }
        }
        SGLabel keyLabel = new SGLabel("Key Label", "", new Point2D.Double(0.0, 0.0));
        keyLabel.setHeightP(0.16);
        switch (dir) {
            case 2: {
                keyLabel.setText("X series ts data");
                xMeta = new SGTMetaData("lon", "degE");
                yMeta = new SGTMetaData("ts", "m s-1");
                sl = new SimpleLine(axis, values, "Test Series");
                break;
            }
            case 3: {
                keyLabel.setText("Y series ts data");
                xMeta = new SGTMetaData("lat", "deg");
                yMeta = new SGTMetaData("ts", "m s-1");
                sl = new SimpleLine(axis, values, "Test Series");
                break;
            }
            default: {
                keyLabel.setText("Profile ts data");
                xMeta = new SGTMetaData("ts", "m s-1");
                yMeta = new SGTMetaData("depth", "m");
                sl = new SimpleLine(values, axis, "Test Series");
                break;
            }
            case 11: {
                keyLabel.setText("Log/Log diameters");
                xMeta = new SGTMetaData("diameter", "m");
                yMeta = new SGTMetaData("count", "");
                sl = new SimpleLine(axis, values, "Test Log-Log Series");
            }
        }
        sl.setXMetaData(xMeta);
        sl.setYMetaData(yMeta);
        sl.setKeyTitle(keyLabel);
        this.data_ = sl;
    }

    public TestData(int dir, Range2D range1, Range2D range2, int type, float amp, float off, float per) {
        SimpleGrid sg;
        SGTMetaData yMeta;
        SGTMetaData xMeta;
        int count;
        GeoDate[] tzero = new GeoDate[1];
        double[] zero = new double[1];
        tzero[0] = new GeoDate();
        zero[0] = 0.0;
        tzero[0].now();
        int num1 = (int)((range1.end - range1.start) / range1.delta) + 1;
        double[] axis1 = new double[num1];
        int num2 = (int)((range2.end - range2.start) / range2.delta) + 1;
        double[] axis2 = new double[num2];
        for (count = 0; count < num1; ++count) {
            axis1[count] = range1.start + (double)count * range1.delta;
        }
        for (count = 0; count < num2; ++count) {
            axis2[count] = range2.start + (double)count * range2.delta;
        }
        double[] values = this.getValues(axis1, num1, axis2, num2, type, amp, off, per);
        SGLabel keyLabel = new SGLabel("Key Label", "", new Point2D.Double(0.0, 0.0));
        keyLabel.setHeightP(0.16);
        SGTMetaData zMeta = new SGTMetaData("ts", "m s-1");
        switch (dir) {
            case 5: {
                keyLabel.setText("XY test grid");
                xMeta = new SGTMetaData("lon", "degE");
                yMeta = new SGTMetaData("lat", "deg");
                sg = new SimpleGrid(values, axis1, axis2, "Test Series");
                break;
            }
            case 6: {
                keyLabel.setText("XZ test grid");
                xMeta = new SGTMetaData("lon", "degE");
                yMeta = new SGTMetaData("depth", "m");
                sg = new SimpleGrid(values, axis1, axis2, "Test Series");
                break;
            }
            default: {
                keyLabel.setText("YZ test grid");
                xMeta = new SGTMetaData("lat", "deg");
                yMeta = new SGTMetaData("depth", "m");
                sg = new SimpleGrid(values, axis1, axis2, "Test Series");
            }
        }
        sg.setXMetaData(xMeta);
        sg.setYMetaData(yMeta);
        sg.setZMetaData(zMeta);
        sg.setKeyTitle(keyLabel);
        this.data_ = sg;
    }

    public TestData(int dir, TimeRange range, float delta, int type, float amp, float off, float per) {
        double[] zero = new double[]{0.0};
        double totalTime = range.end.offset(range.start);
        int num = (int)(totalTime / (double)delta) + 1;
        long[] tvalues = new long[num];
        long ref = range.start.getTime();
        long ldelta = (long)delta * 86400000L;
        for (int count = 0; count < num; ++count) {
            tvalues[count] = ref + (long)count * ldelta;
        }
        GeoDateArray taxis = new GeoDateArray(tvalues);
        double[] values = this.getValues(taxis, num, type, amp, off, per);
        SGLabel keyLabel = new SGLabel("Key Label", "", new Point2D.Double(0.0, 0.0));
        keyLabel.setHeightP(0.16);
        keyLabel.setText("Time series ts");
        SGTMetaData xMeta = new SGTMetaData("time", "");
        SGTMetaData yMeta = new SGTMetaData("ts", "m s-1");
        SimpleLine sl = new SimpleLine(taxis, values, "Test Series");
        sl.setXMetaData(xMeta);
        sl.setYMetaData(yMeta);
        sl.setKeyTitle(keyLabel);
        this.data_ = sl;
    }

    public TestData(int dir, Range2D range, TimeRange trange, float delta, int type, float amp, float off, float per) {
        int count;
        double[] zero = new double[]{0.0};
        double totalTime = trange.end.offset(trange.start);
        int tnum = (int)(totalTime / (double)delta) + 1;
        GeoDate[] taxis = new GeoDate[tnum];
        for (count = 0; count < tnum; ++count) {
            taxis[count] = new GeoDate(trange.start);
            taxis[count].increment(delta * (float)count, 1);
        }
        int snum = (int)((range.end - range.start) / range.delta) + 1;
        double[] axis = new double[snum];
        for (count = 0; count < snum; ++count) {
            axis[count] = range.start + (double)count * range.delta;
        }
        double[] values = this.getValues(axis, snum, taxis, tnum, type, amp, off, per);
        SGLabel keyLabel = new SGLabel("Key Label", "", new Point2D.Double(0.0, 0.0));
        keyLabel.setHeightP(0.16);
        keyLabel.setText("time-depth grid");
        SGTMetaData xMeta = new SGTMetaData("time", "");
        SGTMetaData yMeta = new SGTMetaData("depth", "m");
        SGTMetaData zMeta = new SGTMetaData("ts", "m s-1");
        SimpleGrid sg = new SimpleGrid(values, taxis, axis, "Test Series");
        sg.setXMetaData(xMeta);
        sg.setYMetaData(yMeta);
        sg.setZMetaData(zMeta);
        sg.setKeyTitle(keyLabel);
        this.data_ = sg;
    }

    public TestData(Range2D xrnge, Range2D yrnge, int num) {
        this.coll_ = new Collection("Test Points", num);
        double xamp = xrnge.end - xrnge.start;
        double xoff = xrnge.start;
        double yamp = yrnge.end - yrnge.start;
        double yoff = yrnge.start;
        for (int i = 0; i < num; ++i) {
            double xp = xamp * Math.random() + xoff;
            double yp = yamp * Math.random() + yoff;
            String title = "point" + i;
            SimplePoint sp = new SimplePoint(xp, yp, title);
            this.coll_.addElement(sp);
        }
    }

    public Collection getCollection() {
        return this.coll_;
    }

    public SGTData getSGTData() {
        return this.data_;
    }

    private double[] getValues(double[] axis, int num, int type, float amp, float off, float per) {
        double[] values = new double[num];
        switch (type) {
            default: {
                for (int count = 0; count < num; ++count) {
                    values[count] = (double)amp * Math.random() + (double)off;
                }
                break;
            }
            case 1: {
                for (int count = 0; count < num; ++count) {
                    values[count] = (double)amp * Math.sin(axis[count] / (double)per) + (double)off;
                }
            }
        }
        return values;
    }

    private double[] getValues(double[] axis1, int num1, double[] axis2, int num2, int type, float amp, float off, float per) {
        double[] values = new double[num1 * num2];
        switch (type) {
            default: {
                for (int count = 0; count < num1 * num2; ++count) {
                    values[count] = (double)amp * Math.random() + (double)off;
                }
                break;
            }
            case 1: {
                int count = 0;
                for (int count1 = 0; count1 < num1; ++count1) {
                    for (int count2 = 0; count2 < num2; ++count2) {
                        values[count] = (double)amp * Math.sin(axis1[count1] / (double)per) * Math.sin(axis2[count2] / (double)per) + (double)off;
                        ++count;
                    }
                }
                break;
            }
            case 3: {
                int count = 0;
                double ax1factr = 0.08 * Math.abs(axis1[0] - axis1[num1 - 1]) / Math.max(Math.abs(axis1[0]), Math.abs(axis1[num1 - 1]));
                double ax2factr = 0.08 * Math.abs(axis2[0] - axis2[num2 - 1]) / Math.max(Math.abs(axis2[0]), Math.abs(axis2[num2 - 1]));
                for (int count1 = 0; count1 < num1; ++count1) {
                    for (int count2 = 0; count2 < num2; ++count2) {
                        values[count] = (double)amp * Math.sin(axis1[count1] / (double)per) * Math.sin(axis2[count2] / (double)per) + (double)off + (double)amp * (ax1factr * (double)count1 - ax2factr * (double)count2);
                        ++count;
                    }
                }
            }
        }
        return values;
    }

    private double[] getValues(GeoDate[] axis, int num, int type, float amp, float off, float per) {
        double[] values = new double[num];
        switch (type) {
            default: {
                for (int count = 0; count < num; ++count) {
                    values[count] = (double)amp * Math.random() + (double)off;
                }
                break;
            }
            case 1: {
                for (int count = 0; count < num; ++count) {
                    double theta = axis[count].offset(axis[0]) / (double)per;
                    values[count] = (double)amp * Math.sin(theta) + (double)off;
                }
            }
        }
        return values;
    }

    private double[] getValues(GeoDateArray axis, int num, int type, float amp, float off, float per) {
        float lper = per * 8.64E7f;
        long[] tvalues = axis.getTime();
        double[] values = new double[num];
        switch (type) {
            default: {
                for (int count = 0; count < num; ++count) {
                    values[count] = (double)amp * Math.random() + (double)off;
                }
                break;
            }
            case 1: {
                for (int count = 0; count < num; ++count) {
                    double theta = (float)(tvalues[count] - tvalues[0]) / lper;
                    values[count] = (double)amp * Math.sin(theta) + (double)off;
                }
            }
        }
        return values;
    }

    private double[] getValues(double[] axis, int snum, GeoDate[] taxis, int tnum, int type, float amp, float off, float per) {
        double[] values = new double[tnum * snum];
        switch (type) {
            default: {
                for (int count = 0; count < tnum * snum; ++count) {
                    values[count] = (double)amp * Math.random() + (double)off;
                }
                break;
            }
            case 1: {
                int count = 0;
                for (int tcount = 0; tcount < tnum; ++tcount) {
                    double theta = taxis[tcount].offset(taxis[0]) / (double)per;
                    for (int scount = 0; scount < snum; ++scount) {
                        values[count] = (double)amp * Math.sin(theta) * Math.sin(axis[scount] / (double)per) + (double)off;
                        ++count;
                    }
                }
            }
        }
        return values;
    }
}

