/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.Attribute;
import sgtplot.CartesianGraph;
import sgtplot.CartesianRenderer;
import sgtplot.Layer;
import sgtplot.LayerNotFoundException;
import sgtplot.PlotMark;
import sgtplot.PointAttribute;
import sgtplot.SGLabel;
import sgtplot.dm.Collection;
import sgtplot.dm.SGTData;
import sgtplot.dm.SGTPoint;
import sgtplot.util.Point2D;

public class PointCartesianRenderer
extends CartesianRenderer {
    private PointAttribute attr_ = null;
    private SGTPoint point_ = null;
    private Collection collection_ = null;

    @Override
    public Attribute getAttribute() {
        return this.attr_;
    }

    private void drawPoint(VectorGraphics g, SGTPoint point, PlotMark pm) {
        if (pm.getMark() == 0) {
            return;
        }
        int xp = point.isXTime() ? this.cg_.getXUtoD(point.getLongTime()) : this.cg_.getXUtoD(point.getX());
        int yp = point.isYTime() ? this.cg_.getYUtoD(point.getLongTime()) : this.cg_.getYUtoD(point.getY());
        if (xp == Integer.MIN_VALUE || yp == Integer.MIN_VALUE) {
            return;
        }
        pm.paintMark(g, this.cg_.getLayer(), xp, yp);
    }

    private void drawLabel(VectorGraphics g, SGTPoint point, PointAttribute attr) {
        int halign;
        int valign;
        Layer ly = this.cg_.getLayer();
        double xp = point.isXTime() ? this.cg_.getXUtoP(point.getLongTime()) : this.cg_.getXUtoP(point.getX());
        double yp = point.isYTime() ? this.cg_.getYUtoP(point.getLongTime()) : this.cg_.getYUtoP(point.getY());
        double loff = attr.getMarkHeightP() / 2.0;
        double xl = 0.0;
        double yl = 0.0;
        switch (attr.getLabelPosition()) {
            case 0: {
                valign = 1;
                halign = 1;
                break;
            }
            case 1: {
                valign = 2;
                halign = 1;
                yl = loff;
                break;
            }
            default: {
                valign = 2;
                halign = 0;
                yl = loff;
                xl = loff;
                break;
            }
            case 3: {
                valign = 1;
                halign = 0;
                xl = loff;
                break;
            }
            case 4: {
                valign = 0;
                halign = 0;
                yl = -loff;
                xl = loff;
                break;
            }
            case 5: {
                valign = 0;
                halign = 1;
                yl = -loff;
                break;
            }
            case 6: {
                valign = 0;
                halign = 2;
                yl = -loff;
                xl = -loff;
                break;
            }
            case 7: {
                valign = 1;
                halign = 2;
                xl = -loff;
                break;
            }
            case 8: {
                valign = 2;
                halign = 2;
                yl = loff;
                xl = -loff;
            }
        }
        SGLabel pl = new SGLabel("point", point.getTitle(), attr.getLabelHeightP(), new Point2D.Double(xp + xl, yp + yl), valign, halign);
        pl.setColor(attr.getLabelColor());
        pl.setFont(attr.getLabelFont());
        pl.setLayer(ly);
        try {
            pl.draw(g);
        }
        catch (LayerNotFoundException layerNotFoundException) {
            // empty catch block
        }
    }

    public PointCartesianRenderer(CartesianGraph cg) {
        this(cg, (SGTPoint)null, null);
    }

    public PointCartesianRenderer(CartesianGraph cg, SGTPoint point) {
        this(cg, point, null);
        this.cg_ = cg;
        this.point_ = point;
    }

    public PointCartesianRenderer(CartesianGraph cg, SGTPoint point, PointAttribute attr) {
        this.cg_ = cg;
        this.point_ = point;
        this.attr_ = attr;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(this);
        }
    }

    public PointCartesianRenderer(CartesianGraph cg, Collection col, PointAttribute attr) {
        this.cg_ = cg;
        this.collection_ = col;
        this.attr_ = attr;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(this);
        }
    }

    @Override
    public void draw(VectorGraphics g) {
        if (this.cg_.clipping_) {
            int height;
            int y;
            int width;
            int x;
            int ymax;
            int ymin;
            int xmax;
            int xmin;
            if (this.cg_.xTransform_.isSpace()) {
                xmin = this.cg_.getXUtoD(this.cg_.xClipRange_.start);
                xmax = this.cg_.getXUtoD(this.cg_.xClipRange_.end);
            } else {
                xmin = this.cg_.getXUtoD(this.cg_.tClipRange_.start);
                xmax = this.cg_.getXUtoD(this.cg_.tClipRange_.end);
            }
            if (this.cg_.yTransform_.isSpace()) {
                ymin = this.cg_.getYUtoD(this.cg_.yClipRange_.start);
                ymax = this.cg_.getYUtoD(this.cg_.yClipRange_.end);
            } else {
                ymin = this.cg_.getYUtoD(this.cg_.tClipRange_.start);
                ymax = this.cg_.getYUtoD(this.cg_.tClipRange_.end);
            }
            if (xmin < xmax) {
                x = xmin;
                width = xmax - xmin;
            } else {
                x = xmax;
                width = xmin - xmax;
            }
            if (ymin < ymax) {
                y = ymin;
                height = ymax - ymin;
            } else {
                y = ymax;
                height = ymin - ymax;
            }
            g.setClip(x, y, width, height);
        }
        PointAttribute attr = this.attr_ == null ? new PointAttribute(2, this.cg_.layer_.getPane().getComponent().getForeground()) : this.attr_;
        PlotMark pm = new PlotMark(attr);
        if (this.collection_ == null) {
            g.setColor(attr.getColor());
            this.drawPoint(g, this.point_, pm);
            if (attr.isDrawLabel()) {
                this.drawLabel(g, this.point_, attr);
            }
        } else {
            Enumeration li = this.collection_.elements();
            while (li.hasMoreElements()) {
                Object point = li.nextElement();
                if (!(point instanceof SGTPoint)) continue;
                g.setColor(attr.getColor());
                this.drawPoint(g, (SGTPoint)point, pm);
                if (!attr.isDrawLabel()) continue;
                this.drawLabel(g, (SGTPoint)point, attr);
            }
        }
        Rectangle rect = this.cg_.getLayer().getPane().getBounds();
        g.setClip((Shape)rect);
    }

    public void setPointAttribute(PointAttribute l) {
        if (this.attr_ != null) {
            this.attr_.removePropertyChangeListener(this);
        }
        this.attr_ = l;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(this);
        }
    }

    public PointAttribute getPointAttribute() {
        return this.attr_;
    }

    public boolean hasCollection() {
        return this.collection_ != null;
    }

    public Collection getCollection() {
        return this.collection_;
    }

    public SGTPoint getPoint() {
        return this.point_;
    }

    @Override
    public CartesianGraph getCartesianGraph() {
        return this.cg_;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.modified("PointCartesianRenderer: propertyChange(" + evt.getSource().toString() + "[" + evt.getPropertyName() + "])");
    }

    @Override
    public SGTData getDataAt(Point pt) {
        return null;
    }
}

