/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import java.awt.Rectangle;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.Axis;
import sgtplot.Format;
import sgtplot.Layer;
import sgtplot.LayerNotFoundException;
import sgtplot.SGLabel;
import sgtplot.SpaceAxis;
import sgtplot.util.Point2D;

public class LogAxis
extends SpaceAxis
implements Cloneable {
    public LogAxis(String id) {
        super(id);
        this.space_ = true;
        this.numSmallTics_ = 9;
    }

    @Override
    public Axis copy() {
        LogAxis newAxis;
        try {
            newAxis = (LogAxis)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newAxis = new LogAxis(this.getId());
        }
        return newAxis;
    }

    @Override
    void draw(VectorGraphics g) {
        double delta = this.uRange_.delta;
        SGLabel title = this.getTitle();
        if (!this.visible_) {
            return;
        }
        if (Double.isNaN(delta)) {
            delta = (this.uRange_.end - this.uRange_.start) / 10.0;
        }
        if (title != null) {
            title.setLayer(this.graph_.getLayer());
        }
        g.setColor(this.graph_.getLayer().getPane().getComponent().getForeground());
        Format format = this.labelFormat_.length() <= 0 ? new Format(Format.computeFormat(this.uRange_.start, this.uRange_.end, this.sigDigits_)) : new Format(this.labelFormat_);
        if (this.orientation_ == 0) {
            double ytitle;
            double yt;
            int horzalign;
            int vertalign;
            double j;
            double yp;
            int yloc;
            if (this.uLocation_ == null) {
                yloc = this.graph_.getYUtoD(this.tLocation_.t);
                yp = this.graph_.getYUtoP(this.tLocation_.t);
            } else {
                yloc = this.graph_.getYUtoD(this.uLocation_.y);
                yp = this.graph_.getYUtoP(this.uLocation_.y);
            }
            int xloc = this.graph_.getXUtoD(this.uRange_.start);
            int xend = this.graph_.getXUtoD(this.uRange_.end);
            g.drawLine(xloc, yloc, xend, yloc);
            double dir = delta > 0.0 ? 1.0 : -1.0;
            double xt = (double)((int)(this.uRange_.start / delta + (dir * this.uRange_.start > 0.0 ? 1.0 : -1.0) * 1.0E-5)) * delta;
            if (dir * xt < dir * this.uRange_.start) {
                xt += delta;
            }
            int istop = (int)((this.uRange_.end - xt) / delta + 1.0E-5);
            if (this.uRange_.start <= 0.0) {
                return;
            }
            int imin = (int)Math.ceil(Math.log(this.uRange_.start) / Math.log(10.0));
            int imax = (int)Math.floor(Math.log(this.uRange_.end) / Math.log(10.0));
            int nblabel = imax - imin + 1;
            double min = Math.pow(10.0, imin);
            double max = Math.pow(10.0, imax);
            double x = xt = min;
            double xp = this.graph_.getXUtoP(x);
            for (j = min / 10.0; j < min; j += min / 10.0) {
                xp = this.graph_.getXUtoP(j);
                if (!(j > this.uRange_.start)) continue;
                this.drawXTic(g, xp, yp, this.smallTicHeight_);
            }
            for (j = min; j <= max; j *= 10.0) {
                if (j > min) {
                    this.drawSmallXTics(g, j / 10.0, this.uRange_.end, j, yp);
                }
                xp = this.graph_.getXUtoP(j);
                this.drawXTic(g, xp, yp, this.largeTicHeight_);
            }
            this.drawSmallXTics(g, j, this.uRange_.end, j, yp);
            if (this.labelInterval_ <= 0 || this.labelPosition_ == 2) {
                return;
            }
            x = dir * this.uRange_.start <= 0.0 && dir * this.uRange_.end >= 0.0 ? (double)((int)(this.uRange_.start / (delta * (double)this.labelInterval_) - 1.0E-5)) * delta * (double)this.labelInterval_ : xt;
            istop = (int)((this.uRange_.end - x) / (delta * (double)this.labelInterval_) + 1.0E-5);
            long jump = 10L;
            if (istop < nblabel) {
                jump = 100L;
            }
            if (this.labelPosition_ == 0) {
                vertalign = 2;
                horzalign = 1;
                yt = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? yp + 1.3 * this.largeTicHeight_ : yp + 0.05;
                ytitle = yt + 1.3 * this.labelHeight_;
            } else {
                vertalign = 0;
                horzalign = 1;
                yt = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? yp - 1.3 * this.largeTicHeight_ : yp - 0.05;
                ytitle = yt - 1.3 * this.labelHeight_;
            }
            for (j = min; j <= max; j *= (double)jump) {
                xt = this.graph_.getXUtoP(j) - 1.3 * this.labelHeight_ * 0.25;
                String labelText = "10e" + Math.round(Math.log(j) / Math.log(10.0));
                SGLabel label = new SGLabel("coordinate", labelText, new Point2D.Double(xt, yt));
                label.setAlign(vertalign, horzalign);
                label.setOrientation(0);
                label.setFont(this.labelFont_);
                label.setColor(this.labelColor_);
                label.setHeightP(this.labelHeight_);
                label.setLayer(this.graph_.getLayer());
                try {
                    label.draw(g);
                    continue;
                }
                catch (LayerNotFoundException layerNotFoundException) {
                    // empty catch block
                }
            }
            if (this.title_ != null) {
                double xtitle = this.graph_.getXUtoP(this.uRange_.end) + this.graph_.getXUtoP(this.uRange_.start);
                xt = xtitle * 0.5;
                yt = ytitle;
                xt = this.graph_.getXUtoP(xtitle);
                title.setLocationP(new Point2D.Double(xt, yt));
                title.setAlign(vertalign, 1);
                title.setOrientation(0);
                try {
                    title.draw(g);
                }
                catch (LayerNotFoundException layerNotFoundException) {}
            }
        } else {
            double xtitle;
            double xt;
            int horzalign;
            int vertalign;
            SGLabel label;
            String labelText;
            double j;
            double xp;
            int xloc;
            if (this.uLocation_ == null) {
                xloc = this.graph_.getXUtoD(this.tLocation_.t);
                xp = this.graph_.getXUtoP(this.tLocation_.t);
            } else {
                xloc = this.graph_.getXUtoD(this.uLocation_.x);
                xp = this.graph_.getXUtoP(this.uLocation_.x);
            }
            int yloc = this.graph_.getYUtoD(this.uRange_.start);
            int yend = this.graph_.getYUtoD(this.uRange_.end);
            g.drawLine(xloc, yloc, xloc, yend);
            double dir = delta > 0.0 ? 1.0 : -1.0;
            double yt = (double)((int)(this.uRange_.start / delta + (dir * this.uRange_.start > 0.0 ? 1.0 : -1.0) * 1.0E-5)) * delta;
            if (dir * yt < dir * this.uRange_.start) {
                yt += delta;
            }
            int istop = (int)((this.uRange_.end - yt) / delta + 1.0E-5);
            if (this.uRange_.start <= 0.0) {
                return;
            }
            int imin = (int)Math.ceil(Math.log(this.uRange_.start) / Math.log(10.0));
            int imax = (int)Math.floor(Math.log(this.uRange_.end) / Math.log(10.0));
            int nblabel = imax - imin + 1;
            double min = Math.pow(10.0, imin);
            double max = Math.pow(10.0, imax);
            double y = yt = min;
            double yp = this.graph_.getYUtoP(y);
            for (j = min / 10.0; j < min; j += min / 10.0) {
                yp = this.graph_.getYUtoP(j);
                if (!(j > this.uRange_.start)) continue;
                this.drawYTic(g, xp, yp, this.smallTicHeight_);
            }
            for (j = min; j <= max; j *= 10.0) {
                if (j > min) {
                    this.drawSmallYTics(g, xp, j / 10.0, this.uRange_.end, j);
                }
                yp = this.graph_.getYUtoP(j);
                this.drawYTic(g, xp, yp, this.largeTicHeight_);
            }
            this.drawSmallYTics(g, xp, j, this.uRange_.end, j);
            if (this.labelInterval_ <= 0 || this.labelPosition_ == 2) {
                return;
            }
            y = dir * this.uRange_.start <= 0.0 && dir * this.uRange_.end >= 0.0 ? (double)((int)(this.uRange_.start / (delta * (double)this.labelInterval_) - 1.0E-5)) * delta * (double)this.labelInterval_ : yt;
            istop = (int)((this.uRange_.end - y) / (delta * (double)this.labelInterval_) + 1.0E-5);
            long jump = 10L;
            if (istop < nblabel) {
                jump = 100L;
            }
            Layer l = this.graph_.getLayer();
            double widthP = 0.0;
            double maxWidthP = 0.0;
            if (l != null) {
                for (j = min; j <= max; j *= (double)jump) {
                    labelText = "10e" + Math.round(Math.log(j) / Math.log(10.0));
                    label = new SGLabel("coordinate", labelText.trim(), new Point2D.Double(0.0, yt));
                    label.setOrientation(0);
                    label.setFont(this.labelFont_);
                    label.setHeightP(this.labelHeight_);
                    label.setLayer(l);
                    widthP = l.getXDtoP((int)label.getStringWidth(g));
                    if (!(widthP > maxWidthP)) continue;
                    maxWidthP = widthP;
                }
            }
            if (this.labelPosition_ == 1) {
                vertalign = 2;
                horzalign = 2;
                xt = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? xp - 1.3 * this.largeTicHeight_ : xp - 0.05;
                xtitle = xt - maxWidthP;
            } else {
                vertalign = 0;
                horzalign = 0;
                xt = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? xp + 1.3 * this.largeTicHeight_ : xp + 0.05;
                xtitle = xt + maxWidthP;
            }
            for (j = min; j <= max; j *= (double)jump) {
                yt = this.graph_.getYUtoP(j);
                labelText = "10e" + Math.round(Math.log(j) / Math.log(10.0));
                label = new SGLabel("coordinate", labelText, new Point2D.Double(xt, yt));
                label.setAlign(1, horzalign);
                label.setOrientation(0);
                label.setFont(this.labelFont_);
                label.setColor(this.labelColor_);
                label.setHeightP(this.labelHeight_);
                label.setLayer(this.graph_.getLayer());
                try {
                    label.draw(g);
                    continue;
                }
                catch (LayerNotFoundException layerNotFoundException) {
                    // empty catch block
                }
            }
            if (this.title_ != null) {
                double ytitle = this.graph_.getYUtoP(this.uRange_.end) + this.graph_.getYUtoP(this.uRange_.start);
                yt = ytitle * 0.5;
                xt = xtitle;
                title.setLocationP(new Point2D.Double(xt, yt));
                title.setAlign(vertalign, 1);
                title.setOrientation(1);
                try {
                    title.draw(g);
                }
                catch (LayerNotFoundException layerNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public Rectangle getBounds() {
        int height;
        int y;
        int x;
        int width;
        if (this.orientation_ == 0) {
            int xd = this.graph_.getXUtoD(this.uRange_.start);
            double yp = this.uLocation_ == null ? this.graph_.getYUtoP(this.tLocation_.t) : this.graph_.getYUtoP(this.uLocation_.y);
            width = this.graph_.getXUtoD(this.uRange_.end) - xd;
            x = xd;
            double ymin = yp;
            double ymax = yp;
            if (this.ticPosition_ == 2 || this.ticPosition_ == 0) {
                ymax += this.largeTicHeight_;
            }
            if (this.ticPosition_ == 2 || this.ticPosition_ == 1) {
                ymin -= this.largeTicHeight_;
            }
            if (this.labelPosition_ == 0) {
                ymax = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? ymax + -0.30000000000000004 * this.largeTicHeight_ + this.labelHeight_ : ymax + 0.05 + this.labelHeight_;
            } else if (this.labelPosition_ == 1) {
                ymin = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? ymin - -0.30000000000000004 * this.largeTicHeight_ - this.labelHeight_ : ymin - 0.05 - this.labelHeight_;
            }
            y = this.graph_.getLayer().getYPtoD(ymax);
            height = this.graph_.getLayer().getYPtoD(ymin) - y;
        } else {
            int yd = this.graph_.getYUtoD(this.uRange_.start);
            double xp = this.uLocation_ == null ? this.graph_.getXUtoP(this.tLocation_.t) : this.graph_.getXUtoP(this.uLocation_.x);
            y = this.graph_.getYUtoD(this.uRange_.end);
            height = yd - y;
            double xmin = xp;
            double xmax = xp;
            if (this.ticPosition_ == 2 || this.ticPosition_ == 0) {
                xmax += this.largeTicHeight_;
            }
            if (this.ticPosition_ == 2 || this.ticPosition_ == 1) {
                xmin -= this.largeTicHeight_;
            }
            if (this.labelPosition_ == 0) {
                xmax = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? xmax + -0.30000000000000004 * this.largeTicHeight_ + this.labelHeight_ : xmax + 0.05 + this.labelHeight_;
            } else if (this.labelPosition_ == 1) {
                xmin = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? xmin - -0.30000000000000004 * this.largeTicHeight_ - this.labelHeight_ : xmin - 0.05 - this.labelHeight_;
            }
            x = this.graph_.getLayer().getXPtoD(xmin);
            width = this.graph_.getLayer().getXPtoD(xmax) - x;
        }
        return new Rectangle(x, y, width, height);
    }

    public void setBounds(int x, int y, int width, int height) {
    }

    public void setBounds(Rectangle rect) {
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }
}

