/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import sgtplot.TimeAxisStyle;
import sgtplot.util.GeoDate;
import sgtplot.util.IllegalTimeValue;
import sgtplot.util.TimeRange;

class DayMonthAxis
implements TimeAxisStyle {
    static final int MONTH_TEST__ = 3;
    static final String defaultMinorLabelFormat__ = "dd";
    static final String defaultMajorLabelFormat__ = "yyyy-MM";
    static final int defaultNumSmallTics__ = 0;
    int defaultMinorLabelInterval_ = 2;
    int defaultMajorLabelInterval_ = 1;
    static final double incrementValue__ = 1.0;
    static final int incrementUnits__ = 1;

    @Override
    public double computeLocation(double prev, double now) {
        return (prev + now) * 0.5;
    }

    @Override
    public void computeDefaults(GeoDate delta) {
        long days = delta.getTime() / 86400000L;
        this.defaultMinorLabelInterval_ = days > 30L ? 5 : (days > 10L ? 2 : 1);
    }

    @Override
    public int getMinorValue(GeoDate time) {
        return time.getGMTDay();
    }

    @Override
    public int getMajorValue(GeoDate time) {
        return time.getGMTMonth();
    }

    @Override
    public boolean isRoomForMajorLabel(GeoDate delta) {
        return delta.getTime() / 86400000L > 3L;
    }

    @Override
    public boolean isStartOfMinor(GeoDate time) {
        return time.getGMTDay() == 1;
    }

    @Override
    public String getDefaultMinorLabelFormat() {
        return defaultMinorLabelFormat__;
    }

    @Override
    public String getDefaultMajorLabelFormat() {
        return defaultMajorLabelFormat__;
    }

    @Override
    public int getDefaultNumSmallTics() {
        return 0;
    }

    @Override
    public int getDefaultMinorLabelInterval() {
        return this.defaultMinorLabelInterval_;
    }

    @Override
    public int getDefaultMajorLabelInterval() {
        return this.defaultMajorLabelInterval_;
    }

    @Override
    public GeoDate getStartTime(TimeRange tRange) {
        GeoDate time = null;
        boolean time_increasing = tRange.end.after(tRange.start);
        try {
            if (time_increasing) {
                time = new GeoDate(tRange.start.getGMTMonth(), tRange.start.getGMTDay(), tRange.start.getGMTYear(), 0, 0, 0, 0);
                if (!time.equals(tRange.start)) {
                    time.increment(1.0, 1);
                }
            } else {
                time = new GeoDate(tRange.end.getGMTMonth(), tRange.end.getGMTDay(), tRange.end.getGMTYear(), 0, 0, 0, 0);
                if (!time.equals(tRange.end)) {
                    time.increment(1.0, 1);
                }
            }
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        return time;
    }

    @Override
    public double getIncrementValue() {
        return 1.0;
    }

    @Override
    public int getIncrementUnits() {
        return 1;
    }

    @Override
    public String toString() {
        return "DayMonthAxis";
    }
}

