/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.Vector;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.AbstractPane;
import sgtplot.AxisTransform;
import sgtplot.CartesianGraph;
import sgtplot.SGLabel;
import sgtplot.Selectable;
import sgtplot.util.Range2D;
import sgtplot.util.SoTPoint;
import sgtplot.util.SoTRange;

public abstract class Axis
implements Selectable {
    private String ident_;
    protected CartesianGraph graph_;
    protected Vector registeredAxes_;
    protected Vector registeredTransforms_;
    protected Color lineColor_;
    protected int numSmallTics_;
    protected double largeTicHeight_;
    protected double smallTicHeight_;
    protected double thickTicWidth_;
    protected int ticPosition_;
    protected int labelPosition_;
    protected int labelInterval_;
    protected Font labelFont_;
    protected Color labelColor_;
    protected double labelHeight_;
    protected int sigDigits_;
    protected String labelFormat_;
    protected SGLabel title_;
    protected Range2D pRange_;
    protected boolean space_;
    protected int orientation_;
    protected boolean selected_;
    protected boolean selectable_;
    protected boolean visible_;
    public static final int POSITIVE_SIDE = 0;
    public static final int NEGATIVE_SIDE = 1;
    public static final int NO_LABEL = 2;
    public static final int BOTH_SIDES = 2;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int AUTO = 3;

    protected abstract void updateRegisteredTransforms();

    protected abstract void updateRegisteredAxes();

    protected void drawXTic(VectorGraphics g, double xp, double yp, double ticHeight) {
        double yp0 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? yp + ticHeight : yp;
        double yp1 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? yp - ticHeight : yp;
        int x0 = this.graph_.getLayer().getXPtoD(xp);
        int y0 = this.graph_.getLayer().getYPtoD(yp0);
        int y1 = this.graph_.getLayer().getYPtoD(yp1);
        g.drawLine(x0, y0, x0, y1);
    }

    protected void drawThickXTic(VectorGraphics g, double xp, double yp, double ticHeight) {
        double yp0 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? yp + ticHeight : yp;
        double yp1 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? yp - ticHeight : yp;
        int xc = this.graph_.getLayer().getXPtoD(xp);
        int x0 = this.graph_.getLayer().getXPtoD(xp - this.thickTicWidth_ / 2.0);
        int x1 = this.graph_.getLayer().getXPtoD(xp + this.thickTicWidth_ / 2.0);
        int y0 = this.graph_.getLayer().getYPtoD(yp0);
        int y1 = this.graph_.getLayer().getYPtoD(yp1);
        if (x1 - x0 < 3) {
            x0 = xc - 1;
            x1 = xc + 1;
        }
        int ticW = x1 - x0;
        int ticH = y1 - y0;
        g.fillRect(x0, y0, ticW, ticH);
    }

    protected void drawYTic(VectorGraphics g, double xp, double yp, double ticHeight) {
        double xp0 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? xp + ticHeight : xp;
        double xp1 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? xp - ticHeight : xp;
        int y0 = this.graph_.getLayer().getYPtoD(yp);
        int x0 = this.graph_.getLayer().getXPtoD(xp0);
        int x1 = this.graph_.getLayer().getXPtoD(xp1);
        g.drawLine(x0, y0, x1, y0);
    }

    protected void drawThickYTic(VectorGraphics g, double xp, double yp, double ticHeight) {
        double xp0 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? xp + ticHeight : xp;
        double xp1 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? xp - ticHeight : xp;
        int y0 = this.graph_.getLayer().getYPtoD(yp);
        int x0 = this.graph_.getLayer().getXPtoD(xp0);
        int x1 = this.graph_.getLayer().getXPtoD(xp1);
        g.drawLine(x0, y0 - 1, x1, y0 - 1);
        g.drawLine(x0, y0, x1, y0);
        g.drawLine(x0, y0 + 1, x1, y0 + 1);
    }

    public Axis() {
        this("");
    }

    public Axis(String id) {
        this.ident_ = id;
        this.registeredAxes_ = new Vector();
        this.registeredTransforms_ = new Vector();
        this.lineColor_ = Color.black;
        this.numSmallTics_ = 0;
        this.largeTicHeight_ = 0.03;
        this.smallTicHeight_ = 0.02;
        this.thickTicWidth_ = 0.025;
        this.ticPosition_ = 1;
        this.labelPosition_ = 1;
        this.labelInterval_ = 2;
        this.labelHeight_ = 0.04;
        this.sigDigits_ = 2;
        this.labelFormat_ = "";
        this.title_ = null;
        this.orientation_ = 0;
        this.labelFont_ = new Font("Arial", 2, 12);
        this.labelColor_ = Color.black;
        this.selected_ = false;
        this.selectable_ = true;
        this.visible_ = true;
    }

    public abstract Axis copy();

    abstract void draw(VectorGraphics var1);

    void setGraph(CartesianGraph g) {
        this.graph_ = g;
    }

    public CartesianGraph getGraph() {
        return this.graph_;
    }

    public AbstractPane getPane() {
        return this.graph_.getPane();
    }

    public void modified(String mess) {
        if (this.graph_ != null) {
            this.graph_.modified(mess);
        }
    }

    public void register(Axis axis) {
        this.registeredAxes_.addElement(axis);
    }

    public void register(AxisTransform trns) {
        this.registeredTransforms_.addElement(trns);
    }

    public void clear(Axis axis) {
        if (!this.registeredAxes_.isEmpty()) {
            this.registeredAxes_.removeElement(axis);
        }
    }

    public void clear(AxisTransform trns) {
        if (!this.registeredTransforms_.isEmpty()) {
            this.registeredTransforms_.removeElement(trns);
        }
    }

    public void clearAllRegisteredAxes() {
        this.registeredAxes_.removeAllElements();
    }

    public void clearAllRegisteredTransforms() {
        this.registeredTransforms_.removeAllElements();
    }

    public int getNumberRegisteredTransforms() {
        return this.registeredTransforms_.size();
    }

    public int getNumberRegisteredAxes() {
        return this.registeredAxes_.size();
    }

    public void setLargeTicHeightP(double lthgt) {
        if (this.largeTicHeight_ != lthgt) {
            this.largeTicHeight_ = lthgt;
            this.modified("Axis: setLargeTicHeightP()");
        }
    }

    public double getLargeTicHeightP() {
        return this.largeTicHeight_;
    }

    public void setNumberSmallTics(int nstic) {
        if (this.numSmallTics_ != nstic) {
            this.numSmallTics_ = nstic;
            this.modified("Axis: setNumerSmallTics()");
        }
    }

    public int getNumberSmallTics() {
        return this.numSmallTics_;
    }

    public void setSmallTicHeightP(double sthgt) {
        if (this.smallTicHeight_ != sthgt) {
            this.smallTicHeight_ = sthgt;
            this.modified("Axis: setSmallTicHeightP()");
        }
    }

    public double getSmallTicHeightP() {
        return this.smallTicHeight_;
    }

    public void setThickTicWidthP(double wid) {
        if (this.thickTicWidth_ != wid) {
            this.thickTicWidth_ = wid;
            this.modified("Axis: setThickTicWidthP()");
        }
    }

    public double getThickTicWidthP() {
        return this.thickTicWidth_;
    }

    public void setTicPosition(int tpos) {
        if (this.ticPosition_ != tpos) {
            this.ticPosition_ = tpos;
            this.modified("Axis: setTicPosition()");
        }
    }

    public int getTicPosition() {
        return this.ticPosition_;
    }

    public void setLabelPosition(int labp) {
        if (this.labelPosition_ != labp) {
            this.labelPosition_ = labp;
            this.modified("Axis: setLabelPosition()");
        }
    }

    public int getLabelPosition() {
        return this.labelPosition_;
    }

    public void setLabelFont(Font fnt) {
        if (this.labelFont_ == null || !this.labelFont_.equals(fnt)) {
            this.labelFont_ = fnt;
            this.modified("Axis: setLabelFont()");
        }
    }

    public Font getLabelFont() {
        return this.labelFont_;
    }

    public void setLineColor(Color color) {
        if (this.lineColor_ == null || !this.lineColor_.equals(color)) {
            this.lineColor_ = color;
            this.modified("Axis: setLineColor()");
        }
    }

    public Color getLineColor() {
        return this.lineColor_;
    }

    public void setLabelColor(Color color) {
        if (this.labelColor_ == null || !this.labelColor_.equals(color)) {
            this.labelColor_ = color;
            this.modified("Axis: setLabelColor()");
        }
    }

    public Color getLabelColor() {
        return this.labelColor_;
    }

    public void setLabelHeightP(double lhgt) {
        if (this.labelHeight_ != lhgt) {
            this.labelHeight_ = lhgt;
            this.modified("Axis: setLabelHeightP()");
        }
    }

    public double getLabelHeightP() {
        return this.labelHeight_;
    }

    public void setTitle(SGLabel title) {
        if (this.title_ == null || !this.title_.equals(title)) {
            this.title_ = title;
            this.title_.setMoveable(false);
            this.modified("Axis: setTitle()");
        }
    }

    public SGLabel getTitle() {
        return this.title_;
    }

    public void setRangeP(Range2D pr) {
        if (this.pRange_ == null || !this.pRange_.equals(pr)) {
            this.pRange_ = pr;
            this.updateRegisteredTransforms();
            this.modified("Axis: setRangeP()");
        }
    }

    public Range2D getRangeP() {
        if (this.orientation_ == 0) {
            return this.graph_.xTransform_.getRangeP();
        }
        return this.graph_.yTransform_.getRangeP();
    }

    public void setId(String id) {
        this.ident_ = id;
    }

    public String getId() {
        return this.ident_;
    }

    public void setOrientation(int or) {
        if (this.orientation_ != or) {
            this.orientation_ = or;
            this.modified("Axis: setOrientation()");
        }
    }

    public int getOrientation() {
        return this.orientation_;
    }

    public boolean isSpace() {
        return this.space_;
    }

    public boolean isTime() {
        return !this.space_;
    }

    @Override
    public abstract Rectangle getBounds();

    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(".") + 1) + ": " + this.ident_;
    }

    @Override
    public void setSelected(boolean sel) {
        this.selected_ = sel;
    }

    @Override
    public boolean isSelected() {
        return this.selected_;
    }

    @Override
    public void setSelectable(boolean select) {
        this.selectable_ = select;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable_;
    }

    public boolean isVisible() {
        return this.visible_;
    }

    public void setVisible(boolean visible) {
        if (this.visible_ != visible) {
            this.visible_ = visible;
            this.modified("Axis: setVisible()");
        }
    }

    public abstract void setLocationU(SoTPoint var1);

    public abstract SoTPoint getSoTLocationU();

    public abstract void setRangeU(SoTRange var1);

    public abstract SoTRange getSoTRangeU();
}

