/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.plotml;

import com.microstar.xml.XmlException;
import ptolemy.plot.Plot;
import ptolemy.plot.plotml.PlotBoxMLParser;

public class PlotMLParser
extends PlotBoxMLParser {
    protected boolean _connected = true;
    protected int _currentDataset = -1;
    protected double _currentPointCount = 0.0;

    public PlotMLParser(Plot plot) {
        super(plot);
    }

    protected PlotMLParser() {
    }

    @Override
    public void endElement(String elementName) throws Exception {
        super.endElement(elementName);
        if (elementName.equals("dataset")) {
            ((Plot)this._plot).setConnected(this._connected);
        }
    }

    @Override
    public void startDocument() {
        super.startDocument();
        this._currentDataset = -1;
        this._currentPointCount = 0.0;
    }

    @Override
    public void startElement(String elementName) throws XmlException {
        try {
            if (elementName.equals("barGraph")) {
                String widthSpec = (String)this._attributes.get("width");
                String offsetSpec = (String)this._attributes.get("offset");
                if (widthSpec == null || offsetSpec == null) {
                    ((Plot)this._plot).setBars(true);
                } else {
                    double width = Double.valueOf(widthSpec);
                    double offset = Double.valueOf(offsetSpec);
                    ((Plot)this._plot).setBars(width, offset);
                }
            } else if (elementName.equals("dataset")) {
                String stems;
                String marks;
                String connected;
                String name = (String)this._attributes.get("name");
                if (!((Plot)this._plot).getReuseDatasets() || name == null || this._currentDataset < 0) {
                    ++this._currentDataset;
                    this._currentPointCount = 0.0;
                } else {
                    int possibleDataset = ((Plot)this._plot).getLegendDataset(name);
                    if (possibleDataset != -1) {
                        this._currentDataset = possibleDataset;
                    } else {
                        ++this._currentDataset;
                        this._currentPointCount = 0.0;
                    }
                }
                if (name != null) {
                    ((Plot)this._plot).addLegend(this._currentDataset, name);
                }
                if ((connected = (String)this._attributes.get("connected")) != null) {
                    if (connected.equals("no")) {
                        ((Plot)this._plot).setConnected(false, this._currentDataset);
                    } else {
                        ((Plot)this._plot).setConnected(true, this._currentDataset);
                    }
                }
                if ((marks = (String)this._attributes.get("marks")) != null) {
                    ((Plot)this._plot).setMarksStyle(marks, this._currentDataset);
                }
                if ((stems = (String)this._attributes.get("stems")) != null) {
                    if (stems.equals("yes")) {
                        ((Plot)this._plot).setImpulses(true, this._currentDataset);
                    } else {
                        ((Plot)this._plot).setImpulses(false, this._currentDataset);
                    }
                }
            } else if (elementName.equals("default")) {
                String stems;
                String connected = (String)this._attributes.get("connected");
                if (connected.equals("yes")) {
                    ((Plot)this._plot).setConnected(true);
                    this._connected = true;
                } else {
                    ((Plot)this._plot).setConnected(false);
                    this._connected = false;
                }
                String marks = (String)this._attributes.get("marks");
                if (marks != null) {
                    ((Plot)this._plot).setMarksStyle(marks);
                }
                if ((stems = (String)this._attributes.get("stems")).equals("no")) {
                    ((Plot)this._plot).setImpulses(false);
                } else {
                    ((Plot)this._plot).setImpulses(true);
                }
            } else if (elementName.equals("m")) {
                this._addPoint(false, elementName);
            } else if (elementName.equals("move")) {
                this._addPoint(false, elementName);
            } else if (elementName.equals("p")) {
                this._addPoint(true, elementName);
            } else if (elementName.equals("point")) {
                this._addPoint(true, elementName);
            } else if (elementName.equals("reuseDatasets")) {
                ((Plot)this._plot).setReuseDatasets(true);
            } else {
                super.startElement(elementName);
            }
        }
        catch (Exception ex) {
            if (ex instanceof XmlException) {
                throw (XmlException)ex;
            }
            System.err.println(ex.toString());
            ex.printStackTrace();
            String msg = "XML element \"" + elementName + "\" triggers exception:\n  " + ex.toString();
            throw new XmlException(msg, this._currentExternalEntity(), this._parser.getLineNumber(), this._parser.getColumnNumber());
        }
        this._attributes.clear();
    }

    protected void _addPoint(boolean connected, String element) throws Exception {
        double x;
        String xSpec = (String)this._attributes.get("x");
        if (xSpec == null) {
            x = this._currentPointCount;
            this._currentPointCount += 1.0;
        } else {
            x = Double.valueOf(xSpec);
        }
        String ySpec = (String)this._attributes.get("y");
        this._checkForNull(ySpec, "No y value for element \"" + element + "\"");
        double y = Double.valueOf(ySpec);
        String lowSpec = (String)this._attributes.get("lowErrorBar");
        String highSpec = (String)this._attributes.get("highErrorBar");
        if (lowSpec == null && highSpec == null) {
            ((Plot)this._plot).addPoint(this._currentDataset, x, y, connected);
        } else {
            double low = lowSpec != null ? Double.valueOf(lowSpec) : x;
            double high = highSpec != null ? Double.valueOf(highSpec) : x;
            ((Plot)this._plot).addPointWithErrorBars(this._currentDataset, x, y, low, high, connected);
        }
    }
}

