/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.text;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.clapper.util.misc.XResourceBundle;
import org.clapper.util.text.TextUtil;

public final class Duration {
    private static final long SECOND_MS = 1000L;
    private static final long MINUTE_MS = 60000L;
    private static final long HOUR_MS = 3600000L;
    private static final long DAY_MS = 86400000L;
    private static final long WEEK_MS = 604800000L;
    private static final String BUNDLE_NAME = Duration.class.getName() + "Bundle";
    private long duration_in_ms = 0L;

    public Duration() {
        this(0L);
    }

    public Duration(long milliseconds) {
        this.duration_in_ms = milliseconds;
    }

    public Duration(Date date1, Date date2) {
        long ms1 = date1.getTime();
        long ms2 = date2.getTime();
        this.duration_in_ms = Math.abs(ms1 - ms2);
    }

    public Duration(String s, Locale locale) throws ParseException {
        this.parse(s, locale);
    }

    public Duration(String s) throws ParseException {
        this.parse(s, Locale.getDefault());
    }

    public long getDuration() {
        return this.duration_in_ms;
    }

    public String format() {
        return this.format(Locale.getDefault());
    }

    public String format(Locale locale) {
        Map<DurationType, DurationForFormat> map = this.getFormatterMap(locale);
        long milliseconds = this.duration_in_ms;
        long days = milliseconds / 86400000L;
        long hours = (milliseconds -= days * 86400000L) / 3600000L;
        long minutes = (milliseconds -= hours * 3600000L) / 60000L;
        long seconds = (milliseconds -= minutes * 60000L) / 1000L;
        milliseconds -= seconds * 1000L;
        StringBuilder buf = new StringBuilder();
        String sep = "";
        if (days > 0L) {
            this.formatForDurationUnit(days, map.get((Object)DurationType.DAY), buf, sep);
            sep = ", ";
        }
        if (hours > 0L) {
            this.formatForDurationUnit(hours, map.get((Object)DurationType.HOUR), buf, sep);
            sep = ", ";
        }
        if (minutes > 0L) {
            this.formatForDurationUnit(minutes, map.get((Object)DurationType.MINUTE), buf, sep);
            sep = ", ";
        }
        if (seconds > 0L) {
            this.formatForDurationUnit(seconds, map.get((Object)DurationType.SECOND), buf, sep);
            sep = ", ";
        }
        if (milliseconds > 0L) {
            this.formatForDurationUnit(milliseconds, map.get((Object)DurationType.MILLISECOND), buf, sep);
            sep = ", ";
        }
        return buf.toString();
    }

    public void parse(String s) throws ParseException {
        this.parse(s, Locale.getDefault());
    }

    public void parse(String s, Locale locale) throws ParseException {
        Map<String, DurationType> tokenMap = this.getParserMap(locale);
        String[] tokens = TextUtil.split(s, ", ");
        if (tokens.length % 2 != 0) {
            throw new ParseException("Malformed duration string \"" + s + "\"", 0);
        }
        this.duration_in_ms = 0L;
        block10: for (int i = 0; i < tokens.length; i += 2) {
            long num = 0L;
            try {
                num = Long.parseLong(tokens[i]);
                if (num < 0L) {
                    throw new ParseException("Unexpected negative value in \"" + s + "\"", 0);
                }
            }
            catch (NumberFormatException ex) {
                throw new ParseException("In \"" + s + "\", Expected numeric token \"" + tokens[i] + "\" is not numeric.", 0);
            }
            DurationType t = tokenMap.get(tokens[i + 1].toLowerCase());
            if (t == null) {
                throw new ParseException("In \"" + s + "\", found unknown duration \"" + tokens[i + 1] + "\"", 0);
            }
            switch (t) {
                case MILLISECOND: {
                    this.duration_in_ms += num;
                    continue block10;
                }
                case SECOND: {
                    this.duration_in_ms += num * 1000L;
                    continue block10;
                }
                case MINUTE: {
                    this.duration_in_ms += num * 60000L;
                    continue block10;
                }
                case HOUR: {
                    this.duration_in_ms += num * 3600000L;
                    continue block10;
                }
                case DAY: {
                    this.duration_in_ms += num * 86400000L;
                    continue block10;
                }
                case WEEK: {
                    this.duration_in_ms += num * 604800000L;
                    continue block10;
                }
                default: {
                    assert (false);
                    continue block10;
                }
            }
        }
    }

    public String toString() {
        return String.valueOf(this.getDuration());
    }

    private void formatForDurationUnit(long count, DurationForFormat tokens, StringBuilder buf, String separator) {
        if (tokens == null) {
            throw new IllegalStateException("Unexpected null DurationForFormat");
        }
        if (count > 0L) {
            String duration = count == 1L ? tokens.singular : tokens.plural;
            buf.append(separator);
            buf.append(String.valueOf(count));
            buf.append(" ");
            buf.append(duration);
        }
    }

    private Map<DurationType, DurationForFormat> getFormatterMap(Locale locale) {
        HashMap<DurationType, DurationForFormat> map = new HashMap<DurationType, DurationForFormat>();
        XResourceBundle bundle = XResourceBundle.getXResourceBundle(BUNDLE_NAME, locale);
        this.loadBundle(bundle, null, map);
        return map;
    }

    private Map<String, DurationType> getParserMap(Locale locale) throws IllegalStateException {
        HashMap<String, DurationType> map = new HashMap<String, DurationType>();
        XResourceBundle bundle = XResourceBundle.getXResourceBundle(BUNDLE_NAME, locale);
        this.loadBundle(bundle, map, null);
        bundle = XResourceBundle.getXResourceBundle(BUNDLE_NAME);
        this.loadBundle(bundle, map, null);
        return map;
    }

    private void loadBundle(XResourceBundle bundle, Map<String, DurationType> mapByToken, Map<DurationType, DurationForFormat> mapByType) throws IllegalStateException {
        this.parseTokensFor(DurationType.MILLISECOND, bundle.getString("millisecondTokens", "millisecond/milliseconds/ms"), mapByToken, mapByType);
        this.parseTokensFor(DurationType.SECOND, bundle.getString("secondTokens", "second/seconds/sec/secs"), mapByToken, mapByType);
        this.parseTokensFor(DurationType.MINUTE, bundle.getString("minuteTokens", "minute/minutes/min/mins"), mapByToken, mapByType);
        this.parseTokensFor(DurationType.HOUR, bundle.getString("hourTokens", "hour/hours/hr/hrs"), mapByToken, mapByType);
        this.parseTokensFor(DurationType.DAY, bundle.getString("dayTokens", "day/days"), mapByToken, mapByType);
        this.parseTokensFor(DurationType.WEEK, bundle.getString("weekTokens", "week/weeks"), mapByToken, mapByType);
    }

    private void parseTokensFor(DurationType durationType, String unparsedValue, Map<String, DurationType> mapByToken, Map<DurationType, DurationForFormat> mapByType) throws IllegalStateException {
        String[] tokens = TextUtil.split(unparsedValue, '/');
        if (tokens.length < 2) {
            throw new IllegalStateException("Error in resource bundle: Must have at least two tokens in duration string. \"" + unparsedValue + "\" only has " + tokens.length);
        }
        if (mapByToken != null) {
            for (String token : tokens) {
                mapByToken.put(token.toLowerCase(), durationType);
            }
        }
        if (mapByType != null) {
            mapByType.put(durationType, new DurationForFormat(tokens[0].toLowerCase(), tokens[1].toLowerCase()));
        }
    }

    private static enum DurationType {
        MILLISECOND,
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        WEEK;

    }

    private static class DurationForFormat {
        final String singular;
        final String plural;

        DurationForFormat(String singular, String plural) {
            this.singular = singular;
            this.plural = plural;
        }
    }
}

