/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OrderedHashMap<K, V>
extends HashMap<K, V>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private LinkedList<K> keysInOrder = new LinkedList();

    public OrderedHashMap() {
    }

    public OrderedHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public OrderedHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public OrderedHashMap(Map<? extends K, ? extends V> map) {
        super(map);
        this.keysInOrder.addAll(map.keySet());
    }

    public OrderedHashMap(OrderedHashMap<? extends K, ? extends V> map) {
        super(map);
        this.keysInOrder.addAll(map.keysInOrder);
    }

    public int getKeysInInsertionOrder(List<? super K> list) {
        list.addAll(this.keysInOrder);
        return this.keysInOrder.size();
    }

    public List<K> keysInInsertionOrder() {
        return new ArrayList<K>(this.keysInOrder);
    }

    @Override
    public Object clone() {
        return new OrderedHashMap<K, V>(this);
    }

    @Override
    public void clear() {
        super.clear();
        this.keysInOrder.clear();
    }

    @Override
    public V put(K key, V value) {
        V oldValue = super.put(key, value);
        this.keysInOrder.remove(key);
        this.keysInOrder.add(key);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (K key : map.keySet()) {
            V value = map.get(key);
            this.put(key, value);
        }
    }

    @Override
    public void putAll(OrderedHashMap<? extends K, ? extends V> map) {
        for (K key : map.keysInInsertionOrder()) {
            Object value = map.get(key);
            this.put(key, value);
        }
    }

    @Override
    public V remove(Object key) {
        Object oldValue = super.remove(key);
        this.keysInOrder.remove(key);
        return oldValue;
    }
}

