/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.util.Date;
import org.clapper.util.misc.Semaphore;
import org.clapper.util.misc.SemaphoreException;

public class ObjectLockSemaphore
implements Semaphore {
    private int count = 0;

    public ObjectLockSemaphore(int initialCount) {
        this.count = initialCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acquire(long timeout) throws SemaphoreException {
        boolean acquired = false;
        ObjectLockSemaphore objectLockSemaphore = this;
        synchronized (objectLockSemaphore) {
            if (this.count > 0) {
                acquired = true;
            } else if (timeout == 0L) {
                this.waitForever();
                acquired = true;
            } else if (timeout > 0L) {
                acquired = this.waitOrTimeOut(timeout);
            }
            if (acquired) {
                --this.count;
            }
            this.notifyAll();
        }
        return acquired;
    }

    @Override
    public boolean acquire() throws SemaphoreException {
        return this.acquire(0L);
    }

    @Override
    public synchronized void addToCount(int delta) throws SemaphoreException {
        this.count += delta;
        this.notifyAll();
    }

    @Override
    public synchronized int getValue() throws SemaphoreException {
        return this.count;
    }

    @Override
    public synchronized void release() throws SemaphoreException {
        ++this.count;
        this.notifyAll();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Semaphore[");
        buf.append(Integer.toHexString(this.hashCode()));
        buf.append(", value=");
        buf.append(String.valueOf(this.count));
        buf.append(']');
        return buf.toString();
    }

    private void waitForever() {
        boolean available = false;
        while (!available) {
            try {
                this.wait();
                if (this.count <= 0) continue;
                available = true;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean waitOrTimeOut(long timeout) {
        Date end;
        boolean available = false;
        Date start = new Date();
        for (long elapsed = 0L; !available && elapsed < timeout; elapsed += end.getTime() - start.getTime()) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            end = new Date();
            if (this.count <= 0) continue;
            available = true;
        }
        return available;
    }
}

