/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.File;
import java.util.Comparator;
import org.clapper.util.io.FileUtil;

public class FileNameComparator
implements Comparator<Object> {
    private boolean foldCase = false;
    private boolean entirePath = false;

    public FileNameComparator() {
        this(false, false);
    }

    public FileNameComparator(boolean foldCase, boolean entirePath) {
        this.foldCase = foldCase;
        this.entirePath = entirePath;
    }

    @Override
    public int compare(Object o1, Object o2) {
        String s1 = this.getFileName(o1);
        String s2 = this.getFileName(o2);
        int cmp = 0;
        cmp = this.foldCase ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2);
        return cmp;
    }

    @Override
    public boolean equals(Object o) {
        boolean eq = false;
        if (o instanceof FileNameComparator) {
            FileNameComparator other = (FileNameComparator)o;
            eq = other.foldCase == this.foldCase && other.entirePath == this.entirePath;
        }
        return eq;
    }

    public int hashCode() {
        return super.hashCode();
    }

    private String getFileName(Object o) {
        String name = null;
        name = o instanceof File ? ((File)o).getPath() : (String)o;
        if (!this.entirePath) {
            name = FileUtil.basename(name);
        }
        return name;
    }
}

