/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.cmdline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.clapper.util.cmdline.OptionComparator;
import org.clapper.util.cmdline.OptionInfo;

public final class UsageInfo {
    public static final char NO_SHORT_OPTION = '\u0000';
    public static final char SHORT_OPTION_PREFIX = '-';
    public static final String LONG_OPTION_PREFIX = "--";
    private Map<Character, OptionInfo> shortOptionMap = new HashMap<Character, OptionInfo>();
    private Map<String, OptionInfo> longOptionMap = new HashMap<String, OptionInfo>();
    private Set<OptionInfo> allOptions = new TreeSet<OptionInfo>(new OptionComparator());
    private Map<String, String> paramMap = new HashMap<String, String>();
    private Set<String> requiredParams = new HashSet<String>();
    private List<String> paramNames = new ArrayList<String>();
    private String usagePrologue = null;
    private String usageTrailer = null;
    private String commandName = null;

    public String getCommandName() {
        return this.commandName;
    }

    public void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    public void addOption(char shortOption, String longOption, String explanation) {
        this.addOption(shortOption, longOption, null, explanation);
    }

    public void addOption(char shortOption, String longOption, String argToken, String explanation) {
        if (longOption != null && longOption.charAt(0) == '-') {
            throw new IllegalArgumentException("(BUG) Long option \"" + longOption + "\", registered via UsageInfo.addOption(), starts with \"-\".");
        }
        if (shortOption == '\u0000' && longOption == null) {
            throw new IllegalArgumentException("(BUG) shortOption parameter is NO_SHORT_OPTION, and longOption parameter is null.");
        }
        OptionInfo optionInfo = new OptionInfo(shortOption, longOption, argToken, explanation);
        if (shortOption != '\u0000') {
            this.shortOptionMap.put(Character.valueOf(shortOption), optionInfo);
        }
        if (longOption != null) {
            this.longOptionMap.put(longOption, optionInfo);
        }
        this.allOptions.add(optionInfo);
    }

    public void addParameter(String param, String explanation, boolean required) {
        if (param.charAt(0) == '-') {
            throw new IllegalArgumentException("(BUG) Option \"" + param + "\" registered via UsageInfo.addParameter(), instead of via UsageInfo.addOption().");
        }
        this.paramMap.put(param, explanation);
        this.paramNames.add(param);
        if (required) {
            this.requiredParams.add(param);
        }
    }

    public void addUsagePrologue(String prologue) {
        this.usagePrologue = prologue;
    }

    public void addUsageTrailer(String trailer) {
        this.usageTrailer = trailer;
    }

    String[] getParameterNames() {
        String[] names = new String[this.paramNames.size()];
        int i = 0;
        Iterator<String> it = this.paramNames.iterator();
        while (it.hasNext()) {
            names[i] = it.next();
            ++i;
        }
        return names;
    }

    boolean parameterIsRequired(String name) {
        return this.requiredParams.contains(name);
    }

    String getParameterExplanation(String name) {
        return this.paramMap.get(name);
    }

    OptionInfo getOptionInfo(char shortOption) {
        return this.shortOptionMap.get(Character.valueOf(shortOption));
    }

    OptionInfo getOptionInfo(String longOption) {
        return this.longOptionMap.get(longOption);
    }

    OptionInfo[] getOptions() {
        OptionInfo[] options = new OptionInfo[this.allOptions.size()];
        int i = 0;
        Iterator<OptionInfo> it = this.allOptions.iterator();
        while (it.hasNext()) {
            options[i] = it.next();
            ++i;
        }
        Arrays.sort(options, new OptionComparator(true));
        return options;
    }

    String getUsagePrologue() {
        return this.usagePrologue;
    }

    String getUsageTrailer() {
        return this.usageTrailer;
    }
}

