/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.cmdline;

import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.clapper.util.cmdline.CommandLineException;
import org.clapper.util.cmdline.CommandLineUsageException;
import org.clapper.util.cmdline.ParameterHandler;
import org.clapper.util.cmdline.ParameterParser;
import org.clapper.util.cmdline.UsageInfo;
import org.clapper.util.logging.Logger;
import org.clapper.util.misc.BundleUtil;

public abstract class CommandLineUtility {
    private ParameterParser paramParser = null;

    protected CommandLineUtility() {
    }

    public final void execute(String[] args) throws CommandLineException {
        try {
            this.paramParser = new ParameterParser(this.getUsageInfo());
            this.parseParams(args);
            this.runCommand();
        }
        catch (CommandLineUsageException ex) {
            this.usage(ex.getMessage());
            throw ex;
        }
        catch (CommandLineException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CommandLineException(ex);
        }
    }

    protected void parseCustomOption(char shortOption, String longOption, Iterator<String> it) throws CommandLineUsageException, NoSuchElementException {
        throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.parseCustomOption", "(BUG) custom option found, but class {0} provides no parseCustomOption method.", new Object[]{this.getClass().getName()});
    }

    protected void processPostOptionCommandLine(Iterator<String> it) throws CommandLineUsageException, NoSuchElementException {
        if (it.hasNext()) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.extraParams", "Extra command line parameter(s).");
        }
    }

    protected void getCustomUsageInfo(UsageInfo info) {
    }

    protected abstract void runCommand() throws CommandLineException;

    protected int parseIntParameter(String value) throws CommandLineUsageException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.badIntegerParam", "Bad integer command line parameter \"{0}\"", new Object[]{value});
        }
    }

    protected int parseIntParameter(String value, int min, int max) throws CommandLineUsageException {
        int result = this.parseIntParameter(value);
        if (result < min) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericParamTooSmall", "Numeric parameter {0} is less than the minimum legal value of {1}", new Object[]{value, String.valueOf(min)});
        }
        if (result > max) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericParamTooLarge", "Numeric parameter {0} is greater than the maximum legal value of {1}", new Object[]{value, String.valueOf(max)});
        }
        return result;
    }

    protected int parseIntOptionArgument(char shortOption, String longOption, String value) throws CommandLineUsageException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.badIntegerOption", "Bad integer command line parameter \"{0}\" for option {1}", new Object[]{value, this.getOptionStringForError(shortOption, longOption)});
        }
    }

    protected int parseIntOptionArgument(char shortOption, String longOption, String value, int min, int max) throws CommandLineUsageException {
        int result = this.parseIntOptionArgument(shortOption, longOption, value);
        if (result < min) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericOptionParamTooSmall", "Numeric parameter {0} for option {1} is less than the minimum legal value of {2}", new Object[]{value, this.getOptionStringForError(shortOption, longOption), String.valueOf(min)});
        }
        if (result > max) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericOptionParamTooLarge", "Numeric parameter {0} for option {1} is greater than the maximum legal value of {2}", new Object[]{value, this.getOptionStringForError(shortOption, longOption), String.valueOf(max)});
        }
        return result;
    }

    protected float parseFloatParameter(String value) throws CommandLineUsageException {
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException ex) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.badFloatParam", "Bad floating point command line parameter \"{0}\"", new Object[]{value});
        }
    }

    protected float parseFloatParameter(String value, float min, float max) throws CommandLineUsageException {
        float result = this.parseFloatParameter(value);
        if (result < min) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericParamTooSmall", "Numeric parameter {0} is less than the minimum legal value of {1}", new Object[]{value, String.valueOf(min)});
        }
        if (result > max) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericParamTooLarge", "Numeric parameter {0} is greater than the maximum legal value of {1}", new Object[]{value, String.valueOf(max)});
        }
        return result;
    }

    protected float parseFloatOptionArgument(char shortOption, String longOption, String value) throws CommandLineUsageException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.badFloatParam", "Bad floating point command line parameter \"{0}\" for option {1}", new Object[]{value, this.getOptionStringForError(shortOption, longOption)});
        }
    }

    protected float parseFloatOptionArgument(char shortOption, String longOption, String value, float min, float max) throws CommandLineUsageException {
        float result = this.parseFloatOptionArgument(shortOption, longOption, value);
        if (result < min) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericOptionParamTooSmall", "Numeric parameter {0} for option {1} is less than the minimum legal value of {2}", new Object[]{value, this.getOptionStringForError(shortOption, longOption), String.valueOf(min)});
        }
        if (result > max) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericOptionParamTooLarge", "Numeric parameter {0} for option {1} is greater than the maximum legal value of {2}", new Object[]{value, this.getOptionStringForError(shortOption, longOption), String.valueOf(max)});
        }
        return result;
    }

    protected double parseDoubleParameter(String value) throws CommandLineUsageException {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.badDoubleParam", "Bad double floating point command line parameter \"{0}\"", new Object[]{value});
        }
    }

    protected double parseDoubleParameter(String value, double min, double max) throws CommandLineUsageException {
        double result = this.parseDoubleParameter(value);
        if (result < min) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericParamTooSmall", "Numeric parameter {0} is less than the minimum legal value of {1}", new Object[]{value, String.valueOf(min)});
        }
        if (result > max) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericParamTooLarge", "Numeric parameter {0} is greater than the maximum legal value of {1}", new Object[]{value, String.valueOf(max)});
        }
        return result;
    }

    protected double parseDoubleOptionArgument(char shortOption, String longOption, String value) throws CommandLineUsageException {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.badDoubleOption", "Bad double command line parameter \"{0}\" for option {1}", new Object[]{value, this.getOptionStringForError(shortOption, longOption)});
        }
    }

    protected double parseDoubleOptionArgument(char shortOption, String longOption, String value, double min, double max) throws CommandLineUsageException {
        double result = this.parseDoubleOptionArgument(shortOption, longOption, value);
        if (result < min) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericOptionParamTooSmall", "Numeric parameter {0} for option {1} is less than the minimum legal value of {2}", new Object[]{value, this.getOptionStringForError(shortOption, longOption), String.valueOf(min)});
        }
        if (result > max) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericOptionParamTooSmall", "Numeric parameter {0} for option {1} is greater than the maximum legal value of {2}", new Object[]{value, this.getOptionStringForError(shortOption, longOption), String.valueOf(max)});
        }
        return result;
    }

    private void parseParams(String[] args) throws CommandLineUsageException {
        ParameterHandler handler = new ParameterHandler(){

            @Override
            public void parseOption(char shortOption, String longOption, Iterator<String> it) throws CommandLineUsageException, NoSuchElementException {
                if (longOption != null && longOption.equals("logging")) {
                    Logger.enableLogging();
                } else {
                    CommandLineUtility.this.parseCustomOption(shortOption, longOption, it);
                }
            }

            @Override
            public void parsePostOptionParameters(Iterator<String> it) throws CommandLineUsageException, NoSuchElementException {
                CommandLineUtility.this.processPostOptionCommandLine(it);
            }
        };
        this.paramParser.parse(args, handler);
    }

    private void usage(String prefixMsg) {
        System.err.println(this.paramParser.getUsageMessage(prefixMsg, 78));
    }

    private UsageInfo getUsageInfo() {
        UsageInfo info = new UsageInfo();
        this.getCustomUsageInfo(info);
        info.addOption('\u0000', "logging", BundleUtil.getMessage("org.clapper.util.cmdline.Bundle", Locale.getDefault(), "CommandLineUtility.logging", "Enable logging via the java.util.logging API."));
        return info;
    }

    private String getOptionStringForError(char shortOption, String longOption) {
        StringBuffer buf = new StringBuffer();
        boolean paren = false;
        if (longOption != null) {
            buf.append("--");
            buf.append(longOption);
            paren = true;
        }
        if (shortOption != '\u0000') {
            if (paren) {
                buf.append(" (");
            }
            buf.append('-');
            buf.append(shortOption);
            if (paren) {
                buf.append(')');
            }
        }
        assert (buf.length() > 0);
        return buf.toString();
    }
}

