/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.colorchooser;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import javax.swing.JComponent;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.java.dev.colorchooser.ColorChooser;
import net.java.dev.colorchooser.Palette;

class PalettePopup
extends MouseAdapter
implements MouseMotionListener,
PropertyChangeListener {
    private Popup pop = null;
    private PalettePanel panel = null;
    private Palette pal = null;
    private static Reference defaultInstance = null;
    private ColorChooser lastOwner;
    private Point lastCoords;

    private PalettePopup() {
    }

    public static PalettePopup getDefault() {
        PalettePopup result = null;
        if (defaultInstance != null) {
            result = (PalettePopup)defaultInstance.get();
        }
        if (result == null) {
            result = new PalettePopup();
            defaultInstance = new SoftReference<PalettePopup>(result);
        }
        return result;
    }

    private PalettePanel getPalettePanel() {
        if (this.panel == null) {
            this.panel = new PalettePanel();
        }
        return this.panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPalette(Palette pal) {
        if (pal != this.pal) {
            if (this.isPopupVisible()) {
                Dimension oldSize;
                Dimension newSize = pal.getSize();
                if (newSize.equals(oldSize = this.pal.getSize())) {
                    this.panel.setPalette(pal);
                    this.panel.repaint();
                } else {
                    Object object = this.lastOwner.getTreeLock();
                    synchronized (object) {
                        this.pop.hide();
                        this.panel.setPalette(pal);
                        this.pop = PopupFactory.getSharedInstance().getPopup(this.lastOwner, this.getPalettePanel(), this.lastCoords.x, this.lastCoords.y);
                        this.pop.show();
                    }
                }
            }
            this.pal = pal;
        }
    }

    private Palette getPalette() {
        return this.pal;
    }

    public void showPopup(ColorChooser owner, Point coords) {
        if (this.pal == null) {
            throw new IllegalStateException("No palette specified");
        }
        this.setPopupOwner(owner);
        this.lastCoords = coords;
        if (this.pop != null) {
            this.pop.hide();
            this.pop = null;
        }
        PalettePanel pp = this.getPalettePanel();
        pp.setPalette(this.getPalette());
        Dimension sz = pp.getPreferredSize();
        Rectangle r = owner.getGraphicsConfiguration().getDevice().getDefaultConfiguration().getBounds();
        Rectangle test = new Rectangle(coords, sz);
        if (!r.contains(test)) {
            int offy = Math.max(0, test.y + test.height - (r.y + r.height));
            int offx = Math.max(0, test.x + test.width - (r.x + r.width));
            coords.x -= offx;
            coords.y -= offy;
        }
        this.pop = PopupFactory.getSharedInstance().getPopup(owner, pp, coords.x, coords.y);
        this.pop.show();
        owner.firePickerVisible(true);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this);
    }

    private void setPopupOwner(ColorChooser owner) {
        if (this.lastOwner == owner) {
            return;
        }
        if (this.lastOwner != null) {
            this.detachFromOwner();
            this.lastOwner.firePickerVisible(false);
        }
        this.attachToOwner(owner);
    }

    private void detachFromOwner() {
        if (this.lastOwner != null) {
            this.lastOwner.removeMouseMotionListener(this);
            this.lastOwner.removeMouseListener(this);
        }
        this.lastOwner = null;
    }

    private void attachToOwner(ColorChooser owner) {
        this.lastOwner = owner;
        owner.addMouseListener(this);
        owner.addMouseMotionListener(this);
    }

    public void hidePopup(ColorChooser owner) {
        if (owner != this.lastOwner) {
            return;
        }
        this.hidePopup();
    }

    private void hidePopup() {
        if (this.pop != null) {
            this.pop.hide();
            this.pop = null;
            this.detachFromOwner();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this);
        }
    }

    private boolean isPopupVisible() {
        return this.pop != null;
    }

    public boolean isPopupVisible(ColorChooser chooser) {
        return this.lastOwner == chooser && this.isPopupVisible();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point p = e.getPoint();
        SwingUtilities.convertPointToScreen(p, this.lastOwner);
        this.convertPointToPalette(p);
        Dimension d = this.panel.getOffset();
        if (d != null) {
            p.x -= d.width;
            p.y -= d.height;
        }
        if (p.x >= 0 && p.y >= 0 && p.x <= this.pal.getSize().width && p.y < this.pal.getSize().height) {
            this.lastOwner.setTransientColor(this.pal.getColorAt(p.x, p.y));
            this.panel.setDisplayTitle(this.pal.getNameAt(p.x, p.y));
        } else {
            this.lastOwner.setTransientColor(null);
            this.panel.setDisplayTitle(null);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private void convertPointToPalette(Point p) {
        p.x -= this.lastCoords.x;
        p.y -= this.lastCoords.y;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object o;
        if ("focusOwner".equals(evt.getPropertyName()) && (o = evt.getNewValue()) != this.panel && o != this.lastOwner) {
            this.hidePopup();
        }
    }

    private class PalettePanel
    extends JComponent {
        private static final long serialVersionUID = 1L;
        private Palette pal = null;
        private String title = null;

        private PalettePanel() {
        }

        public void setPalette(Palette pal) {
            Dimension oldSize = null;
            if (pal != null && this.isShowing()) {
                oldSize = pal.getSize();
            }
            this.pal = pal;
            if (oldSize != null && pal != null && !pal.getSize().equals(oldSize)) {
                this.firePropertyChange("preferredSize", oldSize, pal.getSize());
            }
        }

        public Dimension getOffset() {
            if (this.pal == null || this.pal.getDisplayName() == null) {
                return null;
            }
            return new Dimension(0, (this.getPreferredSize().height - this.pal.getSize().height) / 2);
        }

        @Override
        public void paintComponent(Graphics g) {
            Dimension d = this.pal.getSize();
            int y = this.getHeight() - d.height;
            if (this.pal.getDisplayName() != null) {
                GradientPaint gp = new GradientPaint(0.0f, 0.0f, UIManager.getColor("controlHighlight"), 0.0f, y / 2, UIManager.getColor("controlShadow"));
                ((Graphics2D)g).setPaint(gp);
                g.fillRect(0, 0, this.getWidth(), y / 2);
                String s = this.pal.getDisplayName();
                g.setFont(this.getFont().deriveFont(1, this.getFont().getSize() - 2));
                int ht = g.getFontMetrics(g.getFont()).getHeight();
                int wid = g.getFontMetrics(g.getFont()).stringWidth(s);
                int xpos = this.getWidth() / 2 - wid / 2;
                g.setColor(UIManager.getColor("controlShadow"));
                g.drawLine(0, 0, this.getWidth() - 1, 0);
                g.drawLine(0, 0, 0, y / 2 - 1);
                g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, y / 2 - 1);
                g.setColor(UIManager.getColor("textText"));
                g.drawString(s, xpos, ht - 3);
                g.translate(0, y / 2);
            }
            this.pal.paintTo(g);
            int top = this.pal.getDisplayName() == null ? y : y / 2;
            int bottom = this.pal.getDisplayName() == null ? this.getHeight() : this.getHeight() - top;
            GradientPaint gp = new GradientPaint(0.0f, this.getHeight() - y, UIManager.getColor("controlHighlight"), 0.0f, bottom, UIManager.getColor("controlShadow"));
            ((Graphics2D)g).setPaint(gp);
            g.fillRect(0, this.getHeight() - y, this.getWidth(), top);
            if (this.title != null) {
                g.setColor(UIManager.getColor("textText"));
                g.setFont(this.getFont().deriveFont(0, this.getFont().getSize() - 2));
                int xp = this.getWidth() - g.getFontMetrics(g.getFont()).stringWidth(this.title) - 3;
                g.drawString(this.title, xp, this.getHeight() - (this.pal.getDisplayName() == null ? 4 : y / 2 + 4));
            }
            g.setColor(UIManager.getColor("controlShadow"));
            g.drawLine(0, this.getHeight() - y, 0, this.getHeight());
            g.drawLine(0, this.getHeight() - (top + 1), this.getWidth() - 1, this.getHeight() - (top + 1));
            g.drawLine(this.getWidth() - 1, this.getHeight() - (top + 1), this.getWidth() - 1, this.getHeight() - y);
        }

        public void setDisplayTitle(String s) {
            if (s != this.title && (s != null != (this.title != null) || s != null && !s.equals(this.title))) {
                this.title = s;
                this.repaint();
            }
            if (s == null && this.title != null) {
                this.title = null;
                this.repaint();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.pal != null) {
                Dimension result = new Dimension(this.pal.getSize());
                int spacing = 14;
                if (PalettePopup.this.lastOwner != null) {
                    Graphics g = PalettePopup.this.lastOwner.getGraphics();
                    if (g == null) {
                        try {
                            g = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(1, 1).createGraphics();
                        }
                        catch (SecurityException e) {
                            g = new BufferedImage(1, 1, 2).createGraphics();
                        }
                    }
                    if (g != null) {
                        Font f;
                        Font font = f = this.getFont() == null ? UIManager.getFont("controlFont") : this.getFont();
                        if (f == null) {
                            f = new Font("Serif", 0, 12);
                        }
                        spacing = g.getFontMetrics(f.deriveFont(0, f.getSize() - 2)).getHeight();
                    }
                    g.dispose();
                }
                if (this.pal.getDisplayName() != null) {
                    spacing *= 2;
                }
                result.height += spacing;
                return result;
            }
            return new Dimension(10, 10);
        }
    }
}

