/*
 * Decompiled with CFR 0.152.
 */
package com.csam.dif;

import com.csam.dif.DIFDataException;
import com.csam.dif.DIFSheet;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;

public final class DIFCell {
    private Object value;
    private DIFSheet sheet;
    private int rowNumber;
    private int cellNumber;
    private CellType cellType;

    protected DIFCell(DIFSheet sheet, int rowNumber, int cellNumber, CellType cellType) {
        this.sheet = sheet;
        this.rowNumber = rowNumber;
        this.cellNumber = cellNumber;
        this.setCellType(cellType);
        if (cellType.equals((Object)CellType.BLANK) || cellType.equals((Object)CellType.STRING)) {
            this.value = "";
        } else if (cellType.equals((Object)CellType.BOOLEAN)) {
            this.value = Boolean.FALSE;
        } else if (cellType.equals((Object)CellType.NUMERIC)) {
            this.value = BigDecimal.ZERO;
        } else if (cellType.equals((Object)CellType.DATE)) {
            this.value = new Date(System.currentTimeMillis());
        }
    }

    protected DIFSheet getSheet() {
        return this.sheet;
    }

    public void setCellType(CellType cellType) {
        this.cellType = cellType;
    }

    public CellType getCellType() {
        return this.cellType;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public int getCellNumber() {
        return this.cellNumber;
    }

    public void setCellValue(boolean value) {
        this.setCellType(CellType.BOOLEAN);
        this.value = value;
    }

    public void setCellValue(BigDecimal value) {
        this.setCellType(CellType.NUMERIC);
        this.value = value;
    }

    public void setCellValue(double value) {
        this.setCellValue(BigDecimal.valueOf(value));
    }

    public void setCellValue(long value) {
        this.setCellValue((double)value);
    }

    public void setCellValue(int value) {
        this.setCellValue((double)value);
    }

    public void setCellValue(String value) {
        this.setCellType(CellType.STRING);
        this.value = value;
    }

    public void setCellValue(Date value) {
        this.setCellType(CellType.DATE);
        this.value = value;
    }

    public boolean getBooleanCellValue() throws DIFDataException {
        if (this.getCellType().equals((Object)CellType.BLANK)) {
            return false;
        }
        if (this.getCellType().equals((Object)CellType.BOOLEAN)) {
            return (Boolean)this.value;
        }
        if (this.getCellType().equals((Object)CellType.NUMERIC)) {
            return this.getNumericCellValue().compareTo(BigDecimal.ZERO) != 0;
        }
        if (this.getCellType().equals((Object)CellType.STRING)) {
            return Boolean.valueOf(this.getStringCellValue());
        }
        throw new DIFDataException("Type '" + this.getCellType().name() + "' cannot be cast to boolean");
    }

    public BigDecimal getNumericCellValue() throws DIFDataException {
        if (this.getCellType().equals((Object)CellType.BLANK)) {
            return BigDecimal.ZERO;
        }
        if (this.getCellType().equals((Object)CellType.BOOLEAN)) {
            return (Boolean)this.value != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        if (this.getCellType().equals((Object)CellType.NUMERIC)) {
            return (BigDecimal)this.value;
        }
        if (this.getCellType().equals((Object)CellType.STRING)) {
            return new BigDecimal(this.getStringCellValue());
        }
        throw new DIFDataException("Type '" + this.getCellType().name() + "' cannot be cast to boolean");
    }

    public String getStringCellValue() throws DIFDataException {
        if (this.getCellType().equals((Object)CellType.BLANK)) {
            return "";
        }
        if (this.getCellType().equals((Object)CellType.DATE)) {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
            return fmt.format(this.getDateCellValue());
        }
        return String.valueOf(this.value);
    }

    public Date getDateCellValue() throws DIFDataException {
        if (this.getCellType().equals((Object)CellType.DATE)) {
            return (Date)this.value;
        }
        throw new DIFDataException("Type '" + this.getCellType().name() + "' cannot be cast to boolean");
    }

    public double getDoubleCellValue() throws DIFDataException {
        return this.getNumericCellValue().doubleValue();
    }

    public long getLongCellValue() throws DIFDataException {
        return this.getNumericCellValue().longValueExact();
    }

    public long getIntCellValue() throws DIFDataException {
        return this.getNumericCellValue().intValueExact();
    }

    protected void cleanUp() {
        this.setCellValue("");
    }

    public static enum CellType {
        BLANK,
        BOOLEAN,
        NUMERIC,
        STRING,
        DATE;

    }
}

