/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.io;

import java.io.PrintWriter;
import java.io.Writer;
import org.jgrapht.Graph;
import org.jgrapht.io.AbstractBaseExporter;
import org.jgrapht.io.ComponentNameProvider;
import org.jgrapht.io.GraphExporter;
import org.jgrapht.io.StringComponentNameProvider;

public class VisioExporter<V, E>
extends AbstractBaseExporter<V, E>
implements GraphExporter<V, E> {
    public VisioExporter(ComponentNameProvider<V> vertexIDProvider) {
        super(vertexIDProvider);
    }

    public VisioExporter() {
        this(new StringComponentNameProvider());
    }

    @Override
    public void exportGraph(Graph<V, E> g, Writer writer) {
        PrintWriter out = new PrintWriter(writer);
        for (V v : g.vertexSet()) {
            this.exportVertex(out, v);
        }
        for (Object e : g.edgeSet()) {
            this.exportEdge(out, e, g);
        }
        out.flush();
    }

    private void exportEdge(PrintWriter out, E edge, Graph<V, E> g) {
        String sourceName = this.vertexIDProvider.getName(g.getEdgeSource(edge));
        String targetName = this.vertexIDProvider.getName(g.getEdgeTarget(edge));
        out.print("Link,");
        out.print(sourceName);
        out.print("-->");
        out.print(targetName);
        out.print(",,,");
        out.print(sourceName);
        out.print(",");
        out.print(targetName);
        out.print("\n");
    }

    private void exportVertex(PrintWriter out, V vertex) {
        String name = this.vertexIDProvider.getName(vertex);
        out.print("Shape,");
        out.print(name);
        out.print(",,");
        out.print(name);
        out.print("\n");
    }
}

