/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.demo;

import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.CompleteGraphGenerator;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;
import org.jgrapht.traverse.DepthFirstIterator;

public final class CompleteGraphDemo {
    static Graph<String, DefaultEdge> completeGraph;
    static int size;

    public static void main(String[] args) {
        completeGraph = new SimpleGraph<String, DefaultEdge>(DefaultEdge.class);
        CompleteGraphGenerator<String, DefaultEdge> completeGenerator = new CompleteGraphGenerator<String, DefaultEdge>(size);
        VertexFactory<String> vFactory = new VertexFactory<String>(){
            private int id = 0;

            @Override
            public String createVertex() {
                return "v" + this.id++;
            }
        };
        completeGenerator.generateGraph(completeGraph, vFactory, (Map<String, String>)null);
        DepthFirstIterator<String, DefaultEdge> iter = new DepthFirstIterator<String, DefaultEdge>(completeGraph);
        while (iter.hasNext()) {
            String vertex = (String)iter.next();
            System.out.println("Vertex " + vertex + " is connected to: " + completeGraph.edgesOf(vertex).toString());
        }
    }

    static {
        size = 10;
    }
}

