/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.util;

import java.util.Comparator;
import org.jgrapht.UndirectedGraph;

public class VertexDegreeComparator<V, E>
implements Comparator<V> {
    private UndirectedGraph<V, E> graph;
    private Order order;

    public VertexDegreeComparator(UndirectedGraph<V, E> g) {
        this(g, Order.ASCENDING);
    }

    public VertexDegreeComparator(UndirectedGraph<V, E> g, Order order) {
        this.graph = g;
        this.order = order;
    }

    @Override
    public int compare(V v1, V v2) {
        int comparison = Integer.compare(this.graph.degreeOf(v1), this.graph.degreeOf(v2));
        if (this.order == Order.ASCENDING) {
            return comparison;
        }
        return -1 * comparison;
    }

    public static enum Order {
        ASCENDING,
        DESCENDING;

    }
}

