/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.tools;

import carmetal.construction.Selector;
import carmetal.constructors.ObjectConstructor;
import carmetal.objects.AngleObject;
import carmetal.objects.ConstructionObject;
import carmetal.objects.ExpressionObject;
import carmetal.objects.FixedAngleObject;
import carmetal.objects.PointObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.event.MouseEvent;

public class SetFixedAngle
extends ObjectConstructor
implements Selector {
    ObjectConstructor OC;
    FixedAngleObject A;
    PointObject P1;
    PointObject P2;
    PointObject P3;

    public SetFixedAngle(ZirkelCanvas zc, FixedAngleObject a2, ObjectConstructor oc) {
        this.A = a2;
        this.OC = oc;
        a2.setSelected(true);
        zc.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        if (this.P1 == null) {
            ConstructionObject o = zc.selectWithSelector(e2.getX(), e2.getY(), this);
            if (o == null) {
                return;
            }
            if (o instanceof PointObject) {
                this.P1 = (PointObject)o;
                this.P1.setSelected(true);
                this.showStatus(zc);
                zc.repaint();
            } else if (o instanceof AngleObject || o instanceof FixedAngleObject || o instanceof ExpressionObject) {
                this.A.setFixed(o.getName());
                this.A.setDragable(false);
                this.A.updateText();
                this.reset(zc);
            }
        } else if (this.P2 == null) {
            this.P2 = zc.selectPoint(e2.getX(), e2.getY());
            if (this.P2 != null) {
                this.P2.setSelected(true);
                this.showStatus(zc);
                zc.repaint();
            }
        } else {
            this.P3 = zc.selectPoint(e2.getX(), e2.getY());
            if (this.P3 == null) {
                return;
            }
            this.A.setFixed("a(" + this.P1.getName() + "," + this.P2.getName() + "," + this.P3.getName() + ")");
            this.reset(zc);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        zc.indicateWithSelector(e2.getX(), e2.getY(), this);
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        if (this.P1 == null) {
            zc.showStatus(Global.name("message.setfixedangle.first"));
        } else if (this.P2 == null) {
            zc.showStatus(Global.name("message.setfixedangle.second"));
        } else {
            zc.showStatus(Global.name("message.setfixedangle.third"));
        }
    }

    @Override
    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        zc.setTool(this.OC);
        zc.validate();
        zc.repaint();
        zc.check();
    }

    @Override
    public boolean useSmartBoard() {
        return this.P2 != null;
    }

    @Override
    public boolean isAdmissible(ZirkelCanvas zc, ConstructionObject o) {
        return (o instanceof PointObject || o instanceof AngleObject || o instanceof FixedAngleObject || o instanceof ExpressionObject) && !zc.getConstruction().dependsOn(o, this.A);
    }
}

