/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.graphics;

import carmetal.objects.ConstructionObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelFrame;
import carmetal.rene.zirkel.graphics.MyFontMetrics;
import carmetal.rene.zirkel.graphics.MyGraphics;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.PrintWriter;

public class MyGraphicsFig
extends MyGraphics {
    PrintWriter Out;
    static final int STROKE_NORMAL = 1;
    static final int STROKE_THIN = 1;
    static final int STROKE_THICK = 2;
    static final int STYLE_NORMAL = 0;
    static final int STYLE_THIN = 1;
    static final int STYLE_THICK = 0;
    int Stroke = 1;
    int Red;
    int Green;
    int Blue;
    MyFontMetrics MFM;
    int yoffset = 6000;
    String[] FigColorsArray;
    int FigLastcolor = 31;
    int FigColor = 0;
    int FigFillcolor = 0;
    int FigLinestyle = 0;
    int FigLayer = 10000;
    boolean PushLayer = true;
    int xfactor = 15;
    int yfactor = 15;
    StringBuffer FigFirstpart;
    StringBuffer FigLastpart;
    int fsize;
    boolean flarge;
    boolean fbold;
    int ffactor = Global.getParameter("ffactor", 130);

    public MyGraphicsFig(PrintWriter out, int w, int h) {
        this.FigFirstpart = new StringBuffer();
        this.FigLastpart = new StringBuffer();
        this.FigFirstpart.append("#FIG 3.2\n");
        this.FigFirstpart.append("Landscape\n");
        this.FigFirstpart.append("Center\n");
        this.FigFirstpart.append("Metric\n");
        this.FigFirstpart.append("A4\n");
        this.FigFirstpart.append("100.00\n");
        this.FigFirstpart.append("Single\n");
        this.FigFirstpart.append("-2\n");
        this.FigFirstpart.append("1200 2\n");
        this.MFM = new MyFontMetrics();
        this.Out = out;
        this.FigColorsArray = new String[543];
    }

    public void close() {
        this.append("#End\n");
        this.Out.print(this.FigFirstpart);
        this.Out.print(this.FigLastpart);
    }

    String ColorString(Color c2) {
        String stb;
        String stg;
        String coded = "#";
        String str = Integer.toHexString(c2.getRed());
        if (str.length() == 1) {
            str = "0" + str;
        }
        if ((stg = Integer.toHexString(c2.getGreen())).length() == 1) {
            stg = "0" + stg;
        }
        if ((stb = Integer.toHexString(c2.getBlue())).length() == 1) {
            stb = "0" + stb;
        }
        coded = coded + str;
        coded = coded + stg;
        coded = coded + stb;
        return coded;
    }

    @Override
    public void setColor(Color c2) {
        String codedcolor = this.ColorString(c2);
        boolean newcolor = true;
        for (int i = 32; i <= this.FigLastcolor; ++i) {
            if (!codedcolor.equals(this.FigColorsArray[i])) continue;
            this.FigColor = i;
            newcolor = false;
            break;
        }
        if (newcolor) {
            ++this.FigLastcolor;
            this.FigColor = this.FigLastcolor;
            this.FigColorsArray[this.FigLastcolor] = codedcolor;
            this.FigFirstpart.append("0 ");
            this.FigFirstpart.append(this.FigLastcolor);
            this.FigFirstpart.append(" ");
            this.FigFirstpart.append(codedcolor);
            this.FigFirstpart.append("\n");
        }
    }

    public void setFillcolor(Color c2) {
        String codedcolor = this.ColorString(c2);
        boolean newcolor = true;
        for (int i = 32; i <= this.FigLastcolor; ++i) {
            if (!codedcolor.equals(this.FigColorsArray[i])) continue;
            this.FigFillcolor = i;
            newcolor = false;
            break;
        }
        if (newcolor) {
            ++this.FigLastcolor;
            this.FigFillcolor = this.FigLastcolor;
            this.FigColorsArray[this.FigLastcolor] = codedcolor;
            this.FigFirstpart.append("0 ");
            this.FigFirstpart.append(this.FigLastcolor);
            this.FigFirstpart.append(" ");
            this.FigFirstpart.append(codedcolor);
            this.FigFirstpart.append("\n");
        }
    }

    @Override
    public void setColor(ConstructionObject o) {
        if (o.isJobTarget()) {
            this.setColor(ZirkelFrame.TargetColor);
        } else if (o.selected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else {
            if (o.getColorType() == 2) {
                int i = o.getColorIndex();
                if (o.isHidden()) {
                    this.setColor(ZirkelFrame.BrighterLightColors[i]);
                } else {
                    this.setColor(ZirkelFrame.LightColors[i]);
                }
            } else {
                int i = o.getColorIndex();
                if (o.isHidden()) {
                    this.setColor(ZirkelFrame.BrighterColors[i]);
                } else {
                    this.setColor(ZirkelFrame.Colors[i]);
                }
            }
            if (o.getColorType() == 2) {
                this.Stroke = 1;
                this.FigLinestyle = 1;
            } else if (o.getColorType() == 1) {
                this.Stroke = 2;
                this.FigLinestyle = 0;
            } else {
                this.Stroke = 1;
                this.FigLinestyle = 0;
            }
        }
    }

    @Override
    public void setFillColor(ConstructionObject o) {
        if (o.isJobTarget()) {
            this.setFillcolor(ZirkelFrame.TargetColor);
        } else if (o.getColorType() != 1) {
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setFillcolor(ZirkelFrame.BrighterLightColors[i]);
            } else {
                this.setFillcolor(ZirkelFrame.LightColors[i]);
            }
        } else {
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setFillcolor(ZirkelFrame.BrighterColors[i]);
            } else {
                this.setFillcolor(ZirkelFrame.Colors[i]);
            }
        }
    }

    @Override
    public void setLabelColor(ConstructionObject o) {
        if (o.labelSelected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else if (o.isFilled()) {
            int type = o.getColorType();
            o.setColorType(0);
            this.setColor(o);
            o.setColorType(type);
        } else {
            this.setColor(o);
        }
    }

    @Override
    public void clearRect(int x, int y, int w, int h, Color c2) {
    }

    @Override
    public void drawRect(double x, double y, double w, double h) {
        this.append("# drawRect");
        this.append("\n");
        this.append("2 2 ");
        this.append(0);
        this.append(" ");
        this.append(this.Stroke);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigFillcolor);
        this.append(" ");
        this.append(this.pushLayer());
        this.append(" 0 -1 0.000 0 0 -1 0 0 5");
        this.append("\n");
        this.append((double)this.xfactor * x);
        this.append(" ");
        this.append((double)this.yfactor * y);
        this.append(" ");
        this.append((double)this.xfactor * (x + w) - 1.0);
        this.append(" ");
        this.append((double)this.yfactor * y);
        this.append(" ");
        this.append((double)this.xfactor * (x + w) - 1.0);
        this.append(" ");
        this.append((double)this.yfactor * (y + h) - 1.0);
        this.append(" ");
        this.append((double)this.xfactor * x);
        this.append(" ");
        this.append((double)this.yfactor * (y + h) - 1.0);
        this.append(" ");
        this.append((double)this.xfactor * x);
        this.append(" ");
        this.append((double)this.yfactor * y);
        this.append("\n");
    }

    @Override
    public void drawLine(double x, double y, double x1, double y1) {
        this.append("# drawLine");
        this.append("\n");
        this.append("2 1 ");
        this.append(0);
        this.append(" ");
        this.append(this.Stroke);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigFillcolor);
        this.append(" ");
        this.append(this.pushLayer());
        this.append(" 0 -1 0.000 0 0 -1 0 0 2");
        this.append("\n");
        this.append((double)this.xfactor * x);
        this.append(" ");
        this.append((double)this.yfactor * y);
        this.append(" ");
        this.append((double)this.xfactor * x1);
        this.append(" ");
        this.append((double)this.yfactor * y1);
        this.append("\n");
    }

    @Override
    public void drawThickLine(double x, double y, double x1, double y1) {
        this.append("# drawThickLine");
        this.append("\n");
        this.append("2 1 ");
        this.append(0);
        this.append(" ");
        this.append(2);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigFillcolor);
        this.append(" ");
        this.append(this.pushLayer());
        this.append(" 0 -1 0.000 0 0 -1 0 0 2");
        this.append("\n");
        this.append((double)this.xfactor * x);
        this.append(" ");
        this.append((double)this.yfactor * y);
        this.append(" ");
        this.append((double)this.xfactor * x1);
        this.append(" ");
        this.append((double)this.yfactor * y1);
        this.append("\n");
    }

    @Override
    public void drawLine(double x, double y, double x1, double y1, ConstructionObject o) {
        this.append("# drawLine ConstructionObject");
        this.append("\n");
        this.append("2 1 ");
        this.append(this.FigLinestyle);
        this.append(" ");
        this.append(this.Stroke);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigFillcolor);
        this.append(" ");
        this.append(this.pushLayer());
        this.append(" 0 -1 0.000 0 0 -1 0 0 2");
        this.append("\n");
        this.append((double)this.xfactor * x);
        this.append(" ");
        this.append((double)this.yfactor * y);
        this.append(" ");
        this.append((double)this.xfactor * x1);
        this.append(" ");
        this.append((double)this.yfactor * y1);
        this.append("\n");
    }

    @Override
    public void drawArc(double x, double y, double w, double h, double a2, double b2) {
        this.append("# drawArc");
        this.append("\n");
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + rx;
        double cy = y + ry;
        double arad = a2 * Math.PI / 180.0;
        double brad = b2 * Math.PI / 180.0;
        int x1 = (int)(cx + rx * Math.cos(arad));
        int y1 = (int)(cy + ry * Math.sin(arad));
        int x2 = (int)(cx + rx * Math.cos(arad + brad / 2.0));
        int y2 = (int)(cy + ry * Math.sin(arad + brad / 2.0));
        int x3 = (int)(cx + rx * Math.cos(arad + brad));
        int y3 = (int)(cy + ry * Math.sin(arad + brad));
        this.append("5 1 ");
        this.append(this.FigLinestyle);
        this.append(" ");
        this.append(this.Stroke);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigFillcolor);
        this.append(" ");
        this.append(this.pushLayer());
        this.append(" 0 -1 0.000 0 1 0 0 ");
        this.append((double)this.xfactor * cx);
        this.append(" ");
        this.append((double)this.yfactor * cy);
        this.append(" ");
        this.append(this.xfactor * x1);
        this.append(" ");
        this.append(this.yfactor * y1);
        this.append(" ");
        this.append(this.xfactor * x2);
        this.append(" ");
        this.append(this.yfactor * y2);
        this.append(" ");
        this.append(this.xfactor * x3);
        this.append(" ");
        this.append(this.yfactor * y3);
        this.append("\n");
    }

    @Override
    public void drawArc(double x, double y, double w, double h, double a2, double b2, ConstructionObject o) {
        this.append("# drawArc ConstructionObject");
        this.append("\n");
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + rx;
        double cy = y + ry;
        double arad = a2 * Math.PI / 180.0;
        double brad = b2 * Math.PI / 180.0;
        int x1 = (int)(cx + rx * Math.cos(arad));
        int y1 = (int)(cy - ry * Math.sin(arad));
        int x2 = (int)(cx + rx * Math.cos(arad + brad / 2.0));
        int y2 = (int)(cy - ry * Math.sin(arad + brad / 2.0));
        int x3 = (int)(cx + rx * Math.cos(arad + brad));
        int y3 = (int)(cy - ry * Math.sin(arad + brad));
        this.append("5 1 ");
        this.append(this.FigLinestyle);
        this.append(" ");
        this.append(this.Stroke);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.pushLayer());
        this.append(" 0 -1 0.000 0 1 0 0 ");
        this.append((double)this.xfactor * cx);
        this.append(" ");
        this.append((double)this.yfactor * cy);
        this.append(" ");
        this.append(this.xfactor * x1);
        this.append(" ");
        this.append(this.yfactor * y1);
        this.append(" ");
        this.append(this.xfactor * x2);
        this.append(" ");
        this.append(this.yfactor * y2);
        this.append(" ");
        this.append(this.xfactor * x3);
        this.append(" ");
        this.append(this.yfactor * y3);
        this.append("\n");
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.MFM;
    }

    @Override
    public void drawString(String s, double x, double y) {
        this.append("#drawString");
        this.append("\n");
        this.append("4 0 ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.pushLayer());
        this.append(" 0 4 12 0.000 2 0 0 ");
        this.append((double)this.xfactor * x);
        this.append(" ");
        this.append((double)this.yfactor * (y + 10.0));
        this.append(" ");
        this.append(s);
        this.append("\\001");
        this.append("\n");
    }

    @Override
    public void drawOval(double x, double y, double w, double h) {
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + rx;
        double cy = y + ry;
        this.append("#drawOval");
        this.append("\n");
        this.append("1 1 ");
        this.append(0);
        this.append(" ");
        this.append(this.Stroke);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigFillcolor);
        this.append(" ");
        this.append(this.pushLayer());
        this.append(" 0 -1 0.000 1 0.000 ");
        this.append((int)((double)this.xfactor * cx));
        this.append(" ");
        this.append((int)((double)this.yfactor * cy));
        this.append(" ");
        this.append((int)((double)this.xfactor * rx));
        this.append(" ");
        this.append((int)((double)this.yfactor * ry));
        this.append(" ");
        this.append("0 0 0 0");
        this.append("\n");
    }

    @Override
    public void drawOval(double x, double y, double w, double h, ConstructionObject o) {
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + rx;
        double cy = y + ry;
        this.append("#drawOval ConstructionObject");
        this.append("\n");
        this.append("1 1 ");
        this.append(this.FigLinestyle);
        this.append(" ");
        this.append(this.Stroke);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigFillcolor);
        this.append(" ");
        this.append(this.pushLayer());
        this.append(" 0 -1 0.000 1 0.000 ");
        this.append((int)((double)this.xfactor * cx));
        this.append(" ");
        this.append((int)((double)this.yfactor * cy));
        this.append(" ");
        this.append((int)((double)this.xfactor * rx));
        this.append(" ");
        this.append((int)((double)this.yfactor * ry));
        this.append(" ");
        this.append("0 0 0 0");
        this.append("\n");
    }

    @Override
    public void fillRect(double x, double y, double w, double h, boolean outline, boolean transparent, ConstructionObject o) {
        this.setColor(o);
        this.setFillColor(o);
        this.append("# fillRect");
        this.append("\n");
        this.append("2 2 ");
        this.append(outline ? this.FigLinestyle : 0);
        this.append(" ");
        this.append(this.Stroke);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigFillcolor);
        this.append(" ");
        this.append(this.pushLayer());
        if (transparent) {
            this.append(" 0 20 0.000 0 0 -1 0 0 5");
        } else {
            this.append(" 0 30 0.000 0 0 -1 0 0 5");
        }
        this.append("\n");
        this.append((double)this.xfactor * x);
        this.append(" ");
        this.append((double)this.yfactor * y);
        this.append(" ");
        this.append((double)this.xfactor * (x + w) - 1.0);
        this.append(" ");
        this.append((double)this.yfactor * y);
        this.append(" ");
        this.append((double)this.xfactor * (x + w) - 1.0);
        this.append(" ");
        this.append((double)this.yfactor * (y + h) - 1.0);
        this.append(" ");
        this.append((double)this.xfactor * x);
        this.append(" ");
        this.append((double)this.yfactor * (y + h) - 1.0);
        this.append(" ");
        this.append((double)this.xfactor * x);
        this.append(" ");
        this.append((double)this.yfactor * y);
        this.append("\n");
    }

    @Override
    public void fillArc(double x, double y, double w, double h, double a2, double b2, boolean outline, boolean transparent, boolean arc, ConstructionObject o) {
        this.setColor(o);
        this.setFillColor(o);
        this.append("#fillArc2");
        this.append("\n");
        double rx = (w - 1.0) / 2.0;
        double ry = (h - 1.0) / 2.0;
        double cx = x + rx;
        double cy = y + ry;
        double arad = a2 * Math.PI / 180.0;
        double brad = b2 * Math.PI / 180.0;
        int x1 = (int)(cx + rx * Math.cos(arad));
        int y1 = (int)(cy - ry * Math.sin(arad));
        int x2 = (int)(cx + rx * Math.cos(arad + brad / 2.0));
        int y2 = (int)(cy - ry * Math.sin(arad + brad / 2.0));
        int x3 = (int)(cx + rx * Math.cos(arad + brad));
        int y3 = (int)(cy - ry * Math.sin(arad + brad));
        this.append("5 2 ");
        this.append(outline ? this.FigLinestyle : 0);
        this.append(" ");
        this.append(this.Stroke);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigFillcolor);
        this.append(" ");
        this.append(this.pushLayer());
        if (transparent) {
            this.append(" 0 20 0.000 0 1 0 0 ");
        } else {
            this.append(" 0 30 0.000 0 1 0 0 ");
        }
        this.append((double)this.xfactor * cx);
        this.append(" ");
        this.append((double)this.yfactor * cy);
        this.append(" ");
        this.append(this.xfactor * x1);
        this.append(" ");
        this.append(this.yfactor * y1);
        this.append(" ");
        this.append(this.xfactor * x2);
        this.append(" ");
        this.append(this.yfactor * y2);
        this.append(" ");
        this.append(this.xfactor * x3);
        this.append(" ");
        this.append(this.yfactor * y3);
        this.append("\n");
    }

    @Override
    public void fillOval(double x, double y, double w, double h, boolean outline, boolean transparent, ConstructionObject o) {
        this.setColor(o);
        this.setFillColor(o);
        this.append("#fillOval");
        this.append("\n");
        double rx = (w - 1.0) / 2.0;
        double ry = (h - 1.0) / 2.0;
        double cx = x + rx;
        double cy = y + ry;
        this.append("1 1 ");
        this.append(outline ? this.FigLinestyle : 0);
        this.append(" ");
        this.append(this.Stroke);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigFillcolor);
        this.append(" ");
        this.append(this.pushLayer());
        if (transparent) {
            this.append(" 0 20 0.000 1 0.000 ");
        } else {
            this.append(" 0 30 0.000 1 0.000 ");
        }
        this.append((int)((double)this.xfactor * cx));
        this.append(" ");
        this.append((int)((double)this.yfactor * cy));
        this.append(" ");
        this.append((int)((double)this.xfactor * rx));
        this.append(" ");
        this.append((int)((double)this.yfactor * ry));
        this.append(" ");
        this.append("0 0 0 0");
        this.append("\n");
    }

    @Override
    public void fillPolygon(double[] x, double[] y, int n, boolean outline, boolean transparent, ConstructionObject o) {
        this.setColor(o);
        this.setFillColor(o);
        this.append("#fillPolygon");
        this.append("\n");
        this.append("2 1 ");
        this.append(outline ? this.FigLinestyle : 0);
        this.append(" ");
        this.append(this.Stroke);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigFillcolor);
        this.append(" ");
        this.append(this.pushLayer());
        if (transparent) {
            this.append(" 0 20 0.000 0 0 -1 0 0 ");
        } else {
            this.append(" 0 30 0.000 0 0 -1 0 0 ");
        }
        this.append(n + 1);
        this.append("\n");
        for (int i = 0; i < n; ++i) {
            this.append((double)this.xfactor * x[i]);
            this.append(" ");
            this.append((double)this.yfactor * y[i]);
            this.append(" ");
        }
        this.append((double)this.xfactor * x[0]);
        this.append(" ");
        this.append((double)this.yfactor * y[0]);
        this.append(" ");
        this.append("\n");
    }

    public void setLayer(int n) {
        this.FigLayer = n;
    }

    void append(String s) {
        this.FigLastpart.append(s);
    }

    void append(int n) {
        this.FigLastpart.append("" + n);
    }

    void append(double x) {
        this.FigLastpart.append("" + (int)x);
    }

    public int pushLayer() {
        if (this.PushLayer) {
            --this.FigLayer;
        }
        return this.FigLayer;
    }

    public void pushLayer(boolean flag) {
        this.PushLayer = flag;
    }

    @Override
    public void drawImage(Image i, int x, int y, ImageObserver o) {
    }

    @Override
    public void drawImage(Image i, int x, int y, int w, int h, ImageObserver o) {
    }

    @Override
    public void setFont(int h, boolean bold) {
    }

    @Override
    public void setDefaultFont(int h, boolean large, boolean bold) {
        this.fsize = h;
        this.flarge = large;
        this.fbold = bold;
        this.setFont(large, bold);
    }

    @Override
    public void setFont(boolean large, boolean bold) {
        int size = this.fsize;
        if (large) {
            size = size * this.ffactor / 100;
        }
        if (this.flarge) {
            size = size * this.ffactor / 100;
        }
        this.setFont(size, bold || this.fbold);
    }

    @Override
    public void drawImage(Image i, double x, double y, double x1, double y1, double x2, double y2, ImageObserver o) {
    }

    @Override
    public Graphics getGraphics() {
        return null;
    }

    @Override
    public int stringWidth(String s) {
        return this.getFontMetrics().stringWidth(s);
    }

    @Override
    public int stringHeight(String s) {
        return this.getFontMetrics().getHeight();
    }

    @Override
    public int drawStringExtended(String s, double x, double y) {
        this.drawString(s, x, y + (double)this.getFontMetrics().getAscent());
        return this.getFontMetrics().getHeight();
    }

    @Override
    public int stringAscent(String s) {
        return this.getFontMetrics().getAscent();
    }

    @Override
    public void fillOval(double x, double y, double w, double h, Color WithColor) {
    }

    @Override
    public void fillRect(double x, double y, double w, double h, Color WithColor) {
    }

    @Override
    public void drawDiamond(double x, double y, double w, boolean isThick, ConstructionObject o) {
    }

    @Override
    public void drawDcross(double x, double y, double w, boolean isThick, ConstructionObject o) {
    }

    @Override
    public void setAntialiasing(boolean bool) {
    }

    @Override
    public void drawAxisLine(double x, double y, double x1, double y1) {
    }

    @Override
    public void fillPolygon(double[] x, double[] y, int n, ConstructionObject o) {
    }
}

