/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.graphics;

import carmetal.objects.ConstructionObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelFrame;
import carmetal.rene.zirkel.graphics.EPSGraphics;
import carmetal.rene.zirkel.graphics.MyGraphics;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.OutputStream;

public class MyGraphicsEPS
extends MyGraphics {
    EPSGraphics G;
    public static int MaxR = 1000000;
    double LineWidth = 1.0;
    int fsize;
    boolean flarge;
    boolean fbold;
    int ffactor = Global.getParameter("ffactor", 130);

    public MyGraphicsEPS(OutputStream out, int w, int h) {
        this.G = new EPSGraphics(out, w, h, 0, true);
    }

    public void setLineWidth(double w) {
        this.LineWidth = w;
        this.G.setLineWidth(w);
    }

    @Override
    public void clearRect(int x, int y, int w, int h, Color c2) {
        this.G.setColor(c2);
        this.G.fillRect(x, y, w, h);
    }

    @Override
    public void setColor(Color c2) {
        this.G.setColor(c2);
    }

    @Override
    public void setColor(ConstructionObject o) {
        if (o.isJobTarget()) {
            this.setColor(ZirkelFrame.TargetColor);
        } else if (o.selected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else if (o.getColorType() == 2) {
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setColor(ZirkelFrame.BrighterLightColors[i]);
            } else {
                this.setColor(ZirkelFrame.LightColors[i]);
            }
        } else {
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setColor(ZirkelFrame.BrighterColors[i]);
            } else {
                this.setColor(ZirkelFrame.Colors[i]);
            }
        }
    }

    @Override
    public void setFillColor(ConstructionObject o) {
        if (o.isJobTarget()) {
            this.setColor(ZirkelFrame.TargetColor);
        } else if (o.getColorType() != 1) {
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setColor(ZirkelFrame.BrighterLightColors[i]);
            } else {
                this.setColor(ZirkelFrame.LightColors[i]);
            }
        } else {
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setColor(ZirkelFrame.BrighterColors[i]);
            } else {
                this.setColor(ZirkelFrame.Colors[i]);
            }
        }
    }

    @Override
    public void setLabelColor(ConstructionObject o) {
        if (o.labelSelected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else if (o.isFilled()) {
            int type = o.getColorType();
            o.setColorType(0);
            this.setColor(o);
            o.setColorType(type);
        } else {
            this.setColor(o);
        }
    }

    @Override
    public void drawRect(double x, double y, double w, double h) {
        this.G.drawRect(x, y, w, h);
    }

    @Override
    public void drawLine(double x, double y, double x1, double y1, ConstructionObject o) {
        if (o.getColorType() == 1) {
            this.drawThickLine(x, y, x1, y1);
        } else if (o.getColorType() == 2) {
            this.drawThinLine(x, y, x1, y1);
        } else {
            this.drawLine(x, y, x1, y1);
        }
    }

    @Override
    public void drawLine(double x, double y, double x1, double y1) {
        this.G.drawLine(x, y, x1, y1);
    }

    @Override
    public void drawThickLine(double c1, double r1, double c2, double r2) {
        this.G.setLineWidth(3.0 * this.LineWidth);
        this.G.drawLine(c1, r1, c2, r2);
        this.G.setLineWidth(this.LineWidth);
    }

    public void drawThinLine(double c1, double r1, double c2, double r2) {
        this.G.setDash(4.0, 4.0);
        this.G.drawLine(c1, r1, c2, r2);
        this.G.clearDash();
    }

    @Override
    public void drawArc(double x, double y, double w, double h, double a2, double b2) {
        this.G.drawArc(x, y, w, h, a2, b2);
    }

    public void drawThickArc(double x, double y, double w, double h, double a2, double b2) {
        this.G.setLineWidth(3.0 * this.LineWidth);
        this.drawArc(x + 1.0, y + 1.0, w - 2.0, w - 2.0, a2, b2);
        this.G.setLineWidth(this.LineWidth);
    }

    public void drawThinArc(double x, double y, double w, double h, double a2, double b2) {
        this.G.setDash(4.0, 4.0);
        this.drawArc(x + 1.0, y + 1.0, w - 2.0, w - 2.0, a2, b2);
        this.G.clearDash();
    }

    @Override
    public void drawArc(double x, double y, double w, double h, double a2, double b2, ConstructionObject o) {
        if (o.getColorType() == 1) {
            this.drawThickArc(x, y, w, h, a2, b2);
        } else if (o.getColorType() == 2) {
            this.drawThinArc(x, y, w, h, a2, b2);
        } else {
            this.drawArc(x, y, w, h, a2, b2);
        }
    }

    @Override
    public void drawString(String s, double x, double y) {
        this.G.drawString(s, x, y);
    }

    @Override
    public void drawOval(double x, double y, double w, double h) {
        if (w < (double)MaxR) {
            this.G.drawOval(x, y, w, h);
        }
    }

    public void drawThickOval(double x, double y, double w, double h) {
        this.drawOval(x, y, w, h);
        this.drawOval(x - 1.0, y - 1.0, w + 2.0, h + 2.0);
        this.drawOval(x + 1.0, y + 1.0, w - 2.0, h - 2.0);
    }

    @Override
    public void drawOval(double x, double y, double w, double h, ConstructionObject o) {
        this.setColor(o);
        if (o.getColorType() == 1) {
            this.drawThickOval(x, y, w, h);
        } else {
            this.drawOval(x, y, w, h);
        }
    }

    @Override
    public void fillRect(double x, double y, double w, double h, boolean outline, boolean transparent, ConstructionObject o) {
        this.setFillColor(o);
        this.G.fillRect(x, y, w, h);
        if (outline) {
            this.setColor(o);
            this.G.drawRect(x, y, w, h);
        }
    }

    @Override
    public void fillArc(double x, double y, double w, double h, double a2, double b2, boolean outline, boolean transparent, boolean arc, ConstructionObject o) {
        this.setFillColor(o);
        if (arc) {
            this.G.fillArc(x, y, w, h, a2, b2);
        } else {
            this.G.fillChord(x, y, w, h, a2, b2);
        }
        if (outline) {
            this.setColor(o);
            this.G.drawArc(x, y, w, h, a2, b2);
        }
    }

    @Override
    public void fillOval(double x, double y, double w, double h, boolean outline, boolean transparent, ConstructionObject o) {
        if (w >= (double)MaxR) {
            return;
        }
        this.setFillColor(o);
        this.G.fillOval(x, y, w, h);
        if (outline) {
            this.setColor(o);
            this.G.drawOval(x, y, w, h);
        }
    }

    @Override
    public void fillPolygon(double[] x, double[] y, int n, boolean outline, boolean transparent, ConstructionObject o) {
        if (o.getColorType() != 3) {
            this.setFillColor(o);
            this.G.fillPolygon(x, y, n);
        }
        if (outline) {
            this.setColor(o);
            this.G.drawPolygon(x, y, n);
        }
    }

    @Override
    public void drawImage(Image i, int x, int y, ImageObserver o) {
    }

    @Override
    public void drawImage(Image i, int x, int y, int w, int h, ImageObserver o) {
    }

    public void close() throws IOException {
        this.G.close();
    }

    @Override
    public void setDefaultFont(int h, boolean large, boolean bold) {
        this.fsize = h;
        this.flarge = large;
        this.fbold = bold;
        this.setFont(large, bold);
    }

    @Override
    public void setFont(boolean large, boolean bold) {
        int size = this.fsize;
        if (large) {
            size = size * this.ffactor / 100;
        }
        if (this.flarge) {
            size = size * this.ffactor / 100;
        }
        this.setFont(size, bold || this.fbold);
    }

    @Override
    public void setFont(int h, boolean bold) {
        this.G.setFont(new Font(Global.getParameter("font.name", "dialog"), bold ? 1 : 0, h));
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.G.getFontMetrics();
    }

    @Override
    public void drawImage(Image i, double x, double y, double x1, double y1, double x2, double y2, ImageObserver o) {
    }

    @Override
    public Graphics getGraphics() {
        return null;
    }

    @Override
    public int stringWidth(String s) {
        return this.getFontMetrics().stringWidth(s);
    }

    @Override
    public int stringHeight(String s) {
        return this.getFontMetrics().getHeight();
    }

    @Override
    public int drawStringExtended(String s, double x, double y) {
        this.drawString(s, x, y + (double)this.getFontMetrics().getAscent());
        return this.getFontMetrics().getHeight();
    }

    @Override
    public int stringAscent(String s) {
        return this.getFontMetrics().getAscent();
    }

    @Override
    public void fillOval(double x, double y, double w, double h, Color WithColor) {
        try {
            this.G.setColor(WithColor);
            this.G.fillOval(x, y, w, h);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void fillRect(double x, double y, double w, double h, Color WithColor) {
        try {
            this.G.setColor(WithColor);
            this.G.fillRect(x, y, w, h);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void drawDiamond(double x, double y, double w, boolean isThick, ConstructionObject o) {
        double dw = w / 2.0;
        double[] dx = new double[4];
        double[] dy = new double[4];
        dx[0] = x + dw;
        dy[0] = y;
        dx[1] = x + w;
        dy[1] = y + dw;
        dx[2] = x + dw;
        dy[2] = y + w;
        dx[3] = x;
        dy[3] = y + dw;
        if (isThick) {
            this.G.setColor(o.getColor());
        } else {
            this.G.setColor(new Color(250, 250, 250));
        }
        this.G.fillPolygon(dx, dy, 4);
        if (!isThick) {
            this.G.setColor(o.getColor());
            this.G.drawPolygon(dx, dy, 4);
        }
    }

    @Override
    public void drawDcross(double x, double y, double w, boolean isThick, ConstructionObject o) {
        double x1 = x + w;
        double y1 = y + w;
        this.setColor(o);
        if (isThick) {
            this.G.setLineWidth(2.0 * this.LineWidth);
        } else {
            this.G.setLineWidth(this.LineWidth);
        }
        this.drawLine(x, y, x1, y1);
        this.drawLine(x, y1, x1, y);
        this.G.setLineWidth(this.LineWidth);
    }

    @Override
    public void setAntialiasing(boolean bool) {
    }

    @Override
    public void drawAxisLine(double x, double y, double x1, double y1) {
        this.G.setLineWidth(this.LineWidth / 2.0);
        this.drawLine(x, y, x1, y1);
        this.G.setLineWidth(this.LineWidth);
    }

    @Override
    public void fillPolygon(double[] x, double[] y, int n, ConstructionObject o) {
        if (o.isFilled()) {
            this.setFillColor(o);
            this.G.fillPolygon(x, y, n);
        }
        if (!o.isFilled() || o.indicated() || o.selected() || o.getColorType() == 0) {
            this.setColor(o);
            this.G.drawPolygon(x, y, n);
        }
    }
}

