/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionException;
import carmetal.construction.Count;
import carmetal.constructors.AngleConstructor;
import carmetal.constructors.AreaConstructor;
import carmetal.constructors.BoundedPointConstructor;
import carmetal.constructors.Circle3Constructor;
import carmetal.constructors.CircleConstructor;
import carmetal.constructors.ExpressionConstructor;
import carmetal.constructors.ImageConstructor;
import carmetal.constructors.IntersectionConstructor;
import carmetal.constructors.LineConstructor;
import carmetal.constructors.MidpointConstructor;
import carmetal.constructors.ObjectConstructor;
import carmetal.constructors.ParallelConstructor;
import carmetal.constructors.PlumbConstructor;
import carmetal.constructors.PointConstructor;
import carmetal.constructors.QuadricConstructor;
import carmetal.constructors.RayConstructor;
import carmetal.constructors.SegmentConstructor;
import carmetal.constructors.TextConstructor;
import carmetal.eric.GUI.palette.PaletteManager;
import carmetal.eric.GUI.pipe_tools;
import carmetal.eric.GUI.window.tab_bottom;
import carmetal.eric.JZirkelCanvas;
import carmetal.eric.Media;
import carmetal.objects.ConstructionObject;
import carmetal.objects.ExpressionObject;
import carmetal.objects.PointObject;
import carmetal.objects.PrimitiveCircleObject;
import carmetal.objects.PrimitiveLineObject;
import carmetal.objects.SegmentObject;
import carmetal.rene.dialogs.MyFileDialog;
import carmetal.rene.dialogs.Question;
import carmetal.rene.dialogs.Warning;
import carmetal.rene.gui.Global;
import carmetal.rene.util.FileName;
import carmetal.rene.util.MyVector;
import carmetal.rene.util.parser.StringParser;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.ZirkelCanvasInterface;
import carmetal.rene.zirkel.listener.DoneListener;
import carmetal.rene.zirkel.listener.StatusListener;
import carmetal.rene.zirkel.macro.Macro;
import carmetal.rene.zirkel.macro.MacroRunner;
import carmetal.rene.zirkel.tools.AnimatorTool;
import carmetal.rene.zirkel.tools.BreakpointAnimator;
import carmetal.rene.zirkel.tools.DeleteTool;
import carmetal.rene.zirkel.tools.DrawerTool;
import carmetal.rene.zirkel.tools.EditTool;
import carmetal.rene.zirkel.tools.HiderTool;
import carmetal.rene.zirkel.tools.JLocusObjectTracker;
import carmetal.rene.zirkel.tools.MoverTool;
import carmetal.rene.zirkel.tools.ObjectTracker;
import carmetal.rene.zirkel.tools.RenamerTool;
import carmetal.rene.zirkel.tools.ReorderTool;
import carmetal.rene.zirkel.tools.SaveJob;
import carmetal.rene.zirkel.tools.SetParameterTool;
import carmetal.rene.zirkel.tools.SetTargetsTool;
import carmetal.rene.zirkel.tools.Tracker;
import carmetal.rene.zirkel.tools.ZoomerTool;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JPanel;

public class ZirkelFrame
implements StatusListener,
DoneListener,
ZirkelCanvasInterface {
    public ZirkelCanvas ZC;
    public static Frame FRM;
    public String Filename = "";
    public String Background = "";
    static Color[] DefaultColors;
    public static Color[] Colors;
    public static Color[] LightColors;
    public static Color[] BrighterLightColors;
    public static Color[] BrighterColors;
    public static Color SelectColor;
    public static Color IndicateColor;
    public static Color TargetColor;
    public static String[] ColorStrings;
    public static String[] PointTypes;
    public static String[] ColorTypes;
    public static int[] ColorTypeKeys;
    CheckboxMenuItem[] ColorTypeMenuItems = new CheckboxMenuItem[ColorTypes.length];
    public static int[] ColorKeys;
    CheckboxMenuItem[] ColorMenuItems = new CheckboxMenuItem[ColorStrings.length];
    CheckboxMenuItem[] ShowColorMenuItems = new CheckboxMenuItem[ColorStrings.length];
    static int[] PointKeys;
    CheckboxMenuItem[] PointMenuItems = new CheckboxMenuItem[PointTypes.length];
    public static final String[] Separators;
    public static final String[] MenuTitles;
    public static final int IconNumber = 27;
    public static final int NEdit = 27;
    public static final int NParameters = 28;
    public static final int NTargets = 29;
    public static final int NDefineJob = 30;
    public static final int NDelete = 31;
    public static final int NReorder = 32;
    public static final int NDraw = 33;
    public static final int NRename = 34;
    public static final int NZoom = 35;
    public static final int NAnimateBreak = 36;
    public static final int NLocus = 37;
    public static final int NAnimator = 18;
    public static final int NObjectTracker = 17;
    public static final int NTracker = 16;
    public static final int NMover = 15;
    public static final int NMacro = 26;
    public static final String[] ObjectStrings;
    public static ObjectConstructor[] ObjectConstructors;
    CheckboxMenuItem[] ObjectMenuItems = new CheckboxMenuItem[ObjectConstructors.length];
    static char[] ObjectKeys;
    public int CurrentTool = 0;
    public boolean IsApplet;
    JPanel North;
    JPanel Center;
    JPanel MainPanel;
    JPanel StatusPanel;
    JPanel InputPanel;
    JPanel CenterPanel;
    boolean Init = false;
    boolean SawPreviewWarning = false;
    MyFileDialog FileLoad;
    MyFileDialog FileSave;
    MyFileDialog PicSave;
    MyFileDialog HTMLSave;
    MyFileDialog BackgroundLoad;
    MyFileDialog ImageLoad;
    MyFileDialog TemplateLoad;
    public static final String DefaultIcons = " new load save back undo delete color type thickness hidden showcolor macro grid comment replay point line segment ray circle fixedcircle parallel plumb circle3 midpoint angle fixedangle move tracker objecttracker hide expression area text quadric runmacro edit animate  info zoom draw function rename ";
    public static final String DefaultRestrictedIcons = " back undo color hidden showcolor macro grid comment point line segment ray circle parallel plumb circle3 midpoint angle fixedangle move tracker objecttracker hide area text quadric runmacro zoom info  ";
    MyVector TB = new MyVector();
    int TBN = 0;
    String OldMacro = null;
    public int resizeCol;
    boolean resizeFlag = false;

    public ZirkelFrame(boolean applet) {
        this.IsApplet = applet;
        FRM = pipe_tools.getFrame();
        this.ZC = new ZirkelCanvas();
        this.ZC.setBackground(Global.getParameter("colorbackground", new Color(245, 245, 245)));
        this.ZC.addMouseListener(this.ZC);
        this.ZC.addMouseMotionListener(this.ZC);
        this.ZC.setZirkelCanvasListener(this);
        this.ZC.setTool(ObjectConstructors[this.CurrentTool]);
        this.ZC.addStatusListener(this);
        this.ZC.showStatus();
        this.initLightColors();
        this.settool(0);
        this.setcolor(Global.getParameter("options.color", 0));
        this.settype(Global.getParameter("options.type", 2));
        this.setcolortype(Global.getParameter("options.colortype", 0));
        this.showcolor(0);
        this.setRestricted(Global.getParameter("options.restricted", true));
        this.setPartial(Global.getParameter("options.partial", false));
        this.setPartialLines(Global.getParameter("options.plines", false));
        this.setVectors(Global.getParameter("options.arrow", false));
        this.setShowNames(Global.getParameter("options.shownames", false));
        this.setShowValues(Global.getParameter("options.showvalues", false));
        this.setLongNames(Global.getParameter("options.longnames", false));
        this.setLargeFont(Global.getParameter("options.largefont", false));
        this.setBoldFont(Global.getParameter("options.boldfont", false));
        this.setObtuse(Global.getParameter("options.obtuse", false));
        this.setSolid(Global.getParameter("options.solid", false));
        this.initFileDialogs();
    }

    public boolean icon(String s) {
        return Global.getParameter("icons", "none").indexOf(" " + s + " ") >= 0;
    }

    @Override
    public boolean enabled(String s) {
        return !Global.getParameter("restricted", false) || this.icon(s);
    }

    public void initFileDialogs() {
        this.FileLoad = new MyFileDialog(FRM, Global.name("filedialog.open"), false);
        this.FileLoad.setPattern("*.zir *.job *.zirz *.jobz");
        this.FileSave = new MyFileDialog(FRM, Global.name("filedialog.saveas"), true);
        this.FileSave.setPattern("*.zir *.job *.zirz *.jobz");
        this.PicSave = new MyFileDialog(FRM, Global.name("filedialog.saveas"), true);
        this.PicSave.setPattern("*");
        this.HTMLSave = new MyFileDialog(FRM, Global.name("filedialog.htmlsave"), true);
        this.HTMLSave.setPattern("*.html *.htm");
        this.BackgroundLoad = new MyFileDialog(FRM, Global.name("filedialog.backgroundload"), false);
        this.BackgroundLoad.setPattern("*.gif *.jpg");
        this.ImageLoad = new MyFileDialog(FRM, Global.name("filedialog.imageload"), false);
        this.ImageLoad.setPattern("*.gif *.jpg");
        this.TemplateLoad = new MyFileDialog(FRM, Global.name("templateload.open"), false);
        this.TemplateLoad.setPattern("*.template");
    }

    public static void initLightColors(Color back) {
        int n = DefaultColors.length;
        Colors = new Color[DefaultColors.length];
        for (int i = 0; i < n; ++i) {
            ZirkelFrame.Colors[i] = Global.haveParameter("color" + i) ? Global.getParameter("color" + i, Color.black) : DefaultColors[i];
        }
        LightColors = new Color[n];
        BrighterLightColors = new Color[n];
        BrighterColors = new Color[n];
        if (back == null) {
            back = Color.gray.brighter();
        }
        int red = back.getRed();
        int green = back.getGreen();
        int blue = back.getBlue();
        double lambda = 0.4;
        for (int i = 0; i < n; ++i) {
            int r = (int)((double)red * 0.6 + (double)Colors[i].getRed() * 0.4);
            int g = (int)((double)green * 0.6 + (double)Colors[i].getGreen() * 0.4);
            int b2 = (int)((double)blue * 0.6 + (double)Colors[i].getBlue() * 0.4);
            ZirkelFrame.LightColors[i] = new Color(r, g, b2);
            ZirkelFrame.BrighterColors[i] = i == 0 ? Color.gray : Colors[i].brighter();
            ZirkelFrame.BrighterLightColors[i] = LightColors[i].brighter();
        }
    }

    public void initLightColors() {
        ZirkelFrame.initLightColors(Color.white);
    }

    public void clear(boolean defaults) {
        this.ZC.clear();
        Count.resetAll();
        this.clearsettings(defaults);
        this.ZC.clearDrawings();
        this.ZC.repaint();
    }

    public void clearsettings(boolean defaults) {
        if (defaults) {
            this.settool(0);
            this.setcolor(0);
            this.setcolortype(0);
            this.settype(2);
            this.showcolor(0);
            this.setRestricted(true);
            this.setPartial(false);
            this.setPartialLines(false);
            this.setVectors(false);
            this.setShowNames(false);
            this.setShowValues(false);
            this.setLongNames(false);
            this.setLargeFont(false);
            this.setBoldFont(false);
            this.setObtuse(false);
            this.setSolid(false);
            this.setVisual(true);
        } else {
            this.settool(0);
            this.setcolor(Global.getParameter("options.color", 0));
            this.setcolortype(Global.getParameter("options.colortype", 0));
            this.settype(Global.getParameter("options.type", 2));
            this.showcolor(0);
            this.setRestricted(Global.getParameter("options.restricted", true));
            this.setPartial(Global.getParameter("options.partial", false));
            this.setPartialLines(Global.getParameter("options.plines", false));
            this.setVectors(Global.getParameter("options.arrow", false));
            this.setShowNames(Global.getParameter("options.shownames", false));
            this.setShowValues(Global.getParameter("options.showvalues", false));
            this.setLongNames(Global.getParameter("options.longnames", false));
            this.setLargeFont(Global.getParameter("options.largefont", false));
            this.setBoldFont(Global.getParameter("options.boldfont", false));
            this.setObtuse(Global.getParameter("options.obtuse", false));
            this.setSolid(Global.getParameter("options.solid", false));
            this.setVisual(Global.getParameter("options.visual", true));
        }
    }

    public void clearsettings() {
        this.clearsettings(false);
    }

    public void loadsettings() {
        this.setcolor(this.ZC.getDefaultColor());
        this.settype(this.ZC.getDefaultType());
        this.setcolortype(this.ZC.getDefaultColorType());
        this.setPartial(this.ZC.getPartial());
        this.setPartialLines(this.ZC.getPartialLines());
        this.setVectors(this.ZC.getVectors());
        this.setShowNames(this.ZC.getConstruction().ShowNames);
        this.setShowValues(this.ZC.getConstruction().ShowValues);
    }

    public void itemAction(String o, boolean flag) {
    }

    public void settool(String o) {
        this.ZC.pause(true);
        this.ZC.requestFocus();
        for (int i = 0; i < ObjectStrings.length; ++i) {
            if (!o.equals(ObjectStrings[i])) continue;
            this.settool(i);
        }
        this.ZC.pause(false);
        this.ZC.requestFocus();
    }

    public void settool(int i) {
        this.CurrentTool = i;
        this.ZC.setTool(ObjectConstructors[i]);
        ObjectConstructors[i].resetFirstTime(this.ZC);
        if (i == 30) {
            this.testjob(false);
        }
    }

    public int getCurrentTool() {
        return this.CurrentTool;
    }

    public void sethidden(boolean flag) {
        this.ZC.setShowHidden(flag);
    }

    public void setcolor(int c2) {
        this.ZC.setDefaultColor(c2);
        Global.setParameter("options.color", c2);
    }

    public void settype(int c2) {
        this.ZC.setDefaultType(c2);
        Global.setParameter("options.type", c2);
    }

    public void setcolortype(int c2) {
        this.ZC.setDefaultColorType(c2);
        Global.setParameter("options.colortype", c2);
    }

    public void showcolor(int c2) {
        this.ZC.setShowColor(c2);
    }

    @Override
    public void showStatus(String s) {
        if (tab_bottom.getStatus().equals(s)) {
            return;
        }
        try {
            tab_bottom.showStatus(JZirkelCanvas.FilteredStatus(s));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save() {
        this.testjob(false);
        if (!this.haveFile()) {
            this.saveas();
        } else {
            this.dosave(this.Filename, true, Global.getParameter("save.includemacros", false), false, true, this.ZC.getMacros());
        }
    }

    public static boolean isCompressed(String filename) {
        return FileName.extension(filename).endsWith("z");
    }

    public boolean dosave(String Filename, boolean construction, boolean macros, boolean protectedmacros, boolean scripts, Vector v) {
        if (Global.getParameter("options.backups", true) && this.exists(Filename)) {
            File F = new File(Filename);
            File Back = new File(Filename + ".bak");
            try {
                if (Back.exists()) {
                    Back.delete();
                }
                F.renameTo(Back);
            }
            catch (Exception e2) {
                Warning w = new Warning(FRM, Global.name("warning.save.backup"), FileName.chop(32, e2.toString(), 64), Global.name("warning"), true);
                w.center(FRM);
                w.setVisible(true);
                return false;
            }
        }
        try {
            OutputStream o = new FileOutputStream(Filename);
            if (ZirkelFrame.isCompressed(Filename)) {
                o = new GZIPOutputStream(o, 10000);
            }
            this.ZC.getConstruction().BackgroundFile = this.Background;
            this.ZC.getConstruction().ResizeBackground = Global.getParameter("background.usesize", false);
            this.ZC.save(o, construction, macros, protectedmacros, scripts, v, "");
            o.close();
            if (construction) {
                FRM.setTitle(Global.name("program.name") + " : " + FileName.chop(Filename));
            }
        }
        catch (FileNotFoundException ef) {
            return false;
        }
        catch (Exception e3) {
            Warning w = new Warning(FRM, Global.name("warning.save"), FileName.chop(32, e3.toString(), 64), Global.name("warning"), true);
            w.center(FRM);
            w.setVisible(true);
            return false;
        }
        return true;
    }

    public boolean saveas(String pattern, String ext) {
        this.testjob(false);
        this.FileSave.center(FRM);
        if (this.haveFile()) {
            this.FileSave.setDirectory(FileName.path(this.Filename));
            this.FileSave.setFilePath(FileName.filename(this.Filename));
        }
        this.FileSave.setPattern(Global.getParameter("pattern", pattern));
        this.FileSave.update(!this.haveFile());
        this.FileSave.setVisible(true);
        if (this.FileSave.isAborted()) {
            return false;
        }
        String filename = this.FileSave.getFilePath();
        if (FileName.extension(filename).equals("")) {
            filename = filename + ext;
        }
        if (Global.getParameter("options.filedialog", true) && this.exists(filename)) {
            Question d2 = new Question(FRM, FileName.filename(filename) + " : " + Global.name("file.exists.overwrite"), Global.name("file.exists.title"), this, false, true);
            d2.center(FRM);
            d2.setVisible(true);
            if (!d2.yes()) {
                return false;
            }
        }
        this.Filename = filename;
        return this.dosave(this.Filename, true, Global.getParameter("save.includemacros", false), false, true, this.ZC.getMacros());
    }

    public boolean saveas() {
        return this.saveas("*.zir *.zirz *.job *.jobz", Global.getParameter("save.compress", false) ? ".zirz" : ".zir");
    }

    public boolean exists(String filename) {
        File f2 = new File(filename);
        return f2.exists();
    }

    public boolean savefile() {
        this.testjob(false);
        if (!this.haveFile()) {
            return this.saveas();
        }
        return this.dosave(this.Filename, true, Global.getParameter("save.includemacros", false), false, true, this.ZC.getMacros());
    }

    public void saveMacros() {
        this.testjob(false);
        Vector v = this.ZC.chooseMacros();
        if (v == null || v.size() == 0) {
            return;
        }
        this.FileSave.center(FRM);
        this.FileSave.setPattern(Global.getParameter("pattern.macro", "*.mcr *mcrz"));
        this.FileSave.update();
        this.FileSave.setVisible(true);
        if (this.FileSave.isAborted()) {
            return;
        }
        String Filename = this.FileSave.getFilePath();
        if (FileName.extension(Filename).equals("")) {
            Filename = Filename + (Global.getParameter("save.compress", false) ? ".mcrz" : ".mcr");
        }
        if (Global.getParameter("options.filedialog", true) && this.exists(Filename)) {
            Question d2 = new Question(FRM, FileName.filename(Filename) + " : " + Global.name("file.exists.overwrite"), Global.name("file.exists.title"), this, false, true);
            d2.center(FRM);
            d2.setVisible(true);
            if (!d2.yes()) {
                return;
            }
        }
        this.dosave(Filename, false, true, true, false, v);
    }

    public void deleteMacros() {
        Vector v = this.ZC.chooseMacros();
        if (v == null || v.size() == 0) {
            return;
        }
        this.ZC.deleteMacros(v);
    }

    public void renameMacro() {
    }

    public void clearMacros() {
    }

    public void clearNonprotectedMacros() {
    }

    public void doload(String name, InputStream in) {
        block28: {
            try {
                this.Filename = name;
                InputStream o = null;
                if (in == null) {
                    o = new FileInputStream(name);
                    if (ZirkelFrame.isCompressed(name)) {
                        o = new GZIPInputStream(o);
                    }
                } else {
                    o = in;
                }
                this.clear(false);
                this.ZC.startWaiting();
                this.ZC.load(o);
                this.ZC.endWaiting();
                o.close();
                FRM.setTitle(Global.name("program.name") + " : " + FileName.chop(name));
                FRM.setEnabled(true);
                if (!this.ZC.getConstruction().getComment().equals("") && !this.ZC.isJob()) {
                    this.showcomment();
                }
            }
            catch (Exception e2) {
                Warning w = new Warning(FRM, Global.name("warning.load"), FileName.chop(32, e2.toString(), 64), Global.name("warning"), true);
                w.center(FRM);
                w.setVisible(true);
                this.ZC.endWaiting();
                return;
            }
            PaletteManager.CheckRestrictedIcons(this.ZC.getConstruction().Icons);
            if (this.ZC.getConstruction().BackgroundFile != null) {
                this.doloadBackground(JZirkelCanvas.getFilePath(this.ZC.getConstruction()) + this.ZC.getConstruction().BackgroundFile);
            }
            Construction C = this.ZC.getConstruction();
            if (C.TrackP != null) {
                try {
                    ConstructionObject P = C.find(C.TrackP);
                    if (P == null || !(P instanceof PointObject) && !(P instanceof PrimitiveLineObject)) {
                        throw new ConstructionException("");
                    }
                    PointObject PM = null;
                    if (C.find(C.TrackPM) != null) {
                        PM = (PointObject)C.find(C.TrackPM);
                    }
                    ConstructionObject[] po = new ConstructionObject[C.TrackPO.size()];
                    for (int i = 0; i < po.length; ++i) {
                        ConstructionObject o = C.find((String)C.TrackPO.elementAt(i));
                        if (o == null || !(o instanceof PointObject) && !(o instanceof PrimitiveLineObject)) {
                            throw new ConstructionException("");
                        }
                        po[i] = o;
                    }
                    if (C.TrackO != null) {
                        ConstructionObject O = C.find(C.TrackO);
                        if (P == null || PM == null && !(O instanceof ExpressionObject) || O == null) {
                            throw new ConstructionException("");
                        }
                        this.settool(17);
                        ObjectTracker TR = new ObjectTracker(P, PM, O, this.ZC, C.Animate, C.Paint, po);
                        if (C.Omit > 0) {
                            TR.setOmit(C.Omit);
                        }
                        this.ZC.setTool(TR);
                        this.ZC.validate();
                        this.ZC.repaint();
                        break block28;
                    }
                    if (P == null) {
                        throw new ConstructionException("");
                    }
                    this.settool(16);
                    this.ZC.setTool(new Tracker(P, po));
                    if (PM != null) {
                        PM.setSelected(true);
                    }
                    this.ZC.validate();
                    this.ZC.repaint();
                }
                catch (Exception e3) {
                    this.warning(Global.name("exception.track"));
                }
            } else if (C.AnimateP != null) {
                try {
                    PointObject P = (PointObject)C.find(C.AnimateP);
                    if (P == null) {
                        throw new ConstructionException("");
                    }
                    Enumeration e4 = C.AnimateV.elements();
                    while (e4.hasMoreElements()) {
                        String s = (String)e4.nextElement();
                        ConstructionObject o = C.find(s);
                        if (o != null && (o instanceof SegmentObject || o instanceof PrimitiveCircleObject || o instanceof PointObject)) continue;
                        throw new ConstructionException("");
                    }
                    this.settool(18);
                    this.ZC.setTool(new AnimatorTool(P, C.AnimateV, this.ZC, C.AnimateNegative, C.AnimateOriginal, C.AnimateDelay));
                }
                catch (Exception e5) {
                    this.warning(Global.name("exception.animate"));
                }
            } else if (C.AnimateBreakpoints) {
                BreakpointAnimator bp = new BreakpointAnimator();
                bp.setLoop(C.AnimateLoop);
                bp.setSpeed(C.AnimateTime);
                this.ZC.setTool(bp);
                bp.reset(this.ZC);
            } else {
                this.settool(15);
            }
        }
    }

    public void loadMacros() {
        this.FileLoad.setPattern("*.mcr *.mcrz");
        this.FileLoad.center(FRM);
        this.FileLoad.update();
        this.FileLoad.setVisible(true);
        if (this.FileLoad.isAborted()) {
            return;
        }
        String Filename = this.FileLoad.getFilePath();
        try {
            InputStream o = new FileInputStream(Filename);
            if (ZirkelFrame.isCompressed(Filename)) {
                o = new GZIPInputStream(o);
            }
            this.ZC.load(o, false, true);
            o.close();
        }
        catch (Exception e2) {
            Warning w = new Warning(FRM, Global.name("warning.loadmacros"), FileName.chop(32, e2.toString(), 64), Global.name("warning"), true);
            w.center(FRM);
            w.setVisible(true);
        }
    }

    public Frame getFrame() {
        return FRM;
    }

    public void loadJob() {
        this.testjob(false);
        this.FileLoad.setPattern("*.job *.jobz");
        this.FileLoad.center(FRM);
        this.FileLoad.update();
        this.FileLoad.setVisible(true);
        if (this.FileLoad.isAborted()) {
            return;
        }
        this.Filename = this.FileLoad.getFilePath();
        try {
            InputStream o = new FileInputStream(this.Filename);
            if (ZirkelFrame.isCompressed(this.Filename)) {
                o = new GZIPInputStream(o);
            }
            this.clear(false);
            this.ZC.load(o);
            o.close();
            FRM.setTitle(Global.name("program.name") + " : " + FileName.chop(this.Filename));
            String icons = this.ZC.getConstruction().Icons;
            if (!icons.equals("")) {
                Global.setParameter("restrictedicons", icons);
                this.showDefaultIcons(false);
            }
            if (this.ZC.isJob()) {
                this.testjob(true);
            }
            if (!this.ZC.getConstruction().getComment().equals("")) {
                this.showcomment();
            }
        }
        catch (Exception e2) {
            Warning w = new Warning(FRM, Global.name("warning.load"), FileName.chop(32, e2.toString(), 64), Global.name("warning"), true);
            w.center(FRM);
            w.setVisible(true);
        }
    }

    public void saveJob() {
        this.testjob(false);
        if (!this.ZC.isJob()) {
            this.warning(Global.name("warning.nojob"));
            return;
        }
        this.saveas("*.job *.jobz", Global.getParameter("save.compress", false) ? ".jobz" : ".job");
    }

    public void showcomment() {
    }

    public void showjobcomment() {
    }

    public void showconstruction() {
    }

    public boolean close() {
        if (pipe_tools.isApplet()) {
            return true;
        }
        if (this.ZC.changed()) {
            Question q = new Question(FRM, Global.name("savequestion.qsave"), Global.name("savequestion.title"), true);
            q.center(FRM);
            q.setVisible(true);
            if (q.yes()) {
                return this.savefile();
            }
            return q.getResult() != Question.ABORT;
        }
        return true;
    }

    public void doclose() {
    }

    @Override
    public void notifyDone() {
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.warning(Global.name("done"));
    }

    public void testjob(boolean flag) {
        if (flag == this.ZC.displayJob()) {
            return;
        }
        if (flag && !this.ZC.isJob()) {
            this.warning(Global.name("warning.nojob"));
            this.ZC.reloadCD();
            return;
        }
        this.ZC.displayJob(flag);
        if (flag) {
            this.ZC.setDoneListener(this);
        } else {
            this.ZC.setDoneListener(null);
        }
        this.ZC.reloadCD();
    }

    public void doexport(boolean solution) {
    }

    public void doexporttemplate(String template) {
    }

    public void printCheck(PrintWriter out, String s) {
        if (this.TBN == 0) {
            out.println(s);
        } else {
            out.print(s);
        }
    }

    public String readTemplateLine(BufferedReader in) throws IOException {
        if (this.TB.size() > 0) {
            String h = (String)this.TB.elementAt(this.TBN);
            ++this.TBN;
            if (this.TBN >= this.TB.size()) {
                this.TBN = 0;
                this.TB.removeAllElements();
            }
            return h;
        }
        String h = in.readLine();
        if (h == null) {
            return h;
        }
        if (h.indexOf(35) < 0) {
            return h;
        }
        this.bufferTemplate(h);
        if (this.TB.size() > 0) {
            return this.readTemplateLine(in);
        }
        return h;
    }

    public void bufferTemplate(String s) {
        int n = s.indexOf(35);
        if (n < 0) {
            this.TB.addElement(s);
            return;
        }
        String h = s.substring(n);
        if (h.startsWith("#title")) {
            this.bufferTemplate(s, n, h, "#title");
        } else if (h.startsWith("#parameter")) {
            this.bufferTemplate(s, n, h, "#parameter");
        } else if (h.startsWith("#color")) {
            this.bufferTemplate(s, n, h, "#color");
        } else if (h.startsWith("#font")) {
            this.bufferTemplate(s, n, h, "#font");
        } else if (h.startsWith("#codebase")) {
            this.bufferTemplate(s, n, h, "#codebase");
        } else if (h.startsWith("#comment")) {
            for (int i = 0; i < 10; ++i) {
                String t = "#comment" + i;
                if (!h.startsWith(t)) continue;
                this.bufferTemplate(s, n, h, t);
                return;
            }
            this.bufferTemplate(s, n, h, "#comment");
        } else if (h.startsWith("#text")) {
            for (int i = 0; i < 10; ++i) {
                String t = "#text" + i;
                if (!h.startsWith(t)) continue;
                this.bufferTemplate(s, n, h, t);
                return;
            }
            this.bufferTemplate(s, n, h, "#text");
        }
    }

    public void bufferTemplate(String s, int n, String h, String ph) {
        if (n > 0) {
            this.TB.addElement(s.substring(0, n));
        }
        this.TB.addElement(ph);
        h = h.substring(ph.length());
        if (!h.equals("")) {
            this.bufferTemplate(h);
        }
    }

    public void printParagraphs(PrintWriter out, String s, int linelength) {
        StringParser p = new StringParser(s);
        Vector v = p.wrapwords(linelength);
        for (int i = 0; i < v.size(); ++i) {
            out.println("<P>");
            s = (String)v.elementAt(i);
            StringParser q = new StringParser(s);
            Vector w = q.wraplines(linelength);
            for (int j = 0; j < w.size(); ++j) {
                if (j > 0) {
                    out.println();
                }
                s = (String)w.elementAt(j);
                out.print(s);
            }
            out.println("</P>");
        }
    }

    public int getDigits(double x) {
        return (int)(Math.log(x) / Math.log(10.0) + 0.5);
    }

    public void setPartial(boolean flag) {
        Global.setParameter("options.partial", flag);
        this.ZC.setPartial(flag);
    }

    public void setRestricted(boolean flag) {
        Global.setParameter("options.restricted", flag);
        this.ZC.setRestricted(flag);
    }

    public void setPartialLines(boolean flag) {
        Global.setParameter("options.plines", flag);
        this.ZC.setPartialLines(flag);
    }

    public void setVectors(boolean flag) {
        Global.setParameter("options.arrow", flag);
        this.ZC.setVectors(flag);
    }

    public void setLongNames(boolean flag) {
        Global.setParameter("options.longnames", flag);
        this.ZC.setLongNames(flag);
    }

    public void setBoldFont(boolean flag) {
        Global.setParameter("options.boldfont", flag);
        this.ZC.setBoldFont(flag);
    }

    public void setLargeFont(boolean flag) {
        Global.setParameter("options.largefont", flag);
        this.ZC.setLargeFont(flag);
    }

    public void setObtuse(boolean flag) {
        Global.setParameter("options.obtuse", flag);
        this.ZC.setObtuse(flag);
    }

    public void setSolid(boolean flag) {
        Global.setParameter("options.solid", flag);
        this.ZC.setSolid(flag);
    }

    public void setShowNames(boolean flag) {
        Global.setParameter("options.shownames", flag);
        this.ZC.setShowNames(flag);
    }

    public void setShowValues(boolean flag) {
        Global.setParameter("options.showvalue", flag);
        this.ZC.setShowValues(flag);
    }

    void definemacro() {
        this.ZC.defineMacro();
        this.settool(28);
        this.ZC.getOC().reset(this.ZC);
    }

    public void runMacro(boolean shift) {
        Macro m = this.ZC.chooseMacro(this.OldMacro);
        if (!shift || m == null) {
            m = this.ZC.chooseMacro();
        }
        if (m == null) {
            this.settool(this.CurrentTool);
            return;
        }
        this.runMacro(m);
    }

    @Override
    public void runMacro(Macro m) {
        ((MacroRunner)ObjectConstructors[26]).setMacro(m, this.ZC);
        this.settool(26);
        this.OldMacro = m.getName();
    }

    @Override
    public void replayChosen() {
    }

    public void setDigits() {
        this.ZC.updateDigits();
        this.ZC.repaint();
    }

    public void setLanguage() {
    }

    public void savePNG() {
    }

    public void copyPNG() {
    }

    public void saveFIG() {
    }

    public void saveSVG() {
    }

    public void savePDF() {
    }

    public void saveEPS() {
    }

    public void setVisual(boolean flag) {
    }

    public void replay() {
        this.ZC.OC.invalidate(this.ZC);
        this.ZC.getConstruction().setOriginalOrder(true);
        this.ZC.getConstruction().setOriginalOrder(false);
        this.ZC.validate();
        this.ZC.repaint();
    }

    public void reset() {
        this.ZC.reset();
        if (this.CurrentTool == 29) {
            this.settool(28);
        }
    }

    @Override
    public String loadImage() {
        this.ImageLoad.center(FRM);
        this.ImageLoad.update();
        this.ImageLoad.setVisible(true);
        if (this.ImageLoad.isAborted()) {
            return "";
        }
        return this.ImageLoad.getFilePath();
    }

    @Override
    public Image doLoadImage(String filename) {
        Image img = this.tryToLoadImage(filename);
        if (img == null) {
            img = this.tryToLoadImage(FileName.path(this.Filename) + System.getProperty("file.separator") + filename);
        }
        return img;
    }

    public Image tryToLoadImage(String filename) {
        try {
            Image i = FRM.getToolkit().getImage(filename);
            MediaTracker mt = new MediaTracker(FRM);
            mt.addImage(i, 0);
            mt.waitForID(0);
            if (mt.checkID(0) && !mt.isErrorAny()) {
                return i;
            }
            throw new Exception(Global.name("error.image"));
        }
        catch (Exception e2) {
            return null;
        }
    }

    public void loadBackground() {
        this.BackgroundLoad.center(FRM);
        this.BackgroundLoad.update();
        this.BackgroundLoad.setVisible(true);
        if (this.BackgroundLoad.isAborted()) {
            return;
        }
        String filename = this.BackgroundLoad.getFilePath();
        Media.createMedia(filename);
        this.ZC.setBackground(Media.getImage(FileName.filename(filename)));
        this.ZC.getConstruction().BackgroundFile = this.Background = FileName.filename(filename);
    }

    public void doloadBackground(String filename) {
        Media.createMedia(filename);
        this.ZC.setBackground(Media.getImage(filename));
        this.ZC.repaint();
        this.ZC.getConstruction().BackgroundFile = this.Background = FileName.filename(filename);
    }

    public void resize() {
        FRM.pack();
    }

    public void track() {
        if (this.ZC.getCurrentTool() instanceof ObjectTracker && ((ObjectTracker)this.ZC.getCurrentTool()).isComplete()) {
            Question q = new Question(FRM, Global.name("trackquestion.keep"), Global.name("trackquestion.title"), true);
            q.center(FRM);
            q.setVisible(true);
            if (q.yes()) {
                ((ObjectTracker)this.ZC.getCurrentTool()).keep(this.ZC);
            }
        }
    }

    public void restrictIcons(boolean flag) {
        if (flag) {
            this.showDefaultIcons(false);
        } else {
            this.showDefaultIcons(true);
        }
    }

    public void setinfo(String s, boolean WithTxtFocus) {
        JZirkelCanvas.setinfo(s, WithTxtFocus);
    }

    public void setinfo(String s) {
        this.setinfo(s, true);
    }

    public void loadBuiltInMacros() {
        try {
            InputStream o = this.getClass().getResourceAsStream("/carmetal/builtin.mcr");
            this.ZC.ProtectMacros = true;
            this.ZC.load(o, false, true);
            this.ZC.ProtectMacros = false;
            o.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadDefaultMacros() {
    }

    public void showDefaultIcons(boolean flag) {
        if (!flag) {
            this.ZC.clearProtectedMacros();
        } else {
            this.loadDefaultMacros();
        }
    }

    public boolean haveHelp(String subject) {
        String lang = Global.name("language", "");
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/carmetal.rene/zirkel/docs/" + lang + subject)));
            in.close();
        }
        catch (Exception e2) {
            return false;
        }
        return true;
    }

    public boolean haveFile() {
        return !this.Filename.equals("");
    }

    public void newfile(boolean defaults) {
        if (this.ZC.changed()) {
            Question q = new Question(FRM, Global.name("savequestion.qsave"), Global.name("savequestion.title"), true);
            q.center(FRM);
            q.setVisible(true);
            if (q.yes() && !this.savefile()) {
                return;
            }
            if (q.isAborted()) {
                return;
            }
        }
        this.clear(defaults);
        this.Filename = "";
        this.clearNonprotectedMacros();
        FRM.setTitle(Global.name("program.name"));
    }

    public void warning(String s) {
        Warning w = new Warning(FRM, s, "", true);
        w.center(FRM);
        w.setVisible(true);
    }

    public void showConstructionDisplay(boolean flag) {
        Global.setParameter("options.showdisplay", flag);
    }

    public void editGrid() {
    }

    static {
        DefaultColors = new Color[]{Color.black, Color.green.darker().darker(), Color.blue.darker(), new Color(150, 100, 0), Color.cyan.darker().darker(), new Color(180, 0, 0)};
        Colors = DefaultColors;
        SelectColor = Global.getParameter("colorselect", Color.red);
        IndicateColor = Global.getParameter("colorselect", Color.ORANGE);
        TargetColor = Global.getParameter("colortarget", Color.pink);
        ColorStrings = new String[]{"black", "green", "blue", "brown", "cyan", "red"};
        PointTypes = new String[]{"square", "diamond", "circle", "dot", "cross", "dcross"};
        ColorTypes = new String[]{"normal", "thick", "thin"};
        ColorTypeKeys = new int[]{53, 54, 55};
        ColorKeys = new int[]{49, 50, 51, 52};
        PointKeys = new int[]{53, 54, 55, 56, 57, 48};
        Separators = new String[]{"point", "boundedpoint", "intersection", "!line", "ray", "segment", "fixedsegment", "!circle", "circle3", "fixedcircle", "!parallel", "plumb", "midpoint", "!angle", "fixedangle", "!move", "tracker", "objecttracker", "animate", "!expression", "area", "quadric", "image", "text", "!hide", "locus", "runmacro", "edit", "parameter", "targets", "definejob", "delete", "reorder", "draw", "rename", "zoom", "animatebreak"};
        MenuTitles = new String[]{"points", "lines", "circles", "complex", "angles", "move", "decorative"};
        ObjectStrings = new String[]{"point", "boundedpoint", "intersection", "line", "ray", "segment", "fixedsegment", "circle", "circle3", "fixedcircle", "parallel", "plumb", "midpoint", "angle", "fixedangle", "move", "tracker", "objecttracker", "animate", "expression", "area", "quadric", "image", "text", "hide", "locus", "runmacro", "edit", "parameter", "targets", "definejob", "delete", "reorder", "draw", "rename", "zoom", "animatebreak"};
        ObjectConstructors = new ObjectConstructor[]{new PointConstructor(), new BoundedPointConstructor(), new IntersectionConstructor(), new LineConstructor(), new RayConstructor(), new SegmentConstructor(), new SegmentConstructor(true), new CircleConstructor(), new Circle3Constructor(), new CircleConstructor(true), new ParallelConstructor(), new PlumbConstructor(), new MidpointConstructor(), new AngleConstructor(), new AngleConstructor(true), new MoverTool(), new Tracker(), new ObjectTracker(), new AnimatorTool(), new ExpressionConstructor(), new AreaConstructor(), new QuadricConstructor(), new ImageConstructor(), new TextConstructor(), new HiderTool(), new JLocusObjectTracker(), new MacroRunner(), new EditTool(), new SetParameterTool(), new SetTargetsTool(), new SaveJob(), new DeleteTool(), new ReorderTool(), new DrawerTool(), new RenamerTool(), new ZoomerTool(), new BreakpointAnimator()};
    }
}

