/*
 * Decompiled with CFR 0.152.
 */
package carmetal.objects;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionException;
import carmetal.construction.Count;
import carmetal.objects.ConstructionObject;
import carmetal.objects.InsideObject;
import carmetal.objects.MoveableObject;
import carmetal.objects.PointObject;
import carmetal.objects.PointonObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.expression.InvalidException;
import carmetal.rene.zirkel.graphics.MyGraphics;
import carmetal.rene.zirkel.graphics.MyGraphics13;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;

public class AreaObject
extends ConstructionObject
implements InsideObject,
PointonObject,
MoveableObject {
    static Count N = new Count();
    double[] xpoints = new double[3];
    double[] ypoints = new double[3];
    double R;
    double X;
    double Y;
    double A;
    public Vector<PointObject> V;
    boolean Filled = true;
    boolean OnBoundary;
    double[] xd;
    double[] yd;
    double x1;
    double y1;

    public AreaObject(Construction c2, Vector<PointObject> v) {
        super(c2);
        this.V = v;
        this.validate();
        this.updateText();
        Global.getParameter("unit.area", "");
    }

    @Override
    public void setDefaults() {
        this.setShowName(Global.getParameter("options.area.shownames", false));
        this.setShowValue(Global.getParameter("options.area.showvalues", false));
        this.setColor(Global.getParameter("options.area.color", 0), Global.getParameter("options.area.pcolor", (Color)null));
        this.setColorType(Global.getParameter("options.area.colortype", 0));
        this.setFilled(Global.getParameter("options.area.filled", true));
        this.setSolid(Global.getParameter("options.area.solid", false));
        this.setHidden(this.Cn.Hidden);
        this.setObtuse(this.Cn.Obtuse);
        this.setLarge(this.Cn.LargeFont);
        this.setBold(this.Cn.BoldFont);
        this.setPartial(this.Cn.Partial);
    }

    @Override
    public void setTargetDefaults() {
        this.setShowName(Global.getParameter("options.area.shownames", false));
        this.setShowValue(Global.getParameter("options.area.showvalues", false));
        this.setColor(Global.getParameter("options.area.color", 0), Global.getParameter("options.area.pcolor", (Color)null));
        this.setColorType(Global.getParameter("options.area.colortype", 0));
        this.setFilled(Global.getParameter("options.area.filled", true));
        this.setSolid(Global.getParameter("options.area.solid", false));
    }

    @Override
    public String getTag() {
        return "Polygon";
    }

    @Override
    public void updateText() {
        String Text = Global.name("text.area");
        Enumeration<PointObject> en = this.V.elements();
        boolean first = true;
        while (en.hasMoreElements()) {
            PointObject p = en.nextElement();
            Text = !first ? Text + ", " : Text + " ";
            first = false;
            Text = Text + p.getName();
        }
        this.setText(Text);
    }

    @Override
    public void validate() {
        Enumeration<PointObject> e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            if (((ConstructionObject)e2.nextElement()).valid()) continue;
            this.Valid = false;
            return;
        }
        if (this.V.size() < 2) {
            this.Valid = false;
            return;
        }
        Enumeration<PointObject> en = this.V.elements();
        double x = 0.0;
        double y = 0.0;
        while (en.hasMoreElements()) {
            PointObject p = en.nextElement();
            x += p.getX();
            y += p.getY();
        }
        this.X = x / (double)this.V.size();
        this.Y = y / (double)this.V.size();
        this.A = this.area();
        this.Valid = true;
    }

    @Override
    public void paint(MyGraphics g, ZirkelCanvas zc) {
        String s;
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        int n = this.V.size();
        if (this.xpoints.length != n) {
            this.xpoints = new double[n];
            this.ypoints = new double[n];
        }
        if (this.visible(zc)) {
            Enumeration<PointObject> e2 = this.V.elements();
            int i = 0;
            while (e2.hasMoreElements()) {
                PointObject p = e2.nextElement();
                this.xpoints[i] = zc.col(p.getX());
                this.ypoints[i] = zc.row(p.getY());
                if (i > 0 && this.isStrongSelected() && g instanceof MyGraphics13) {
                    ((MyGraphics13)g).drawMarkerLine(this.xpoints[i - 1], this.ypoints[i - 1], this.xpoints[i], this.ypoints[i]);
                }
                ++i;
            }
            if (i > 1 && this.isStrongSelected() && g instanceof MyGraphics13) {
                ((MyGraphics13)g).drawMarkerLine(this.xpoints[i - 1], this.ypoints[i - 1], this.xpoints[0], this.ypoints[0]);
            }
            g.fillPolygon(this.xpoints, this.ypoints, n, this);
        }
        if (!(s = this.getDisplayText()).equals("")) {
            this.DisplaysText = true;
            this.TX1 = zc.col(this.X + this.XcOffset);
            this.TY1 = zc.row(this.Y + this.YcOffset);
            this.setFont(g);
            this.drawLabel(g, s);
        }
    }

    @Override
    public String getDisplayValue() {
        return Global.getLocaleNumber(Math.abs(this.A), "lengths");
    }

    @Override
    public void printArgs(XmlWriter xml) {
        if (!this.Filled) {
            xml.printArg("filled", "false");
        }
        Enumeration<PointObject> e2 = this.V.elements();
        int n = 1;
        while (e2.hasMoreElements()) {
            ConstructionObject o = e2.nextElement();
            xml.printArg("point" + n, o.getName());
            ++n;
        }
        super.printArgs(xml);
    }

    @Override
    public Enumeration<PointObject> depending() {
        super.depending();
        Enumeration<PointObject> e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = e2.nextElement();
            DL.add(o);
        }
        return DL.elements();
    }

    @Override
    public void translate() {
        Enumeration<PointObject> e2 = this.V.elements();
        Vector<ConstructionObject> w = new Vector<ConstructionObject>();
        while (e2.hasMoreElements()) {
            ConstructionObject o = e2.nextElement();
            w.addElement(o.getTranslation());
        }
        this.V = w;
    }

    @Override
    public boolean nearto(int c2, int r, ZirkelCanvas zc) {
        if (!this.displays(zc)) {
            return false;
        }
        return this.contains(zc.x(c2), zc.y(r));
    }

    @Override
    public boolean nearto(int c2, int r, boolean ignorefill, ZirkelCanvas zc) {
        if (!this.displays(zc)) {
            return false;
        }
        if (this.contains(zc.x(c2), zc.y(r), zc.dx(zc.selectionSize()))) {
            if (ignorefill) {
                return this.OnBoundary;
            }
            return true;
        }
        return false;
    }

    public boolean contains(double x, double y, double eps) {
        double d2;
        double b2;
        PointObject Q;
        if (!this.Valid) {
            return false;
        }
        this.OnBoundary = false;
        PointObject First2 = this.V.elementAt(0);
        PointObject P = First2;
        if (Math.max(Math.abs(P.getX() - x), Math.abs(P.getY() - y)) < eps) {
            this.OnBoundary = true;
            return true;
        }
        Enumeration<PointObject> e2 = this.V.elements();
        double a2 = Math.atan2(P.getX() - x, P.getY() - y);
        double sum = 0.0;
        while (e2.hasMoreElements()) {
            Q = e2.nextElement();
            if (Math.max(Math.abs(Q.getX() - x), Math.abs(Q.getY() - y)) < eps) {
                this.OnBoundary = true;
                return true;
            }
            b2 = Math.atan2(Q.getX() - x, Q.getY() - y);
            d2 = b2 - a2;
            if (d2 > Math.PI) {
                d2 -= Math.PI * 2;
            } else if (d2 < -Math.PI) {
                d2 += Math.PI * 2;
            }
            if (Math.abs(Math.abs(d2) - Math.PI) < 0.1) {
                this.OnBoundary = true;
                return true;
            }
            a2 = b2;
            P = Q;
            sum += d2;
        }
        Q = First2;
        b2 = Math.atan2(Q.getX() - x, Q.getY() - y);
        d2 = b2 - a2;
        if (d2 > Math.PI) {
            d2 -= Math.PI * 2;
        } else if (d2 < -Math.PI) {
            d2 += Math.PI * 2;
        }
        if (Math.abs(Math.abs(d2) - Math.PI) < 0.1) {
            this.OnBoundary = true;
            return true;
        }
        return Math.abs(sum += d2) >= 1.5707963267948966;
    }

    public boolean contains(double x, double y) {
        return this.contains(x, y, 1.0E-4);
    }

    /*
     * Unable to fully structure code
     */
    public boolean contains2(double x, double y) {
        if (!this.Valid) {
            return false;
        }
        npoints = this.V.size();
        if (npoints <= 2) {
            return false;
        }
        hits = 0;
        last = this.V.get(npoints - 1);
        lastx = last.getX();
        lasty = last.getY();
        e = this.V.elements();
        for (i = 0; i < npoints; ++i) {
            block9: {
                block12: {
                    block13: {
                        block11: {
                            block10: {
                                p = e.nextElement();
                                curx = p.getX();
                                cury = p.getY();
                                if (cury == lasty) break block9;
                                if (!(curx < lastx)) break block10;
                                if (x >= lastx) break block9;
                                leftx = curx;
                                break block11;
                            }
                            if (x >= curx) break block9;
                            leftx = lastx;
                        }
                        if (!(cury < lasty)) break block12;
                        if (y < cury || y >= lasty) break block9;
                        if (!(x < leftx)) break block13;
                        ++hits;
                        break block9;
                    }
                    test1 = x - curx;
                    test2 = y - cury;
                    ** GOTO lbl40
                }
                if (y < lasty || y >= cury) break block9;
                if (x < leftx) {
                    ++hits;
                } else {
                    test1 = x - lastx;
                    test2 = y - lasty;
lbl40:
                    // 2 sources

                    if (test1 < test2 / (lasty - cury) * (lastx - curx)) {
                        ++hits;
                    }
                }
            }
            lastx = curx;
            lasty = cury;
        }
        return (hits & true) != false;
    }

    public double area() {
        PointObject Q;
        PointObject First2;
        if (!this.Valid) {
            return -1.0;
        }
        PointObject P = First2 = this.V.elementAt(0);
        Enumeration<PointObject> e2 = this.V.elements();
        double sum = 0.0;
        while (e2.hasMoreElements()) {
            Q = e2.nextElement();
            sum += (Q.getX() - this.X) * (P.getY() - this.Y) - (Q.getY() - this.Y) * (P.getX() - this.X);
            P = Q;
        }
        Q = First2;
        return (sum += (Q.getX() - this.X) * (P.getY() - this.Y) - (Q.getY() - this.Y) * (P.getX() - this.X)) / 2.0;
    }

    @Override
    public boolean equals(ConstructionObject o) {
        int k;
        int kj;
        int j;
        boolean r;
        int i;
        if (!(o instanceof AreaObject) || !o.valid()) {
            return false;
        }
        AreaObject a2 = (AreaObject)o;
        int n = this.V.size();
        int m = a2.V.size();
        Object[] p = new PointObject[n];
        this.V.copyInto(p);
        Object[] pa = new PointObject[m];
        a2.V.copyInto(pa);
        double x0 = 0.0;
        double y0 = 0.0;
        for (i = 0; i < m; ++i) {
            r = true;
            j = 0;
            kj = 0;
            do {
                if ((k = i + kj) >= m) {
                    k -= m;
                }
                if (!((PointObject)p[j]).equals((ConstructionObject)pa[k])) {
                    if (j != 0 && this.between(x0, y0, ((PointObject)p[j]).getX(), ((PointObject)p[j]).getY(), ((PointObject)pa[k]).getX(), ((PointObject)pa[k]).getY())) continue;
                    r = false;
                    break;
                }
                x0 = ((PointObject)p[j]).getX();
                y0 = ((PointObject)p[j]).getY();
                ++j;
            } while (j < n && ++kj < m);
            if (!r || kj < m) continue;
            return true;
        }
        for (i = 0; i < m; ++i) {
            r = true;
            j = 0;
            kj = 0;
            do {
                if ((k = i + kj) >= m) {
                    k -= m;
                }
                if (!((PointObject)p[n - j - 1]).equals((ConstructionObject)pa[k])) {
                    if (j != 0 && this.between(x0, y0, ((PointObject)p[n - j - 1]).getX(), ((PointObject)p[n - j - 1]).getY(), ((PointObject)pa[k]).getX(), ((PointObject)pa[k]).getY())) continue;
                    r = false;
                    break;
                }
                x0 = ((PointObject)p[n - j - 1]).getX();
                y0 = ((PointObject)p[n - j - 1]).getY();
                ++j;
            } while (j < n && ++kj < m);
            if (!r || kj < m) continue;
            return true;
        }
        return false;
    }

    public boolean between(double x0, double y0, double x1, double y1, double x, double y) {
        double lambda = Math.abs(x1 - x0) > Math.abs(y1 - y0) ? (x - x0) / (x1 - x0) : (y - y0) / (y1 - y0);
        return Math.abs(x0 + lambda * (x1 - x0) - x) < 1.0E-10 && Math.abs(y0 + lambda * (y1 - y0) - y) < 1.0E-10;
    }

    @Override
    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.A;
    }

    @Override
    public boolean maybeTransparent() {
        return true;
    }

    @Override
    public void setFilled(boolean flag) {
        this.Filled = flag;
    }

    @Override
    public boolean isFilled() {
        return this.Filled;
    }

    @Override
    public boolean onlynearto(int x, int y, ZirkelCanvas zc) {
        return false;
    }

    public void keepBaricentricCoords(PointObject P) {
        if (P.BarycentricCoordsInitialzed && this.V.size() > 2) {
            PointObject AA = this.V.get(0);
            PointObject BB = this.V.get(1);
            PointObject CC = this.V.get(2);
            double xa = AA.getX();
            double ya = AA.getY();
            double xb = BB.getX();
            double yb = BB.getY();
            double xc = CC.getX();
            double yc = CC.getY();
            double xm = xa + P.Gx * (xb - xa) + P.Gy * (xc - xa);
            double ym = ya + P.Gx * (yb - ya) + P.Gy * (yc - ya);
            P.move(xm, ym);
        } else {
            P.computeBarycentricCoords();
        }
    }

    @Override
    public int getDistance(PointObject P) {
        double dist;
        double yh;
        double xh;
        double h;
        double r;
        double y2;
        double dy;
        double dx;
        double x2;
        double x = P.getX();
        double y = P.getY();
        Enumeration<PointObject> e2 = this.V.elements();
        PointObject p = e2.nextElement();
        double x1 = p.getX();
        double y1 = p.getY();
        double xstart = x1;
        double ystart = y1;
        int count = 0;
        double xmin = x1;
        double ymin = y1;
        double dmin = 1.0E20;
        while (e2.hasMoreElements()) {
            p = e2.nextElement();
            x2 = p.getX();
            dx = x2 - x1;
            r = dx * dx + (dy = (y2 = p.getY()) - y1) * dy;
            if (r > 1.0E-5) {
                h = dx * (x - x1) / r + dy * (y - y1) / r;
                if (h > 1.0) {
                    h = 1.0;
                } else if (h < 0.0) {
                    h = 0.0;
                }
                xh = x1 + h * dx;
                yh = y1 + h * dy;
                dist = Math.sqrt((x - xh) * (x - xh) + (y - yh) * (y - yh));
                if (dist < dmin) {
                    dmin = dist;
                    xmin = xh;
                    ymin = yh;
                }
            }
            ++count;
            x1 = x2;
            y1 = y2;
        }
        x2 = xstart;
        dx = x2 - x1;
        y2 = ystart;
        dy = y2 - y1;
        r = dx * dx + dy * dy;
        if (r > 1.0E-5) {
            h = dx * (x - x1) / r + dy * (y - y1) / r;
            if (h > 1.0) {
                h = 1.0;
            } else if (h < 0.0) {
                h = 0.0;
            }
            xh = x1 + h * dx;
            yh = y1 + h * dy;
            dist = Math.sqrt((x - xh) * (x - xh) + (y - yh) * (y - yh));
            if (dist < dmin) {
                dmin = dist;
                xmin = xh;
                ymin = yh;
            }
        }
        double dd = Math.sqrt((P.getX() - xmin) * (P.getX() - xmin) + (P.getY() - ymin) * (P.getY() - ymin));
        return (int)Math.round(dd * this.Cn.getPixel());
    }

    @Override
    public void project(PointObject P) {
        double dist;
        double yh;
        double xh;
        double h;
        double r;
        double y2;
        double dy;
        double dx;
        double x2;
        double x = P.getX();
        double y = P.getY();
        Enumeration<PointObject> e2 = this.V.elements();
        PointObject p = e2.nextElement();
        double x1 = p.getX();
        double y1 = p.getY();
        double xstart = x1;
        double ystart = y1;
        int count = 0;
        double xmin = x1;
        double ymin = y1;
        double dmin = 1.0E20;
        double hmin = 0.0;
        while (e2.hasMoreElements()) {
            p = e2.nextElement();
            x2 = p.getX();
            dx = x2 - x1;
            r = dx * dx + (dy = (y2 = p.getY()) - y1) * dy;
            if (r > 1.0E-5) {
                h = dx * (x - x1) / r + dy * (y - y1) / r;
                if (h > 1.0) {
                    h = 1.0;
                } else if (h < 0.0) {
                    h = 0.0;
                }
                xh = x1 + h * dx;
                yh = y1 + h * dy;
                dist = Math.sqrt((x - xh) * (x - xh) + (y - yh) * (y - yh));
                if (dist < dmin) {
                    dmin = dist;
                    xmin = xh;
                    ymin = yh;
                    hmin = (double)count + h;
                }
            }
            ++count;
            x1 = x2;
            y1 = y2;
        }
        x2 = xstart;
        dx = x2 - x1;
        y2 = ystart;
        dy = y2 - y1;
        r = dx * dx + dy * dy;
        if (r > 1.0E-5) {
            h = dx * (x - x1) / r + dy * (y - y1) / r;
            if (h > 1.0) {
                h = 1.0;
            } else if (h < 0.0) {
                h = 0.0;
            }
            xh = x1 + h * dx;
            yh = y1 + h * dy;
            dist = Math.sqrt((x - xh) * (x - xh) + (y - yh) * (y - yh));
            if (dist < dmin) {
                dmin = dist;
                xmin = xh;
                ymin = yh;
                hmin = (double)count + h;
            }
        }
        P.move(xmin, ymin);
        P.setA(hmin);
    }

    @Override
    public void project(PointObject P, double alpha) {
        int i = (int)Math.floor(alpha);
        double h = alpha - (double)i;
        if (i < 0 || i >= this.V.size()) {
            this.project(P);
            return;
        }
        PointObject P1 = this.V.elementAt(i);
        PointObject P2 = i == this.V.size() - 1 ? this.V.elementAt(0) : this.V.elementAt(i + 1);
        P.setXY(P1.getX() + h * (P2.getX() - P1.getX()), P1.getY() + h * (P2.getY() - P1.getY()));
    }

    @Override
    public double containsInside(PointObject P) {
        boolean inside = this.contains2(P.getX(), P.getY());
        if (inside && this.OnBoundary) {
            return 0.5;
        }
        if (inside) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public boolean keepInside(PointObject P) {
        this.keepBaricentricCoords(P);
        if (this.contains2(P.getX(), P.getY())) {
            return true;
        }
        this.project(P);
        return false;
    }

    @Override
    public void dragTo(double x, double y) {
        Enumeration<PointObject> e2 = this.V.elements();
        int i = 0;
        while (e2.hasMoreElements()) {
            PointObject p = e2.nextElement();
            p.move(this.xd[i] + (x - this.x1), this.yd[i] + (y - this.y1));
            ++i;
        }
    }

    @Override
    public void move(double x, double y) {
    }

    @Override
    public boolean moveable() {
        if (this.V == null) {
            return false;
        }
        Enumeration<PointObject> e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            if (e2.nextElement().moveable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void startDrag(double x, double y) {
        if (this.xd == null || this.xd.length != this.V.size()) {
            this.xd = new double[this.V.size()];
            this.yd = new double[this.V.size()];
        }
        Enumeration<PointObject> e2 = this.V.elements();
        int i = 0;
        while (e2.hasMoreElements()) {
            PointObject p = e2.nextElement();
            this.xd[i] = p.getX();
            this.yd[i] = p.getY();
            ++i;
        }
        this.x1 = x;
        this.y1 = y;
    }

    @Override
    public double getOldX() {
        return 0.0;
    }

    @Override
    public double getOldY() {
        return 0.0;
    }

    @Override
    public void snap(ZirkelCanvas zc) {
        if (this.moveable()) {
            Enumeration<PointObject> e2 = this.V.elements();
            while (e2.hasMoreElements()) {
                PointObject p = e2.nextElement();
                p.snap(zc);
            }
        }
    }

    @Override
    public boolean canInteresectWith(ConstructionObject o) {
        Enumeration<PointObject> e2;
        PointObject P;
        ConstructionObject line;
        return !(o instanceof PointonObject) || !(line = o).contains(P = (e2 = this.V.elements()).nextElement());
    }

    @Override
    public void repulse(PointObject P) {
        this.project(P);
    }
}

