/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.macros;

import carmetal.eric.GUI.themes;
import carmetal.eric.JGeneralMenuBar;
import carmetal.eric.JZirkelCanvas;
import carmetal.eric.macros.CTree;
import carmetal.eric.macros.CreateMacroDialog;
import carmetal.eric.macros.JDefaultMutableTreeNode;
import carmetal.eric.macros.MacroTools;
import carmetal.rene.gui.Global;
import carmetal.rene.gui.MyMenu;
import carmetal.rene.zirkel.ZirkelFrame;
import carmetal.rene.zirkel.macro.Macro;
import carmetal.rene.zirkel.macro.MacroItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MacrosList
extends JPanel {
    private final int CONTROLHEIGHT = 25;
    private final ImageIcon JTreefoldclosed;
    private final ImageIcon JTreefoldopened;
    private final ImageIcon[] JTreeleaf;
    private CTree MacrosTree;
    private JDefaultMutableTreeNode MacroTreeTopNode = new JDefaultMutableTreeNode("Macros");
    private ZirkelFrame ZF;
    private JScrollPane jscrolls;
    private JControls controls;

    public MacrosList(ZirkelFrame zf) {
        this.ZF = zf;
        this.JTreefoldclosed = themes.getIcon("JTreefoldclosed.gif");
        this.JTreefoldopened = themes.getIcon("JTreefoldopened.gif");
        this.JTreeleaf = new ImageIcon[4];
        this.JTreeleaf[0] = themes.getIcon("JTreeleaf_0.gif");
        this.JTreeleaf[1] = themes.getIcon("JTreeleaf_1.gif");
        this.JTreeleaf[2] = themes.getIcon("JTreeleaf_2.gif");
        this.JTreeleaf[3] = themes.getIcon("JTreeleaf_3.gif");
        this.setLayout(new BoxLayout(this, 1));
        this.MacroTreeTopNode = new JDefaultMutableTreeNode("Macros");
        this.MacrosTree = new CTree(this){

            @Override
            public void paint(Graphics g) {
                ImageIcon backimage = themes.getIcon("macrospanelback.gif");
                g.drawImage(backimage.getImage(), 0, 0, this.getSize().width, backimage.getIconHeight(), this);
                super.paint(g);
            }
        };
        this.MacrosTree.setFocusable(false);
        this.MacrosTree.setModel(new MyTreeModel(this.MacroTreeTopNode));
        this.MacrosTree.getSelectionModel().setSelectionMode(4);
        MyCellRenderer renderer = new MyCellRenderer();
        this.MacrosTree.setCellRenderer(renderer);
        this.MacrosTree.setCellEditor(new MyDefaultCellEditor());
        this.MacrosTree.setOpaque(false);
        this.MacrosTree.setFont(new Font(Global.GlobalFont, 0, 12));
        this.MacrosTree.setForeground(new Color(70, 70, 70));
        this.MacrosTree.setDragEnabled(false);
        this.MacrosTree.setEditable(false);
        this.jscrolls = new JScrollPane(this.MacrosTree);
        this.jscrolls.setAlignmentX(0.0f);
        this.jscrolls.setBorder(BorderFactory.createEmptyBorder());
        this.add(this.jscrolls);
        this.controls = new JControls(this);
        this.add(this.controls);
    }

    public JDefaultMutableTreeNode getTopNode() {
        return this.MacroTreeTopNode;
    }

    public CTree getMacrosTree() {
        return this.MacrosTree;
    }

    public void initTreeFromZCMacros() {
        this.MacroTreeTopNode.removeAllChildren();
        Vector mc = this.ZF.ZC.getMacros();
        for (int i = 0; i < mc.size(); ++i) {
            Macro m = ((MacroItem)mc.elementAt((int)i)).M;
            if (!this.ZF.ZC.isLibraryMacrosVisible() && m.isProtected()) continue;
            this.AddMacroToTree(m);
        }
        this.MacrosTree.setModel(new MyTreeModel(this.MacroTreeTopNode));
        this.MacrosTree.getSelectionModel().setSelectionMode(4);
        MyCellRenderer renderer = new MyCellRenderer();
        this.MacrosTree.setCellRenderer(renderer);
        this.MacrosTree.setCellEditor(new MyDefaultCellEditor());
        this.ActualiseMacroPopupMenu();
    }

    public void fixPanelSize(int w, int h) {
        MacrosList.fixsize(this, w, h);
        MacrosList.fixsize(this.jscrolls, w, h - 25);
        MacrosList.fixsize(this.MacrosTree, w, h - 25);
        MacrosList.fixsize(this.controls, w, 25);
    }

    private static void fixsize(JComponent cp, int w, int h) {
        Dimension d2 = new Dimension(w, h);
        cp.setMaximumSize(d2);
        cp.setMinimumSize(d2);
        cp.setPreferredSize(d2);
        cp.setSize(d2);
    }

    public void AddMacroToTree(Macro m) {
        if (m.getName().startsWith("@builtin@")) {
            return;
        }
        String[] mypath = m.getName().split("/");
        JDefaultMutableTreeNode mother = this.MacroTreeTopNode;
        for (int i = 0; i < mypath.length - 1; ++i) {
            mother = this.getFolder(mother, mypath[i]);
        }
        JDefaultMutableTreeNode node = new JDefaultMutableTreeNode(this.ZF, m);
        mother.add(node);
    }

    private JDefaultMutableTreeNode getFolder(JDefaultMutableTreeNode father, String name) {
        for (int i = 0; i < father.getChildCount(); ++i) {
            if (!name.equals((String)((JDefaultMutableTreeNode)father.getChildAt(i)).getUserObject())) continue;
            return (JDefaultMutableTreeNode)father.getChildAt(i);
        }
        JDefaultMutableTreeNode node = new JDefaultMutableTreeNode(name);
        father.add(node);
        return node;
    }

    public void ActualiseMacroPopupMenu() {
        MyMenu pm = new MyMenu("root");
        JMenu jm = new JMenu("root");
        if (this.MacroTreeTopNode.getChildCount() > 0) {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            this.ParseMacroTree(pm, jm, this.MacroTreeTopNode, "root");
            this.ZF.ZC.PM.removeAll();
            JGeneralMenuBar.s_InitMacrosMenu();
            JMenu jmroot = (JMenu)jm.getItem(0);
            MyMenu pmroot = (MyMenu)pm.getItem(0);
            while (pmroot.getItemCount() > 0) {
                this.ZF.ZC.PM.add(pmroot.getItem(0));
                JGeneralMenuBar.addMacrosMenu(jmroot.getItem(0));
            }
        } else {
            this.ZF.ZC.PM.removeAll();
            JGeneralMenuBar.s_InitMacrosMenu();
        }
        MacroTools.updateLibraryMacros();
    }

    private void ParseMacroTree(MyMenu PMmenu, JMenu JMmenu, JDefaultMutableTreeNode node, String path) {
        String mypath = path;
        if (!node.isLeaf()) {
            MyMenu mymenu = new MyMenu((String)node.getUserObject());
            JMenu myjmenu = new JMenu((String)node.getUserObject());
            myjmenu.setFont(new Font("System", 0, 13));
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.ParseMacroTree(mymenu, myjmenu, (JDefaultMutableTreeNode)node.getChildAt(i), mypath + "/" + mymenu.getLabel());
            }
            PMmenu.add(mymenu);
            JMmenu.add(myjmenu);
        } else {
            String myname = (String)node.getUserObject();
            if (!myname.startsWith("-- ")) {
                node.ActualisePath();
                PMmenu.add(node.PMmenuitem);
                JMmenu.add(node.MainMenuItem);
            } else if (node.getParent().getChildCount() > 1) {
                ((DefaultTreeModel)this.MacrosTree.getModel()).removeNodeFromParent(node);
            }
        }
    }

    class JControls
    extends JPanel {
        private JButton addbtn;
        private JButton delbtn;
        private JButton renbtn;
        private JButton createbtn;
        private String message = "";
        private MacrosList MI;

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension d2 = this.getSize();
            g.drawImage(themes.getImage("tab_bottom.gif"), 0, 0, d2.width, d2.height, this);
        }

        public void setButtonsIcons() {
            this.addbtn.setIcon(themes.getIcon("addmacrofolder.png"));
            this.addbtn.setRolloverIcon(themes.getIcon("addmacrofoldersel.png"));
            this.delbtn.setIcon(themes.getIcon("delmacro.png"));
            this.delbtn.setToolTipText(Global.Loc("macros.deleteselected"));
            this.renbtn.setIcon(themes.getIcon("renamemacro.png"));
            this.renbtn.setRolloverIcon(themes.getIcon("renamemacrosel.png"));
            this.createbtn.setIcon(themes.getIcon("createmacro.png"));
            this.createbtn.setRolloverIcon(themes.getIcon("createmacroover.png"));
        }

        public JControls(MacrosList mi) {
            this.MI = mi;
            this.setLayout(new BoxLayout(this, 0));
            this.setAlignmentX(0.0f);
            this.addbtn = new JButton();
            this.addbtn.setToolTipText(Global.Loc("macros.addfolder"));
            this.addbtn.setOpaque(false);
            this.addbtn.setContentAreaFilled(false);
            this.addbtn.setBorder(BorderFactory.createEmptyBorder());
            this.addbtn.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    ((MacrosList)MacrosList.this).MacrosTree.nodepopup.addfolder();
                }
            });
            this.delbtn = new JButton();
            this.delbtn.setOpaque(false);
            this.delbtn.setContentAreaFilled(false);
            this.delbtn.setBorder(BorderFactory.createEmptyBorder());
            this.delbtn.setRolloverIcon(themes.getIcon("delmacrosel.png"));
            this.delbtn.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    System.out.println("size=" + JZirkelCanvas.getCurrentZC().getMacros().size());
                }
            });
            this.renbtn = new JButton();
            this.renbtn.setToolTipText(Global.Loc("macros.renamemacro"));
            this.renbtn.setOpaque(false);
            this.renbtn.setContentAreaFilled(false);
            this.renbtn.setBorder(BorderFactory.createEmptyBorder());
            this.renbtn.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    ((MacrosList)MacrosList.this).MacrosTree.nodepopup.renamenode();
                }
            });
            this.createbtn = new JButton();
            this.createbtn.setToolTipText(Global.Loc("macros.recordmacro"));
            this.createbtn.setSelectedIcon(themes.getIcon("createmacrosel.png"));
            this.createbtn.setBorder(BorderFactory.createEmptyBorder());
            this.createbtn.setOpaque(false);
            this.createbtn.setContentAreaFilled(false);
            this.createbtn.setSelected(false);
            this.setButtonsIcons();
            this.createbtn.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e2) {
                }

                @Override
                public void mouseExited(MouseEvent e2) {
                }

                @Override
                public void mousePressed(MouseEvent e2) {
                    if (JControls.this.createbtn.isSelected()) {
                        JControls.this.createbtn.setSelected(false);
                    } else {
                        JControls.this.createbtn.setSelected(true);
                        new CreateMacroDialog(JControls.this.MI);
                    }
                }
            });
            JPanel spacer = new JPanel();
            spacer.setOpaque(false);
            this.add(this.addbtn);
            this.add(this.delbtn);
            this.add(this.renbtn);
            this.add(spacer);
            this.add(this.createbtn);
        }
    }

    class MyTreeModel
    extends DefaultTreeModel
    implements TreeModelListener {
        public MyTreeModel(TreeNode node) {
            super(node);
            this.addTreeModelListener(this);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            JDefaultMutableTreeNode tn = (JDefaultMutableTreeNode)path.getLastPathComponent();
            super.valueForPathChanged(path, newValue);
            tn.ActualisePath();
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MacrosList.this.ActualiseMacroPopupMenu();
                }
            });
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MacrosList.this.ActualiseMacroPopupMenu();
                }
            });
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MacrosList.this.ActualiseMacroPopupMenu();
                }
            });
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MacrosList.this.ActualiseMacroPopupMenu();
                }
            });
        }
    }

    class MyCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        public MyCellRenderer() {
            this.setOpaque(false);
            this.setBackground(null);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String stringValue = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
            this.setText(stringValue);
            this.setEnabled(tree.isEnabled());
            this.setFont(tree.getFont());
            this.setForeground(Color.black);
            this.setOpaque(sel);
            this.setBackground(Color.lightGray);
            JDefaultMutableTreeNode mynode = (JDefaultMutableTreeNode)value;
            if (leaf) {
                this.setIcon(stringValue.startsWith("-- ") ? null : MacrosList.this.JTreeleaf[mynode.macrotype]);
                if (mynode.macrotype == 0) {
                    this.setForeground(new Color(68, 84, 131));
                }
            } else {
                this.setIcon(expanded ? MacrosList.this.JTreefoldopened : MacrosList.this.JTreefoldclosed);
            }
            return this;
        }
    }

    class MyDefaultCellEditor
    extends DefaultCellEditor {
        JTextField jtf;

        public MyDefaultCellEditor() {
            super(new JTextField());
            this.jtf = (JTextField)this.getComponent();
            this.jtf.setFocusTraversalKeysEnabled(false);
            this.jtf.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.jtf.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e2) {
                    MyDefaultCellEditor.this.adjust(e2.getKeyChar());
                }

                @Override
                public void keyPressed(KeyEvent e2) {
                    if (e2.getKeyCode() == 27 || e2.getKeyCode() == 9) {
                        MyDefaultCellEditor.this.fireEditingStopped();
                    }
                }
            });
        }

        private void adjust(char ad) {
            FontMetrics fm = MacrosList.this.getFontMetrics(this.jtf.getFont());
            this.jtf.setSize(fm.stringWidth(this.jtf.getText() + ad) + 5, this.jtf.getHeight());
        }

        @Override
        protected void fireEditingCanceled() {
            super.fireEditingStopped();
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }

        @Override
        public Object getCellEditorValue() {
            return super.getCellEditorValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }
}

