/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.controls;

import carmetal.eric.GUI.palette.PaletteManager;
import carmetal.eric.JZirkelCanvas;
import carmetal.eric.bar.JPropertiesBar;
import carmetal.eric.controls.JCanvasButton;
import carmetal.eric.controls.JCanvasCheckBox;
import carmetal.eric.controls.JCanvasPanel;
import carmetal.eric.controls.JCanvasPopup;
import carmetal.eric.controls.JCanvasSlider;
import carmetal.eric.controls.JCanvasTxtfield;
import carmetal.objects.ConstructionObject;
import carmetal.objects.ExpressionObject;
import carmetal.objects.TextObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlTag;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class JControlsManager {
    static Color bordercolor1 = new Color(80, 80, 80);
    static Color bordercolor2 = new Color(180, 180, 250);
    static int MAGNET = 10;
    ZirkelCanvas ZC;
    ArrayList<JCanvasPanel> CPs = new ArrayList();
    Rectangle r = new Rectangle();
    Rectangle r2 = new Rectangle();
    ArrayList<XmlTag> XmlTags = new ArrayList();

    public JControlsManager(ZirkelCanvas zc) {
        this.ZC = zc;
    }

    public void addControl(JCanvasPanel jcp, boolean editme, int x, int y, int w, int h) {
        jcp.setDims(x, y, w, h);
        this.CPs.add(jcp);
        this.ZC.add(jcp);
        this.showHandles(jcp);
        this.ZC.revalidate();
        if (editme) {
            JPropertiesBar.EditObject(jcp);
        }
    }

    public JCanvasCheckBox addChkBox(ExpressionObject o, int x, int y, int w, int h) {
        JCanvasCheckBox jcb = new JCanvasCheckBox(this.ZC, o);
        this.addControl(jcb, o == null, x, y, w, h);
        return jcb;
    }

    public JCanvasButton addButton(ExpressionObject o, int x, int y, int w, int h) {
        JCanvasButton jcb = new JCanvasButton(this.ZC, o);
        this.addControl(jcb, o == null, x, y, w, h);
        return jcb;
    }

    public JCanvasTxtfield addTxtField(ExpressionObject o, int x, int y, int w, int h) {
        JCanvasTxtfield jcb = new JCanvasTxtfield(this.ZC, o);
        this.addControl(jcb, o == null, x, y, w, h);
        return jcb;
    }

    public JCanvasSlider addSlider(ExpressionObject o, int x, int y, int w, int h) {
        JCanvasSlider jcs = new JCanvasSlider(this.ZC, o, -5.0, 5.0, -2.0);
        this.addControl(jcs, o == null, x, y, w, h);
        return jcs;
    }

    public JCanvasPopup addPopup(ExpressionObject o, int x, int y, int w, int h) {
        JCanvasPopup jcp = new JCanvasPopup(this.ZC, o);
        this.addControl(jcp, o == null, x, y, w, h);
        return jcp;
    }

    public void analyseResize(JCanvasPanel jp) {
        this.r = jp.getBounds(this.r);
        for (int i = 0; i < this.CPs.size(); ++i) {
            JCanvasPanel jp2 = this.CPs.get(i);
            if (jp2.equals(jp)) continue;
            this.r2 = jp2.getBounds(this.r2);
            if (Math.abs(this.r2.x + this.r2.width - this.r.x - this.r.width) >= MAGNET) continue;
            jp.grow(this.r2.x + this.r2.width - this.r.x - this.r.width, 0);
            this.showBordersRight(jp);
            return;
        }
        this.showBordersRight(jp);
    }

    public void analyseXY(JCanvasPanel jp) {
        this.r = jp.getBounds(this.r);
        for (int i = 0; i < this.CPs.size(); ++i) {
            JCanvasPanel jp2 = this.CPs.get(i);
            if (jp2.equals(jp)) continue;
            this.r2 = jp2.getBounds(this.r2);
            if (Math.abs(this.r2.x - this.r.x) < MAGNET) {
                jp.setLocation(this.r2.x, this.r.y);
                this.r = jp.getBounds(this.r);
            }
            if (Math.abs(this.r2.x + this.r2.width - this.r.x - this.r.width) < MAGNET) {
                jp.setLocation(this.r2.x + this.r2.width - this.r.width, this.r.y);
                this.r = jp.getBounds(this.r);
            }
            if (Math.abs(this.r2.y + this.r2.height / 2 - this.r.y - this.r.height / 2) >= MAGNET) continue;
            jp.setLocation(this.r.x, this.r2.y + this.r2.height / 2 - this.r.height / 2);
            this.r = jp.getBounds(this.r);
        }
        this.showBorders(jp);
    }

    public void showBordersRight(JCanvasPanel jp) {
        this.r = jp.getBounds(this.r);
        for (int i = 0; i < this.CPs.size(); ++i) {
            JCanvasPanel jp2 = this.CPs.get(i);
            if (jp2.equals(jp)) continue;
            this.r2 = jp2.getBounds(this.r2);
            jp2.hideBorder();
            if (this.r2.x + this.r2.width - this.r.x - this.r.width != 0) continue;
            jp2.showBorder();
        }
    }

    public void showBorders(JCanvasPanel jp) {
        this.r = jp.getBounds(this.r);
        for (int i = 0; i < this.CPs.size(); ++i) {
            JCanvasPanel jp2 = this.CPs.get(i);
            if (jp2.equals(jp)) continue;
            this.r2 = jp2.getBounds(this.r2);
            jp2.hideBorder();
            if (this.r2.x == this.r.x) {
                jp2.showBorder();
            }
            if (this.r2.x + this.r2.width - this.r.x - this.r.width == 0) {
                jp2.showBorder();
            }
            if (this.r2.y + this.r2.height / 2 - this.r.y - this.r.height / 2 != 0) continue;
            jp2.showBorder();
        }
    }

    public void updateDigits() {
        for (int i = 0; i < this.CPs.size(); ++i) {
            JCanvasPanel jp2 = this.CPs.get(i);
            jp2.setVal(jp2.getVal());
        }
    }

    public void hideBorders(JCanvasPanel jp) {
        for (int i = 0; i < this.CPs.size(); ++i) {
            JCanvasPanel jp2 = this.CPs.get(i);
            if (jp2.equals(jp)) continue;
            jp2.hideBorder();
        }
    }

    public void hideHandles(JCanvasPanel jp) {
        for (int i = 0; i < this.CPs.size(); ++i) {
            JCanvasPanel jp2 = this.CPs.get(i);
            if (jp2.equals(jp)) continue;
            jp2.hideHandle();
        }
    }

    public void showHandles(JCanvasPanel jp) {
        this.hideHandles(jp);
        jp.showHandle();
    }

    public static boolean createControl(ZirkelCanvas zc, MouseEvent e2) {
        if (JZirkelCanvas.getCurrentJZF() == null) {
            return false;
        }
        if (JZirkelCanvas.isRestrictedSession()) {
            return false;
        }
        if (e2.isPopupTrigger()) {
            return false;
        }
        int x = e2.getX();
        int y = e2.getY();
        JControlsManager myJCM = zc.JCM;
        if (PaletteManager.isSelected("ctrl_slider")) {
            myJCM.addSlider(null, x, y, 200, 29);
            return true;
        }
        if (PaletteManager.isSelected("ctrl_popup")) {
            myJCM.addPopup(null, x, y, 120, 22);
            return true;
        }
        if (PaletteManager.isSelected("ctrl_chkbox")) {
            myJCM.addChkBox(null, x, y, 30, 22);
            return true;
        }
        if (PaletteManager.isSelected("ctrl_txtfield")) {
            myJCM.addTxtField(null, x, y, 120, 22);
            return true;
        }
        if (PaletteManager.isSelected("ctrl_button")) {
            myJCM.addButton(null, x, y, 100, 22);
            return true;
        }
        return false;
    }

    public void removeAllControls() {
        while (this.CPs.size() != 0) {
            JCanvasPanel jp = this.CPs.get(0);
            this.CPs.remove(jp);
            this.ZC.delete(jp.O);
            this.ZC.remove(jp);
        }
        this.ZC.revalidate();
    }

    public static void removeOwnerControl(ZirkelCanvas zc, ConstructionObject o) {
        if (!(o instanceof ExpressionObject)) {
            return;
        }
        for (int i = 0; i < zc.JCM.CPs.size(); ++i) {
            JCanvasPanel jp = zc.JCM.CPs.get(i);
            if (o != jp.O) continue;
            zc.JCM.removeControl(jp);
        }
    }

    public void removeControl(JCanvasPanel jp) {
        this.CPs.remove(jp);
        this.ZC.delete(jp.O);
        this.ZC.remove(jp);
        this.ZC.revalidate();
    }

    public static void PrintXmlTags(ZirkelCanvas zc, XmlWriter xml) {
        for (int i = 0; i < zc.JCM.CPs.size(); ++i) {
            zc.JCM.CPs.get(i).PrintXmlTags(xml);
        }
    }

    public void addSlider(XmlTag tag) {
        ExpressionObject o = (ExpressionObject)this.ZC.getConstruction().find(tag.getValue("Ename"));
        JCanvasSlider jcs = this.addSlider(o, Integer.parseInt(tag.getValue("x")), Integer.parseInt(tag.getValue("y")), Integer.parseInt(tag.getValue("w")), Integer.parseInt(tag.getValue("h")));
        jcs.hidden = Boolean.valueOf(tag.getValue("hidden"));
        jcs.showcom = Boolean.valueOf(tag.getValue("showC"));
        jcs.showunit = Boolean.valueOf(tag.getValue("showU"));
        jcs.showval = Boolean.valueOf(tag.getValue("showV"));
        jcs.lbl_com = tag.getValue("C");
        jcs.lbl_unit = tag.getValue("U");
        jcs.xTICKS = Double.valueOf(tag.getValue("T"));
        jcs.xMIN = Double.valueOf(tag.getValue("min"));
        jcs.xMAX = Double.valueOf(tag.getValue("max"));
        jcs.setVal(Double.valueOf(tag.getValue("V")));
        jcs.setTicks(jcs.xTICKS);
        jcs.JCS.setSnapToTicks(Boolean.valueOf(tag.getValue("fixT")));
        jcs.JCS.setPaintTicks(Boolean.valueOf(tag.getValue("showT")));
        jcs.setGoodKnobPos(Double.valueOf(tag.getValue("V")));
    }

    public void addTxtField(XmlTag tag) {
        ExpressionObject o = (ExpressionObject)this.ZC.getConstruction().find(tag.getValue("Ename"));
        JCanvasTxtfield jcs = this.addTxtField(o, Integer.parseInt(tag.getValue("x")), Integer.parseInt(tag.getValue("y")), Integer.parseInt(tag.getValue("w")), Integer.parseInt(tag.getValue("h")));
        jcs.hidden = Boolean.valueOf(tag.getValue("hidden"));
        jcs.showcom = Boolean.valueOf(tag.getValue("showC"));
        jcs.showunit = Boolean.valueOf(tag.getValue("showU"));
        jcs.showval = Boolean.valueOf(tag.getValue("showV"));
        jcs.lbl_com = tag.getValue("C");
        jcs.lbl_unit = tag.getValue("U");
        jcs.setVal(tag.getValue("txt"));
        jcs.JCB.setText(tag.getValue("txt"));
    }

    public void addChkBox(XmlTag tag) {
        ExpressionObject o = (ExpressionObject)this.ZC.getConstruction().find(tag.getValue("Ename"));
        JCanvasCheckBox jcs = this.addChkBox(o, Integer.parseInt(tag.getValue("x")), Integer.parseInt(tag.getValue("y")), Integer.parseInt(tag.getValue("w")), Integer.parseInt(tag.getValue("h")));
        jcs.hidden = Boolean.valueOf(tag.getValue("hidden"));
        jcs.showcom = Boolean.valueOf(tag.getValue("showC"));
        jcs.showunit = Boolean.valueOf(tag.getValue("showU"));
        jcs.showval = Boolean.valueOf(tag.getValue("showV"));
        jcs.lbl_com = tag.getValue("C");
        jcs.lbl_unit = tag.getValue("U");
        double chked = Double.valueOf(tag.getValue("V"));
        jcs.setVal(chked);
        jcs.JCB.setSelected(chked == 1.0);
    }

    public void addButton(XmlTag tag) {
        ExpressionObject o = (ExpressionObject)this.ZC.getConstruction().find(tag.getValue("Ename"));
        JCanvasButton jcs = this.addButton(o, Integer.parseInt(tag.getValue("x")), Integer.parseInt(tag.getValue("y")), Integer.parseInt(tag.getValue("w")), Integer.parseInt(tag.getValue("h")));
        jcs.hidden = Boolean.valueOf(tag.getValue("hidden"));
        jcs.showcom = Boolean.valueOf(tag.getValue("showC"));
        jcs.showunit = Boolean.valueOf(tag.getValue("showU"));
        jcs.showval = Boolean.valueOf(tag.getValue("showV"));
        jcs.lbl_com = tag.getValue("C");
        jcs.lbl_unit = tag.getValue("U");
        jcs.setVal(Double.valueOf(tag.getValue("V")));
        jcs.setComment(jcs.lbl_com);
    }

    public void addPopup(XmlTag tag) {
        ExpressionObject o = (ExpressionObject)this.ZC.getConstruction().find(tag.getValue("Ename"));
        JCanvasPopup jcs = this.addPopup(o, Integer.parseInt(tag.getValue("x")), Integer.parseInt(tag.getValue("y")), Integer.parseInt(tag.getValue("w")), Integer.parseInt(tag.getValue("h")));
        jcs.hidden = Boolean.valueOf(tag.getValue("hidden"));
        jcs.showcom = Boolean.valueOf(tag.getValue("showC"));
        jcs.showunit = Boolean.valueOf(tag.getValue("showU"));
        jcs.showval = Boolean.valueOf(tag.getValue("showV"));
        jcs.lbl_com = tag.getValue("C");
        jcs.lbl_unit = tag.getValue("U");
        jcs.setItems(tag.getValue("Items").replace("@@@", "\n"));
        double v = Double.valueOf(tag.getValue("V"));
        jcs.setVal(Math.round(v));
        jcs.JCB.setSelectedIndex((int)Math.round(v - 1.0));
    }

    public void fix3Dcomments() {
        if (this.CPs.size() > 1) {
            JCanvasPanel jp = this.CPs.get(0);
            jp.setComment(Global.Loc("canvas.3D.floor"));
            jp = this.CPs.get(1);
            jp.setComment(Global.Loc("canvas.3D.system"));
            TextObject t = (TextObject)this.ZC.getConstruction().find("Text2");
            if (t != null) {
                t.setLines(Global.Loc("canvas.3D.rightclic"));
            }
        }
    }

    public void collectXmlTag(XmlTag tag) {
        this.XmlTags.add(tag);
    }

    public void readXmlTags() {
        for (int i = 0; i < this.XmlTags.size(); ++i) {
            XmlTag tag = this.XmlTags.get(i);
            if (tag.name().equals("CTRLslider")) {
                this.addSlider(tag);
                continue;
            }
            if (tag.name().equals("CTRLcheckbox")) {
                this.addChkBox(tag);
                continue;
            }
            if (tag.name().equals("CTRLbutton")) {
                this.addButton(tag);
                continue;
            }
            if (tag.name().equals("CTRLpopup")) {
                this.addPopup(tag);
                continue;
            }
            if (!tag.name().equals("CTRLtxtfield")) continue;
            this.addTxtField(tag);
        }
        if (this.XmlTags.size() > 0) {
            this.XmlTags.clear();
            this.hideHandles(null);
        }
    }
}

