/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric;

import carmetal.eric.GUI.palette.JIcon;
import carmetal.eric.JColors;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.java.dev.colorchooser.ColorChooser;
import net.java.dev.colorchooser.Palette;

public class JColorPicker
extends JButton {
    ColorChooser CC = null;
    int D;
    int IN;
    int STRK;
    public static Color DefaultC = Color.GRAY;
    Color CurrentC = DefaultC;
    boolean isSelected = false;
    boolean isEntered = false;
    boolean isDisabled = false;
    Vector group;
    int[] x = new int[]{0, 10, 0};
    int[] y = new int[]{0, 10, 10};

    @Override
    public void paintComponent(Graphics g) {
        AlphaComposite ac;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (this.isDisabled) {
            AlphaComposite ac2 = AlphaComposite.getInstance(3, 0.2f);
            g2.setComposite(ac2);
            g2.setColor(new Color(100, 100, 100));
            g2.fillRect(this.IN, this.IN, this.D - 2 * this.IN, this.D - 2 * this.IN);
            return;
        }
        if (this.isSelected) {
            ac = AlphaComposite.getInstance(3, 0.2f);
            g2.setComposite(ac);
            g2.setColor(new Color(0, 0, 100));
            g2.fillRect(0, 0, this.D, this.D);
        }
        if (this.isEntered) {
            ac = AlphaComposite.getInstance(3, 0.1f);
            g2.setComposite(ac);
            g2.setColor(new Color(0, 0, 80));
            BasicStroke stroke = new BasicStroke(3.0f);
            g2.setStroke(stroke);
            g2.drawRect(2, 2, this.D - 4, this.D - 4);
        }
        g2.setColor(this.CurrentC);
        g2.setComposite(AlphaComposite.Src);
        g2.setStroke(new BasicStroke(this.STRK, 2, 0));
        g2.clearRect(this.IN, this.IN, this.D - 2 * this.IN, this.D - 2 * this.IN);
        ac = AlphaComposite.getInstance(3, 0.4f);
        g2.setComposite(ac);
        g2.fillRect(this.IN, this.IN, this.D - 2 * this.IN, this.D - 2 * this.IN);
        g2.setComposite(AlphaComposite.Src);
        g2.drawRect(this.IN, this.IN, this.D - 2 * this.IN, this.D - 2 * this.IN);
        int sze = 6;
        this.x[0] = this.D - 6;
        this.y[0] = this.D;
        this.x[1] = this.D;
        this.y[1] = this.D - 6;
        this.x[2] = this.D;
        this.y[2] = this.D;
        g2.setComposite(AlphaComposite.SrcOver);
        g2.setColor(new Color(50, 50, 50));
        g2.fillPolygon(this.x, this.y, 3);
    }

    public JColorPicker(int d2, int inset, int stroke, Vector mygroup) {
        this.group = mygroup;
        if (this.group != null) {
            this.group.add(this);
        }
        this.D = d2;
        this.IN = inset;
        this.STRK = stroke;
        this.setLayout(new BoxLayout(this, 0));
        JColorPicker.fixsize(this, d2, d2);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setContentAreaFilled(false);
        this.setFocusable(false);
        this.CC = new ColorChooser(){

            public void paintComponent(Graphics g) {
            }
        };
        this.CC.setBorder(BorderFactory.createEmptyBorder());
        this.CC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Color mc = JColorPicker.this.CC.getColor();
                JColorPicker.this.CurrentC = new Color(mc.getRed(), mc.getGreen(), mc.getBlue());
                JColorPicker.this.doChange();
            }
        });
        this.CC.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e2) {
                Color mc = JColorPicker.this.CC.getTransientColor();
                if (mc != null) {
                    JColorPicker.this.CurrentC = new Color(mc.getRed(), mc.getGreen(), mc.getBlue());
                    JColorPicker.this.doChange();
                }
            }
        });
        this.CC.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                JColorPicker.this.Select();
                JColorPicker.this.afterSelect();
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                JColorPicker.this.setPalettes();
                JColorPicker.this.isEntered = true;
                JColorPicker.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                JColorPicker.this.isEntered = false;
                JColorPicker.this.repaint();
            }
        });
        this.CC.setToolTipText("");
        this.add((Component)this.CC);
    }

    public void setDisabled(boolean b2) {
        this.isDisabled = b2;
        if (b2) {
            this.remove((Component)this.CC);
        } else {
            this.add((Component)this.CC);
        }
    }

    @Override
    public String getName() {
        return "scolor";
    }

    public void setPalettes() {
    }

    public void setUsedColors(Vector V) {
        String[] strs;
        Color[] cols;
        if (V.size() == 0) {
            cols = new Color[1];
            strs = new String[1];
            cols[0] = Color.WHITE;
            strs[0] = "";
        } else {
            cols = new Color[V.size()];
            strs = new String[V.size()];
            for (int i = 0; i < V.size(); ++i) {
                JColors jc = (JColors)V.get(i);
                cols[i] = jc.C;
                strs[i] = jc.S;
            }
        }
        Palette[] pals = this.CC.getPalettes();
        pals[7] = Palette.createPredefinedPalette(null, (Color[])cols, (String[])strs);
        this.CC.setPalettes(pals);
    }

    public Color getCurrentColor() {
        return this.CurrentC;
    }

    public void setDefaultColor() {
        this.CurrentC = DefaultC;
        this.repaint();
    }

    public Color getDefaultColor() {
        return DefaultC;
    }

    public void setCurrentColor(Color c2) {
        if (c2 != null) {
            this.CurrentC = c2;
            this.repaint();
        }
    }

    public void doChange() {
    }

    @Override
    public void setSelected(boolean b2) {
        this.isSelected = b2;
    }

    @Override
    public boolean isSelected() {
        return this.isSelected;
    }

    public final void Select() {
        if (this.group != null) {
            for (int i = 0; i < this.group.size(); ++i) {
                JComponent myicn;
                if (this.group.get(i) instanceof JIcon) {
                    myicn = (JIcon)this.group.get(i);
                    if (!((JIcon)myicn).isSelected()) continue;
                    ((JIcon)myicn).setSelected(false);
                    myicn.repaint();
                    continue;
                }
                myicn = (JButton)this.group.get(i);
                if (!((AbstractButton)myicn).isSelected()) continue;
                ((AbstractButton)myicn).setSelected(false);
                myicn.repaint();
            }
        }
        this.isSelected = true;
        this.isEntered = false;
        this.repaint();
    }

    public void afterSelect() {
    }

    static void fixsize(JComponent cp, int w, int h) {
        Dimension d2 = new Dimension(w, h);
        cp.setMaximumSize(d2);
        cp.setMinimumSize(d2);
        cp.setPreferredSize(d2);
        cp.setSize(d2);
    }

    public static JPanel margin(int w) {
        JPanel mypan = new JPanel();
        JColorPicker.fixsize(mypan, w, 1);
        mypan.setLayout(new BoxLayout(mypan, 0));
        mypan.setAlignmentX(0.0f);
        mypan.setAlignmentY(0.0f);
        mypan.setOpaque(false);
        mypan.setFocusable(false);
        return mypan;
    }
}

