/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.GUI.window;

import carmetal.eric.GUI.pipe_tools;
import carmetal.eric.GUI.themes;
import carmetal.eric.GUI.windowComponent;
import carmetal.rene.gui.Global;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;

public class TitleBar
extends windowComponent {
    private Point origin;
    private Point current;
    private Point winloc;
    private Font TextFont = new Font("System", 0, 13);
    private Color TextColor = Color.DARK_GRAY;
    private String title = Global.Loc("program.name");

    @Override
    public void paintComponent(Graphics g) {
        Dimension d2 = this.getSize();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.drawImage(themes.getImage("titlebar.gif"), 0, 0, d2.width, d2.height, this);
        g2d.setFont(this.TextFont);
        FontRenderContext frc = g2d.getFontRenderContext();
        Rectangle2D bounds = this.TextFont.getStringBounds(this.title, frc);
        LineMetrics metrics = this.TextFont.getLineMetrics(this.title, frc);
        float width = (float)bounds.getWidth();
        float lineheight = metrics.getHeight();
        float ascent = metrics.getAscent();
        g2d.setColor(this.TextColor);
        g2d.drawString(this.title, ((float)(pipe_tools.getWindowSize().width - themes.getTotalRightPanelWidth()) - width) / 2.0f, lineheight + 3.0f);
    }

    public void init() {
        this.setBounds(0, 0, pipe_tools.getWindowSize().width - themes.getTotalRightPanelWidth(), themes.getTitleBarHeight());
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        this.origin = MouseInfo.getPointerInfo().getLocation();
        this.winloc = pipe_tools.getWindowLocation();
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
        this.current = MouseInfo.getPointerInfo().getLocation();
        pipe_tools.setWindowLocation(this.winloc.x + this.current.x - this.origin.x, this.winloc.y + this.current.y - this.origin.y);
    }

    void setTitle(String s) {
        this.title = s;
        this.getParent().repaint();
    }
}

