/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.GUI;

import carmetal.eric.FileTools;
import carmetal.eric.GUI.palette.PaletteManager;
import carmetal.eric.GUI.themes;
import carmetal.eric.GUI.window.ContentPane;
import carmetal.eric.GUI.window.LeftPanel;
import carmetal.eric.GUI.window.LeftPanel_content;
import carmetal.eric.GUI.window.MainContainer;
import carmetal.eric.GUI.window.MainWindow;
import carmetal.eric.GUI.window.tab_main_panel;
import carmetal.eric.JGeneralMenuBar;
import carmetal.eric.JZirkelCanvas;
import carmetal.eric.bar.JPropertiesBar;
import carmetal.eric.macros.CreateMacroDialog;
import carmetal.eric.macros.CreateMacroPanel;
import carmetal.eric.monkey.monkey;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.ZirkelFrame;
import carmetal.rene.zirkel.macro.Macro;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class pipe_tools {
    private static MainContainer owner;
    private static KeyStroke enter_key;
    private static monkey monkey;

    public static void init(MainContainer mc) {
        owner = mc;
        themes.setTheme(Global.getParameter("LookAndFeel", themes.GRAY));
    }

    public static boolean isApplet() {
        return owner.isApplet();
    }

    public static MainContainer getWindow() {
        return owner;
    }

    public static Frame getFrame() {
        MainContainer mc = owner;
        if (mc instanceof MainWindow) {
            return (Frame)((Object)mc);
        }
        return new Frame();
    }

    public static ContentPane getContent() {
        return owner.getContent();
    }

    public static void setWindowComponents() {
        owner.setComponents();
    }

    public static Point getWindowLocation() {
        return owner.getLocation();
    }

    public static void setWindowLocation() {
        pipe_tools.setWindowLocation(pipe_tools.owner.getLocation().x, pipe_tools.owner.getLocation().y);
    }

    public static void setWindowLocation(int x, int y) {
        if (y < Global.getScreenY() + JPropertiesBar.getBarHeight()) {
            y = Global.getScreenY() + JPropertiesBar.getBarHeight();
        }
        owner.setLocation(x, y);
    }

    public static Dimension getWindowSize() {
        return owner.getSize();
    }

    public static void setWindowSize(int w, int h) {
        owner.setSize(w, h);
    }

    public static void setAndCheckWindowSize(int w, int h) {
        if (!pipe_tools.isApplet() && JZirkelCanvas.isWorkBook()) {
            if (w > Global.getScreenW()) {
                w = Global.getScreenW();
            }
            if (h > Global.getScreenH()) {
                h = Global.getScreenH();
            }
            int x = (Global.getScreenW() - w) / 2;
            int y = (Global.getScreenH() - h) / 2;
            pipe_tools.setWindowLocation(x, y);
            owner.setSize(w, h);
        }
    }

    public static void setWindowBounds() {
        pipe_tools.setWindowBounds(pipe_tools.getFrame().getBounds());
    }

    public static void setWindowBounds(Rectangle r) {
        if (pipe_tools.getWindow() instanceof MainWindow) {
            if (r.y < Global.getScreenY() + JPropertiesBar.getBarHeight()) {
                r.y = Global.getScreenY() + JPropertiesBar.getBarHeight();
            }
            if (r.y + r.height > Global.getScreenY() + Global.getScreenH()) {
                r.height = Global.getScreenY() + Global.getScreenH() - r.y;
            }
            pipe_tools.getFrame().setBounds(r);
            owner.setComponents();
            owner.setComponents();
        }
    }

    public static void setStandardKeyInputs() {
        KeyStroke key = KeyStroke.getKeyStroke(10, 64);
        owner.getRootPane().getInputMap(1).put(key, "objectTracker");
        owner.getRootPane().getActionMap().put("objectTracker", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ZirkelFrame zf = JZirkelCanvas.getCurrentZF();
                zf.track();
            }
        });
        key = KeyStroke.getKeyStroke(27, 0);
        owner.getRootPane().getInputMap(1).put(key, "escape");
        owner.getRootPane().getActionMap().put("escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaletteManager.setSelected_with_clic("move", true);
                CreateMacroDialog.quit();
            }
        });
    }

    public static void setMacroPanelKeyInputs() {
        owner.getRootPane().getInputMap(1).put(enter_key, "macro_enter");
        owner.getRootPane().getActionMap().put("macro_enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CreateMacroPanel.nextStep();
            }
        });
    }

    public static void removeMacroPanelKeyInputs() {
        owner.getRootPane().getActionMap().remove(enter_key);
    }

    public static void toFront() {
        if (!pipe_tools.isApplet()) {
            MainWindow mw = (MainWindow)owner;
            mw.toFront();
        }
    }

    public static JPanel getCanvasPanel() {
        return ContentPane.getCanvasPanel();
    }

    public static void duplicateTab() {
        try {
            String s = FileTools.getCurrentFileSource();
            tab_main_panel.addBtnAndSelect(tab_main_panel.getActiveBtn().getTabName() + " copy");
            FileTools.setCurrentFileSource(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void TabHaveChanged(boolean b2) {
        if (JZirkelCanvas.isWorkBook()) {
            tab_main_panel.allTabsHaveChanged(b2);
        } else {
            tab_main_panel.currentTabHaveChanged(b2);
        }
    }

    public static void actualiseMacroPanel() {
        LeftPanel_content.setContent(JZirkelCanvas.getNewMacroPanel());
        JZirkelCanvas.ActualiseMacroPanel();
    }

    public static void actualiseLeftPanels() {
        JZirkelCanvas.removeLeftPanelContent();
        if (LeftPanel.isHistoryPanelVisible()) {
            LeftPanel_content.setContent(JZirkelCanvas.getNewCDPPanel());
        } else if (LeftPanel.isHelpPanelVisible()) {
            LeftPanel_content.setContent(JZirkelCanvas.getNewInfoPanel());
        } else if (LeftPanel.isMacroPanelVisible()) {
            pipe_tools.actualiseMacroPanel();
        }
    }

    public static void setTitle(String s) {
        pipe_tools.getContent().setTitle(s);
    }

    public static JPanel getMenuBar() {
        return new JGeneralMenuBar();
    }

    public static boolean isTabEditAccepted() {
        return JZirkelCanvas.isWorkBook();
    }

    public static void quitAll() {
        pipe_tools.closeCurrent();
        pipe_tools.getFrame().setVisible(false);
        pipe_tools.getFrame().dispose();
    }

    public static void closeCurrent() {
        JZirkelCanvas.closeCurrent();
    }

    public static void onTabActivate() {
        JZirkelCanvas JZF = JZirkelCanvas.getCurrentJZF();
        if (JZF != null) {
            JZF.onTabActivate();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PaletteManager.selectGeomIcon();
                    PaletteManager.fix3Dpalette();
                    PaletteManager.init();
                    pipe_tools.actualiseLeftPanels();
                }
            });
        }
    }

    public static String processTabName(String name) {
        if (name.endsWith(".zir")) {
            name = name.substring(0, name.length() - 4);
        } else if (name.endsWith(".zirz")) {
            name = name.substring(0, name.length() - 5);
        }
        name = tab_main_panel.uniqueName(name);
        return name;
    }

    public static void setMacroHelp(Macro m) {
    }

    public static void setComments(String s) {
        ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
        if (zc != null) {
            zc.setJobComment(s);
        }
    }

    public static boolean isComments() {
        ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
        if (zc == null) {
            return false;
        }
        return !"".equals(zc.getJobComment());
    }

    public static void saveFigure() {
        FileTools.saveFileAs();
    }

    public static void monkeyStart() {
        ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
        if (zc != null) {
            monkey = new monkey(zc);
            monkey.start();
        }
    }

    public static void monkeyStop() {
        if (monkey != null) {
            monkey.stop();
            monkey = null;
        }
    }

    static {
        enter_key = KeyStroke.getKeyStroke(10, 0);
        monkey = null;
    }
}

