/*
 * Decompiled with CFR 0.152.
 */
package carmetal.constructors;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionException;
import carmetal.constructors.ParallelConstructor;
import carmetal.objects.ConstructionObject;
import carmetal.objects.PlumbObject;
import carmetal.objects.PointObject;
import carmetal.objects.PrimitiveLineObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlTag;
import carmetal.rene.util.xml.XmlTree;
import carmetal.rene.zirkel.ZirkelCanvas;

public class PlumbConstructor
extends ParallelConstructor {
    @Override
    public PrimitiveLineObject create(Construction c2, PrimitiveLineObject l, PointObject p) {
        return new PlumbObject(c2, l, p);
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        if (this.L == null) {
            zc.showStatus(Global.name("message.plumb.first", "Plumb Line: Choose a line!"));
        } else {
            zc.showStatus(Global.name("message.plumb.second", "Plumb Line: Choose a Point!"));
        }
    }

    @Override
    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "Plumb")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        if (!tag.hasParam("point") || !tag.hasParam("line")) {
            throw new ConstructionException("Plumb parameters missing!");
        }
        try {
            PointObject p1 = (PointObject)c2.find(tag.getValue("point"));
            PrimitiveLineObject p2 = (PrimitiveLineObject)c2.find(tag.getValue("line"));
            PlumbObject o = new PlumbObject(c2, p2, p1);
            if (tag.hasParam("valid")) {
                o.setRestricted(false);
            }
            this.setName(tag, o);
            this.set(tree, o);
            if (tag.hasParam("partial")) {
                o.setPartial(true);
            }
            c2.add(o);
            this.setConditionals(tree, c2, o);
        }
        catch (ConstructionException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new ConstructionException("Plumb parameters illegal!");
        }
        return true;
    }

    @Override
    public String getPrompt() {
        return Global.name("prompt.plumb");
    }

    @Override
    public String getTag() {
        return "Plumb";
    }

    @Override
    public void construct(Construction c2, String name, String[] params, int nparams) throws ConstructionException {
        if (nparams != 2) {
            throw new ConstructionException(Global.name("exception.nparams"));
        }
        ConstructionObject P1 = c2.find(params[0]);
        if (P1 == null) {
            throw new ConstructionException(Global.name("exception.notfound") + " " + params[0]);
        }
        ConstructionObject P2 = c2.find(params[1]);
        if (P2 == null) {
            throw new ConstructionException(Global.name("exception.notfound") + " " + params[1]);
        }
        if (!(P1 instanceof PrimitiveLineObject)) {
            throw new ConstructionException(Global.name("exception.type") + " " + params[0]);
        }
        if (!(P2 instanceof PointObject)) {
            throw new ConstructionException(Global.name("exception.type") + " " + params[1]);
        }
        PlumbObject s = new PlumbObject(c2, (PrimitiveLineObject)P1, (PointObject)P2);
        if (!name.equals("")) {
            s.setNameCheck(name);
        }
        c2.add(s);
        s.setDefaults();
    }
}

