/*
 * Decompiled with CFR 0.152.
 */
package carmetal.constructors;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionException;
import carmetal.constructors.ObjectConstructor;
import carmetal.objects.ExpressionObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlTag;
import carmetal.rene.util.xml.XmlTree;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.expression.Expression;
import java.awt.event.MouseEvent;

public class ExpressionConstructor
extends ObjectConstructor {
    ExpressionObject O;

    @Override
    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        double x = zc.x(e2.getX());
        double y = zc.y(e2.getY());
        ExpressionObject o = new ExpressionObject(zc.getConstruction(), x, y);
        zc.addObject(o);
        o.setShowName(false);
        o.setDefaults();
        zc.repaint();
        this.Dragging = true;
        this.O = o;
    }

    @Override
    public void mouseDragged(MouseEvent e2, ZirkelCanvas zc) {
        if (!this.Dragging) {
            return;
        }
        this.O.move(zc.x(e2.getX()), zc.y(e2.getY()));
        zc.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e2, ZirkelCanvas zc) {
        if (!this.Dragging) {
            return;
        }
        this.Dragging = false;
        this.O.edit(zc, true, true);
    }

    @Override
    public boolean waitForPoint() {
        return false;
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        zc.showStatus(Global.name("message.expression", "Expression: Choose a place!"));
    }

    @Override
    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "Expression")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        if (!tag.hasParam("x") || !tag.hasParam("y")) {
            throw new ConstructionException("Expression coordinates missing!");
        }
        if (!tag.hasParam("value")) {
            throw new ConstructionException(Global.name("exception.expression"));
        }
        ExpressionObject p = new ExpressionObject(c2, 0.0, 0.0);
        try {
            double x = new Expression(tag.getValue("x"), c2, p).getValue();
            double y = new Expression(tag.getValue("y"), c2, p).getValue();
            p.move(x, y);
        }
        catch (Exception exception) {
            // empty catch block
        }
        p.setDefaults();
        if (tag.hasParam("prompt")) {
            p.setPrompt(tag.getValue("prompt"));
        }
        if (tag.hasParam("fixed")) {
            p.setFixed(tag.getValue("x"), tag.getValue("y"));
        }
        p.setShowValue(tag.hasParam("showvalue"));
        this.setName(tag, p);
        this.set(tree, p);
        c2.add(p);
        try {
            p.setExpression(tag.getValue("value"), c2);
        }
        catch (Exception e2) {
            throw new ConstructionException(Global.name("exception.expression"));
        }
        this.setConditionals(tree, c2, p);
        if (tag.hasTrueParam("slider")) {
            try {
                p.setSlider(tag.getValue("min"), tag.getValue("max"));
            }
            catch (Exception e3) {
                throw new ConstructionException(Global.name("exception.expression"));
            }
        }
        return true;
    }

    @Override
    public String getTag() {
        return "Expression";
    }

    @Override
    public void construct(Construction c2, String name, String[] params, int nparams) throws ConstructionException {
        if (nparams == 1) {
            ExpressionObject o = new ExpressionObject(c2, c2.getX() + (Math.random() - 0.5) * c2.getW(), c2.getY() + (Math.random() - 0.5) * c2.getW());
            if (!name.equals("")) {
                o.setNameCheck(name);
            }
            c2.add(o);
            o.setDefaults();
            try {
                o.setExpression(params[0], c2);
            }
            catch (Exception e2) {
                throw new ConstructionException(Global.name("exception.expression"));
            }
        } else {
            throw new ConstructionException(Global.name("exception.nparams"));
        }
    }

    @Override
    public boolean useSmartBoard() {
        return false;
    }
}

