/*
 * Decompiled with CFR 0.152.
 */
package carmetal;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class MenuElementExample
extends JPanel {
    public JPopupMenu popup = new JPopupMenu();
    SliderMenuItem slider = new SliderMenuItem();
    int theValue = 0;

    public MenuElementExample() {
        this.popup.add(this.slider);
        this.popup.add(new JSeparator());
        JCheckBoxMenuItem ticks = new JCheckBoxMenuItem("Slider Tick Marks");
        ticks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MenuElementExample.this.slider.setPaintTicks(!MenuElementExample.this.slider.getPaintTicks());
            }
        });
        JCheckBoxMenuItem labels = new JCheckBoxMenuItem("Slider Labels");
        labels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MenuElementExample.this.slider.setPaintLabels(!MenuElementExample.this.slider.getPaintLabels());
            }
        });
        this.popup.add(ticks);
        this.popup.add(labels);
        this.popup.addPopupMenuListener(new PopupPrintListener());
        this.addMouseListener(new MousePopupListener());
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("Menu Element Example");
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(new MenuElementExample());
        frame.setSize(300, 300);
        frame.setVisible(true);
    }

    class SliderMenuItem
    extends JSlider
    implements ChangeListener {
        public SliderMenuItem() {
            this.setBorder(new CompoundBorder(new TitledBorder("Control"), new EmptyBorder(2, 2, 2, 2)));
            this.setMajorTickSpacing(20);
            this.setMinorTickSpacing(10);
            this.setFocusable(false);
            this.addChangeListener(this);
            this.putClientProperty("JComponent.sizeVariant", "small");
        }

        public void processMouseEvent(MouseEvent e2, MenuElement[] path, MenuSelectionManager manager) {
        }

        public void processKeyEvent(KeyEvent e2, MenuElement[] path, MenuSelectionManager manager) {
        }

        public void menuSelectionChanged(boolean isIncluded) {
        }

        public MenuElement[] getSubElements() {
            return new MenuElement[0];
        }

        public Component getComponent() {
            return this;
        }

        @Override
        public void stateChanged(ChangeEvent e2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    class PopupPrintListener
    implements PopupMenuListener {
        PopupPrintListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
            MenuElementExample.this.theValue = MenuElementExample.this.slider.getValue();
            System.out.println("The value is now " + MenuElementExample.this.theValue);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e2) {
            System.out.println("Popup menu is hidden!");
        }
    }

    class MousePopupListener
    extends MouseAdapter {
        MousePopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            this.checkPopup(e2);
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            this.checkPopup(e2);
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            this.checkPopup(e2);
        }

        private void checkPopup(MouseEvent e2) {
            if (e2.isPopupTrigger()) {
                MenuElementExample.this.popup.show(MenuElementExample.this, e2.getX(), e2.getY());
            }
        }
    }
}

