/*
 * Decompiled with CFR 0.152.
 */
package recunn.loss;

import recunn.loss.Loss;
import recunn.matrix.Matrix;

public class LossSumOfSquares
implements Loss {
    private static final long serialVersionUID = 1L;

    @Override
    public void backward(Matrix actualOutput, Matrix targetOutput) throws Exception {
        int i = 0;
        while (i < targetOutput.w.length) {
            double errDelta = actualOutput.w[i] - targetOutput.w[i];
            int n = i++;
            actualOutput.dw[n] = actualOutput.dw[n] + errDelta;
        }
    }

    @Override
    public double measure(Matrix actualOutput, Matrix targetOutput) throws Exception {
        double sum = 0.0;
        for (int i = 0; i < targetOutput.w.length; ++i) {
            double errDelta = actualOutput.w[i] - targetOutput.w[i];
            sum += 0.5 * errDelta * errDelta;
        }
        return sum;
    }
}

