/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stochprocess;

import umontreal.iro.lecuyer.randvar.InverseGaussianMSHGen;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stochprocess.InverseGaussianProcessMSH;

public class InverseGaussianProcessBridge
extends InverseGaussianProcessMSH {
    protected double[] imu2;
    protected double[] imuLambdaZ;
    protected double[] imuOver2LambdaZ;
    protected int[] wIndexList;
    protected int bridgeCounter = -1;

    public InverseGaussianProcessBridge(double s0, double delta, double gamma, RandomStream stream, RandomStream otherStream) {
        super(s0, delta, gamma, stream, otherStream);
        this.numberOfRandomStreams = 2;
    }

    @Override
    public double[] generatePath() {
        this.bridgeCounter = -1;
        this.observationIndex = 0;
        this.path[0] = this.x0;
        for (int j = 0; j < this.d; ++j) {
            this.nextObservation();
        }
        return this.path;
    }

    @Override
    public double[] generatePath(double[] unifNorm, double[] unifOther) {
        double s = this.x0;
        RandomStream cacheStreamNormal = this.stream;
        RandomStream cacheStreamOther = this.otherStream;
        this.stream = new InverseGaussianProcessMSH.NonRandomStream((InverseGaussianProcessMSH)this, unifNorm);
        this.normalGen.setStream(this.stream);
        this.otherStream = new InverseGaussianProcessMSH.NonRandomStream((InverseGaussianProcessMSH)this, unifOther);
        this.bridgeCounter = -1;
        this.observationIndex = 0;
        this.path[0] = this.x0;
        for (int j = 0; j < this.d; ++j) {
            this.nextObservation();
        }
        this.stream = cacheStreamNormal;
        this.normalGen.setStream(this.stream);
        this.otherStream = cacheStreamOther;
        return this.path;
    }

    @Override
    public double nextObservation() {
        double s;
        if (this.bridgeCounter == -1) {
            double temp = this.delta * (this.t[this.d] - this.t[0]);
            s = this.x0 + InverseGaussianMSHGen.nextDouble(this.otherStream, this.normalGen, temp / this.gamma, temp * temp);
            this.bridgeCounter = 0;
            this.observationIndex = this.d;
        } else {
            int j = this.bridgeCounter * 3;
            int oldIndexL = this.wIndexList[j];
            int newIndex = this.wIndexList[j + 1];
            int oldIndexR = this.wIndexList[j + 2];
            double q = this.normalGen.nextDouble();
            q *= q;
            double z = this.path[oldIndexR];
            double mu = this.imu[newIndex];
            double muLambda = this.imuLambdaZ[newIndex] / z;
            double mu2 = this.imu2[newIndex];
            double muOver2Lambda = this.imuOver2LambdaZ[newIndex] * z;
            double root = mu + muOver2Lambda * mu * q - muOver2Lambda * Math.sqrt(4.0 * muLambda * q + mu2 * q * q);
            double probabilityRoot1 = mu * (1.0 + root) / (1.0 + mu) / (root + mu);
            if (this.otherStream.nextDouble() > probabilityRoot1) {
                root = mu2 / root;
            }
            s = this.path[oldIndexL] + (this.path[oldIndexR] - this.path[oldIndexL]) / (1.0 + root);
            ++this.bridgeCounter;
            this.observationIndex = newIndex;
        }
        this.observationCounter = this.bridgeCounter + 1;
        this.path[this.observationIndex] = s;
        return s;
    }

    @Override
    public void resetStartProcess() {
        this.observationIndex = 0;
        this.observationCounter = 0;
        this.bridgeCounter = -1;
    }

    @Override
    protected void init() {
        super.init();
        if (this.observationTimesSet) {
            double lambdaZ;
            double mu;
            double tauY;
            double tauX;
            this.wIndexList = new int[3 * this.d];
            int[] ptIndex = new int[this.d + 1];
            int indexCounter = 0;
            ptIndex[0] = 0;
            ptIndex[1] = this.d;
            this.imu = new double[this.d + 1];
            this.ilam = new double[this.d + 1];
            this.imu2 = new double[this.d + 1];
            this.imuLambdaZ = new double[this.d + 1];
            this.imuOver2LambdaZ = new double[this.d + 1];
            for (int powOfTwo = 1; powOfTwo <= this.d / 2; powOfTwo *= 2) {
                int j;
                for (j = powOfTwo; j >= 1; --j) {
                    ptIndex[2 * j] = ptIndex[j];
                }
                for (j = 1; j <= powOfTwo; ++j) {
                    int oldIndexL = 2 * j - 2;
                    int oldIndexR = 2 * j;
                    int newIndex = (int)(0.5 * (double)(ptIndex[oldIndexL] + ptIndex[oldIndexR]));
                    tauX = this.t[newIndex] - this.t[ptIndex[oldIndexL]];
                    tauY = this.t[ptIndex[oldIndexR]] - this.t[newIndex];
                    mu = tauY / tauX;
                    lambdaZ = this.delta * this.delta * tauY * tauY;
                    this.imu[newIndex] = mu;
                    this.ilam[newIndex] = lambdaZ;
                    this.imu2[newIndex] = mu * mu;
                    this.imuLambdaZ[newIndex] = mu * lambdaZ;
                    this.imuOver2LambdaZ[newIndex] = mu / 2.0 / lambdaZ;
                    ptIndex[oldIndexL + 1] = newIndex;
                    this.wIndexList[indexCounter] = ptIndex[oldIndexL];
                    this.wIndexList[indexCounter + 1] = newIndex;
                    this.wIndexList[indexCounter + 2] = ptIndex[oldIndexR];
                    indexCounter += 3;
                }
            }
            for (int k = 1; k < this.d; ++k) {
                if (ptIndex[k - 1] + 1 >= ptIndex[k]) continue;
                tauX = this.t[ptIndex[k - 1] + 1] - this.t[ptIndex[k - 1]];
                tauY = this.t[ptIndex[k]] - this.t[ptIndex[k - 1] + 1];
                mu = tauY / tauX;
                lambdaZ = this.delta * this.delta * tauY * tauY;
                this.imu[ptIndex[k - 1] + 1] = mu;
                this.ilam[ptIndex[k - 1] + 1] = lambdaZ;
                this.imu2[ptIndex[k - 1] + 1] = mu * mu;
                this.imuLambdaZ[ptIndex[k - 1] + 1] = mu * lambdaZ;
                this.imuOver2LambdaZ[ptIndex[k - 1] + 1] = mu / 2.0 / lambdaZ;
                this.wIndexList[indexCounter] = ptIndex[k] - 2;
                this.wIndexList[indexCounter + 1] = ptIndex[k] - 1;
                this.wIndexList[indexCounter + 2] = ptIndex[k];
                indexCounter += 3;
            }
        }
    }

    @Override
    public RandomStream getStream() {
        if (this.stream != this.otherStream) {
            throw new IllegalStateException("Two different streams or more are present");
        }
        return this.stream;
    }

    @Override
    public void setStream(RandomStream stream, RandomStream otherStream) {
        this.stream = stream;
        this.otherStream = otherStream;
        this.normalGen.setStream(stream);
    }

    @Override
    public void setStream(RandomStream stream) {
        this.setStream(stream, stream);
    }
}

