/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simevents;

import umontreal.iro.lecuyer.simevents.Simulator;

public abstract class Event
implements Comparable<Event> {
    protected Simulator sim;
    protected double priority;
    protected double eventTime;
    private int myra = 0;

    public final int getRa() {
        return this.myra;
    }

    public final void setRa(int r) {
        this.myra = r;
    }

    public Event() {
        this(Simulator.getDefaultSimulator());
    }

    public Event(Simulator sim) {
        if (sim == null) {
            throw new NullPointerException();
        }
        this.eventTime = -10.0;
        this.priority = 1.0;
        this.sim = sim;
    }

    public void schedule(double delay) {
        if (delay < 0.0) {
            throw new IllegalArgumentException("Cannot schedule in the past.");
        }
        if (this.eventTime > -1.0) {
            throw new IllegalStateException("Event already scheduled");
        }
        this.eventTime = this.sim.time() + delay;
        this.sim.eventList.add(this);
    }

    public void scheduleNext() {
        if (this.eventTime > -1.0) {
            throw new IllegalStateException("Event already scheduled");
        }
        this.eventTime = this.sim.time();
        this.priority = 0.0;
        this.sim.eventList.addFirst(this);
    }

    public void scheduleBefore(Event other) {
        if (this.eventTime > -1.0) {
            throw new IllegalStateException("Event already scheduled");
        }
        this.eventTime = other.eventTime;
        this.priority = other.priority;
        this.sim.eventList.addBefore(this, other);
    }

    public void scheduleAfter(Event other) {
        if (this.eventTime > -1.0) {
            throw new IllegalStateException("Event already scheduled");
        }
        this.eventTime = other.eventTime;
        this.priority = other.priority;
        this.sim.eventList.addAfter(this, other);
    }

    public void reschedule(double delay) {
        if (delay < 0.0) {
            throw new IllegalArgumentException("Cannot schedule in the past.");
        }
        if (this.eventTime < -1.0) {
            throw new IllegalStateException("Event not scheduled");
        }
        this.sim.getEventList().remove(this);
        this.eventTime = this.sim.time() + delay;
        this.sim.getEventList().add(this);
    }

    public boolean cancel() {
        boolean removed = false;
        if (this.eventTime >= this.sim.time()) {
            removed = this.sim.getEventList().remove(this);
        }
        this.eventTime = -10.0;
        return removed;
    }

    public final boolean cancel(String type) {
        Event ev = this.sim.getEventList().getFirstOfClass(type);
        return ev.cancel();
    }

    public final Simulator simulator() {
        return this.sim;
    }

    public final void setSimulator(Simulator sim) {
        if (sim == null) {
            throw new NullPointerException();
        }
        if (this.eventTime > -1.0) {
            throw new UnsupportedOperationException("Unable to set Simulator, current Event already scheduled");
        }
        this.sim = sim;
    }

    public final double time() {
        return this.eventTime;
    }

    public final void setTime(double time) {
        if (this.eventTime > -1.0) {
            throw new UnsupportedOperationException("Unable to set time, current Event already scheduled");
        }
        this.eventTime = time;
    }

    public final double priority() {
        return this.priority;
    }

    public final void setPriority(double priority) {
        if (this.eventTime > -1.0) {
            throw new UnsupportedOperationException("Unable to set priority, current Event already scheduled");
        }
        this.priority = priority;
    }

    @Override
    public int compareTo(Event e) {
        if (this.eventTime < e.time()) {
            return -1;
        }
        if (this.eventTime > e.time()) {
            return 1;
        }
        if (this.priority < e.priority()) {
            return -1;
        }
        if (this.priority > e.priority()) {
            return 1;
        }
        return 0;
    }

    public abstract void actions();
}

