/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.Pearson5Dist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class Pearson5Gen
extends RandomVariateGen {
    protected double alpha;
    protected double beta;

    public Pearson5Gen(RandomStream s, double alpha, double beta) {
        super(s, new Pearson5Dist(alpha, beta));
        this.setParams(alpha, beta);
    }

    public Pearson5Gen(RandomStream s, double alpha) {
        this(s, alpha, 1.0);
    }

    public Pearson5Gen(RandomStream s, Pearson5Dist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getAlpha(), dist.getBeta());
        }
    }

    public static double nextDouble(RandomStream s, double alpha, double beta) {
        return Pearson5Dist.inverseF(alpha, beta, s.nextDouble());
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    protected void setParams(double alpha, double beta) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        this.alpha = alpha;
        this.beta = beta;
    }
}

