/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.EmpiricalDist;
import umontreal.iro.lecuyer.randvar.KernelDensityGen;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class KernelDensityVarCorrectGen
extends KernelDensityGen {
    protected double sigmak2;
    protected double mean;
    protected double invSigmae;

    public KernelDensityVarCorrectGen(RandomStream s, EmpiricalDist dist, RandomVariateGen kGen, double h, double sigmak2) {
        super(s, dist, kGen, h);
        this.sigmak2 = sigmak2;
        this.mean = dist.getSampleMean();
        double var = dist.getSampleVariance();
        this.invSigmae = 1.0 / Math.sqrt(1.0 + h * h * sigmak2 / var);
    }

    public KernelDensityVarCorrectGen(RandomStream s, EmpiricalDist dist, NormalGen kGen) {
        this(s, dist, kGen, 0.77639 * KernelDensityVarCorrectGen.getBaseBandwidth(dist), 1.0);
    }

    @Override
    public void setBandwidth(double h) {
        if (h < 0.0) {
            throw new IllegalArgumentException("h < 0");
        }
        this.bandwidth = h;
        double var = ((EmpiricalDist)this.dist).getSampleVariance();
        this.invSigmae = 1.0 / Math.sqrt(1.0 + h * h * this.sigmak2 / var);
    }

    @Override
    public double nextDouble() {
        double x = this.mean + this.invSigmae * (this.dist.inverseF(this.stream.nextDouble()) - this.mean + this.bandwidth * this.kernelGen.nextDouble());
        if (this.positive) {
            return Math.abs(x);
        }
        return x;
    }
}

