/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.NormalDist;

public class LognormalDist
extends ContinuousDistribution {
    private double mu;
    private double sigma;

    public LognormalDist() {
        this.setParams(0.0, 1.0);
    }

    public LognormalDist(double mu, double sigma) {
        this.setParams(mu, sigma);
    }

    @Override
    public double density(double x) {
        return LognormalDist.density(this.mu, this.sigma, x);
    }

    @Override
    public double cdf(double x) {
        return LognormalDist.cdf(this.mu, this.sigma, x);
    }

    @Override
    public double barF(double x) {
        return LognormalDist.barF(this.mu, this.sigma, x);
    }

    @Override
    public double inverseF(double u) {
        return LognormalDist.inverseF(this.mu, this.sigma, u);
    }

    @Override
    public double getMean() {
        return LognormalDist.getMean(this.mu, this.sigma);
    }

    @Override
    public double getVariance() {
        return LognormalDist.getVariance(this.mu, this.sigma);
    }

    @Override
    public double getStandardDeviation() {
        return LognormalDist.getStandardDeviation(this.mu, this.sigma);
    }

    public static double density(double mu, double sigma, double x) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        double diff = Math.log(x) - mu;
        return Math.exp(-diff * diff / (2.0 * sigma * sigma)) / (Math.sqrt(Math.PI * 2) * sigma * x);
    }

    public static double cdf(double mu, double sigma, double x) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma  <= 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        return NormalDist.cdf01((Math.log(x) - mu) / sigma);
    }

    public static double barF(double mu, double sigma, double x) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma  <= 0");
        }
        if (x <= 0.0) {
            return 1.0;
        }
        return NormalDist.barF01((Math.log(x) - mu) / sigma);
    }

    public static double inverseF(double mu, double sigma, double u) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma  <= 0");
        }
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (2.220446049250313E-16 >= 1.0 - u) {
            return Double.POSITIVE_INFINITY;
        }
        if (u <= 0.0) {
            return 0.0;
        }
        double t = NormalDist.inverseF01(u);
        double v = mu + sigma * t;
        if (t >= 100.0 || v >= 709.782712893384) {
            return Double.POSITIVE_INFINITY;
        }
        if (t <= -100.0 || v <= -709.782712893384) {
            return 0.0;
        }
        return Math.exp(v);
    }

    public static double[] getMLE(double[] x, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double LN_EPS = -709.089565712824;
        double[] parameters = new double[2];
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            if (x[i] > 0.0) {
                sum += Math.log(x[i]);
                continue;
            }
            sum += -709.089565712824;
        }
        parameters[0] = sum / (double)n;
        sum = 0.0;
        for (int i = 0; i < n; ++i) {
            double temp = x[i] > 0.0 ? Math.log(x[i]) - parameters[0] : -709.089565712824 - parameters[0];
            sum += temp * temp;
        }
        parameters[1] = Math.sqrt(sum / (double)n);
        return parameters;
    }

    public static LognormalDist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = LognormalDist.getMLE(x, n);
        return new LognormalDist(parameters[0], parameters[1]);
    }

    public static double getMean(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        return Math.exp(mu + sigma * sigma / 2.0);
    }

    public static double getVariance(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        return Math.exp(2.0 * mu + sigma * sigma) * (Math.exp(sigma * sigma) - 1.0);
    }

    public static double getStandardDeviation(double mu, double sigma) {
        return Math.sqrt(LognormalDist.getVariance(mu, sigma));
    }

    public double getMu() {
        return this.mu;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setParams(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        this.mu = mu;
        this.sigma = sigma;
        this.supportA = 0.0;
    }

    @Override
    public double[] getParams() {
        double[] retour = new double[]{this.mu, this.sigma};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : mu = " + this.mu + ", sigma = " + this.sigma;
    }
}

