/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import optimization.Lmder_fcn;
import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.util.Num;
import umontreal.iro.lecuyer.util.RootFinder;

public class FrechetDist
extends ContinuousDistribution {
    private double delta;
    private double beta;
    private double alpha;

    public FrechetDist(double alpha) {
        this.setParams(alpha, 1.0, 0.0);
    }

    public FrechetDist(double alpha, double beta, double delta) {
        this.setParams(alpha, beta, delta);
    }

    @Override
    public double density(double x) {
        return FrechetDist.density(this.alpha, this.beta, this.delta, x);
    }

    @Override
    public double cdf(double x) {
        return FrechetDist.cdf(this.alpha, this.beta, this.delta, x);
    }

    @Override
    public double barF(double x) {
        return FrechetDist.barF(this.alpha, this.beta, this.delta, x);
    }

    @Override
    public double inverseF(double u) {
        return FrechetDist.inverseF(this.alpha, this.beta, this.delta, u);
    }

    @Override
    public double getMean() {
        return FrechetDist.getMean(this.alpha, this.beta, this.delta);
    }

    @Override
    public double getVariance() {
        return FrechetDist.getVariance(this.alpha, this.beta, this.delta);
    }

    @Override
    public double getStandardDeviation() {
        return FrechetDist.getStandardDeviation(this.alpha, this.beta, this.delta);
    }

    public static double density(double alpha, double beta, double delta, double x) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        double z = (x - delta) / beta;
        if (z <= 0.0) {
            return 0.0;
        }
        double t = Math.pow(z, -alpha);
        return alpha * t * Math.exp(-t) / (z * beta);
    }

    public static double cdf(double alpha, double beta, double delta, double x) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        double z = (x - delta) / beta;
        if (z <= 0.0) {
            return 0.0;
        }
        double t = Math.pow(z, -alpha);
        return Math.exp(-t);
    }

    public static double barF(double alpha, double beta, double delta, double x) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        double z = (x - delta) / beta;
        if (z <= 0.0) {
            return 1.0;
        }
        double t = Math.pow(z, -alpha);
        return -Math.expm1(-t);
    }

    public static double inverseF(double alpha, double beta, double delta, double u) {
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u <= 0.0) {
            return delta;
        }
        double t = Math.pow(-Math.log(u), 1.0 / alpha);
        if (t <= Double.MIN_NORMAL) {
            return Double.MAX_VALUE;
        }
        return delta + beta / t;
    }

    public static double[] getMLE(double[] x, int n, double delta) {
        if (n <= 1) {
            throw new IllegalArgumentException("n <= 1");
        }
        Function func = new Function(x, n, delta);
        double a = 1.0E-4;
        double b = 1.0E12;
        double alpha = RootFinder.brentDekker(a, b, func, 1.0E-12);
        double[] par = new double[]{alpha, func.dif * Math.pow(func.sumxi, -1.0 / alpha)};
        return par;
    }

    public static FrechetDist getInstanceFromMLE(double[] x, int n, double delta) {
        double[] par = FrechetDist.getMLE(x, n, delta);
        return new FrechetDist(par[0], par[1], delta);
    }

    public static double getMean(double alpha, double beta, double delta) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (alpha <= 1.0) {
            throw new IllegalArgumentException("alpha <= 1");
        }
        double t = Num.lnGamma(1.0 - 1.0 / alpha);
        return delta + beta * Math.exp(t);
    }

    public static double getVariance(double alpha, double beta, double delta) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (alpha <= 2.0) {
            throw new IllegalArgumentException("alpha <= 2");
        }
        double t = Num.lnGamma(1.0 - 1.0 / alpha);
        double mu = Math.exp(t);
        double v = Math.exp(Num.lnGamma(1.0 - 2.0 / alpha));
        return beta * beta * (v - mu * mu);
    }

    public static double getStandardDeviation(double alpha, double beta, double delta) {
        return Math.sqrt(FrechetDist.getVariance(alpha, beta, delta));
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getDelta() {
        return this.delta;
    }

    public void setParams(double alpha, double beta, double delta) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        this.delta = delta;
        this.beta = beta;
        this.alpha = alpha;
    }

    @Override
    public double[] getParams() {
        double[] retour = new double[]{this.alpha, this.beta, this.delta};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : alpha = " + this.alpha + ", beta = " + this.beta + ", delta = " + this.delta;
    }

    private static class Function
    implements MathFunction {
        private int n;
        private double[] x;
        private double delta;
        public double sumxi;
        public double dif;

        public Function(double[] y, int n, double delta) {
            this.n = n;
            this.x = y;
            this.delta = delta;
            double xmin = Double.MAX_VALUE;
            for (int i = 0; i < n; ++i) {
                if (!(y[i] < xmin) || !(y[i] > delta)) continue;
                xmin = y[i];
            }
            this.dif = xmin - delta;
        }

        @Override
        public double evaluate(double alpha) {
            if (alpha <= 0.0) {
                return 1.0E100;
            }
            double sum1 = 0.0;
            double sum2 = 0.0;
            double sum3 = 0.0;
            for (int i = 0; i < this.n; ++i) {
                if (this.x[i] <= this.delta) continue;
                double v = Math.log(this.x[i] - this.delta);
                double w = Math.pow(this.dif / (this.x[i] - this.delta), alpha);
                sum1 += v;
                sum2 += w;
                sum3 += v * w;
            }
            this.sumxi = sum2 / (double)this.n;
            return 1.0 / alpha + sum3 / sum2 - (sum1 /= (double)this.n);
        }
    }

    private static class Optim
    implements Lmder_fcn {
        protected double[] x;
        protected int n;

        public Optim(double[] x, int n) {
            this.n = n;
            this.x = x;
        }

        public void fcn(int m, int n, double[] par, double[] fvec, double[][] fjac, int[] iflag) {
            if (par[1] <= 0.0 || par[2] <= 0.0) {
                double BIG = 1.0E100;
                fvec[1] = 1.0E100;
                fvec[2] = 1.0E100;
                fvec[3] = 1.0E100;
                return;
            }
            double alpha = par[1];
            double beta = par[2];
            double mu = par[3];
            if (iflag[1] == 1) {
                double sum5 = 0.0;
                double sum4 = 0.0;
                double sumb = 0.0;
                double sum2 = 0.0;
                double sum1 = 0.0;
                for (int i = 0; i < n; ++i) {
                    double z = (this.x[i] - mu) / beta;
                    sum1 += 1.0 / z;
                    double v = Math.pow(z, -alpha);
                    sum2 += v / z;
                    sumb += v;
                    double w = Math.log(z);
                    sum4 += w;
                    sum5 += v * w;
                }
                fvec[2] = sumb - (double)n;
                fvec[3] = (alpha + 1.0) * sum1 - alpha * sum2;
                fvec[1] = (double)n / alpha + sum5 - sum4;
            } else if (iflag[1] == 2) {
                throw new IllegalArgumentException("iflag = 2");
            }
        }
    }
}

