/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;

public class BernoulliDist
extends DiscreteDistributionInt {
    private double p;
    private double q;

    public BernoulliDist(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in [0,1]");
        }
        this.p = p;
        this.q = 1.0 - p;
        this.supportA = 0;
        this.supportB = 1;
    }

    @Override
    public double prob(int x) {
        if (1 == x) {
            return this.p;
        }
        if (0 == x) {
            return this.q;
        }
        return 0.0;
    }

    @Override
    public double cdf(int x) {
        if (x < 0) {
            return 0.0;
        }
        if (x < 1) {
            return this.q;
        }
        return 1.0;
    }

    @Override
    public double barF(int x) {
        if (x > 1) {
            return 0.0;
        }
        if (x > 0) {
            return this.p;
        }
        return 1.0;
    }

    @Override
    public int inverseFInt(double u) {
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u > this.q) {
            return 1;
        }
        return 0;
    }

    @Override
    public double getMean() {
        return BernoulliDist.getMean(this.p);
    }

    @Override
    public double getVariance() {
        return BernoulliDist.getVariance(this.p);
    }

    @Override
    public double getStandardDeviation() {
        return BernoulliDist.getStandardDeviation(this.p);
    }

    public static double prob(double p, int x) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in [0,1]");
        }
        if (1 == x) {
            return p;
        }
        if (0 == x) {
            return 1.0 - p;
        }
        return 0.0;
    }

    public static double cdf(double p, int x) {
        if (p < 0.0 | p > 1.0) {
            throw new IllegalArgumentException("p not in [0,1]");
        }
        if (x < 0) {
            return 0.0;
        }
        if (x < 1) {
            return 1.0 - p;
        }
        return 1.0;
    }

    public static double barF(double p, int x) {
        if (p < 0.0 | p > 1.0) {
            throw new IllegalArgumentException("p not in [0,1]");
        }
        if (x > 1) {
            return 0.0;
        }
        if (x > 0) {
            return p;
        }
        return 1.0;
    }

    public static int inverseF(double p, double u) {
        if (p < 0.0 | p > 1.0) {
            throw new IllegalArgumentException("p not in [0,1]");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u > 1.0 - p) {
            return 1;
        }
        return 0;
    }

    public static double[] getMLE(int[] x, int m) {
        if (m < 2) {
            throw new UnsupportedOperationException(" m < 2");
        }
        double sum = 0.0;
        for (int i = 0; i < m; ++i) {
            sum += (double)x[i];
        }
        double[] param = new double[]{sum /= (double)m};
        return param;
    }

    public static BernoulliDist getInstanceFromMLE(int[] x, int m) {
        double[] param = new double[1];
        param = BernoulliDist.getMLE(x, m);
        return new BernoulliDist(param[0]);
    }

    public static double getMean(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        return p;
    }

    public static double getVariance(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        return p * (1.0 - p);
    }

    public static double getStandardDeviation(double p) {
        return Math.sqrt(BernoulliDist.getVariance(p));
    }

    public double getP() {
        return this.p;
    }

    @Override
    public double[] getParams() {
        double[] retour = new double[]{this.p};
        return retour;
    }

    public void setParams(double p) {
        this.p = p;
        this.q = 1.0 - p;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : p = " + this.p;
    }
}

