/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.charts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.statistics.HistogramBin;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class CustomHistogramDataset
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
Cloneable,
PublicCloneable {
    private List list = new ArrayList();
    public HistogramType type = HistogramType.FREQUENCY;

    public HistogramType getType() {
        return this.type;
    }

    public void setType(HistogramType type) {
        if (type == null) {
            throw new IllegalArgumentException("Null 'type' argument");
        }
        this.type = type;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public void addSeries(Comparable key, double[] values, int bins) {
        double minimum = this.getMinimum(values);
        double maximum = this.getMaximum(values);
        this.addSeries(key, values, bins, minimum, maximum);
    }

    public void addSeries(Comparable key, double[] values, int numPoints, int bins) {
        double minimum = this.getMinimum(values);
        double maximum = this.getMaximum(values);
        this.addSeries(key, values, numPoints, bins, minimum, maximum);
    }

    public void addSeries(Comparable key, double[] values, int bins, double minimum, double maximum) {
        this.addSeries(key, values, values.length, bins, minimum, maximum);
    }

    public void addSeries(Comparable key, double[] values, int numPoints, int bins, double minimum, double maximum) {
        if (key == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        if (values == null) {
            throw new IllegalArgumentException("Null 'values' argument.");
        }
        if (bins < 1) {
            throw new IllegalArgumentException("The 'bins' value must be at least 1.");
        }
        double binWidth = (maximum - minimum) / (double)bins;
        double lower = minimum;
        double EPS = 1.0E-15;
        ArrayList<HistogramBin> binList = new ArrayList<HistogramBin>(bins);
        for (int i = 0; i < bins; ++i) {
            HistogramBin bin;
            if (i == bins - 1) {
                bin = new HistogramBin(lower, maximum * 1.000000000000001);
            } else {
                double upper = minimum + (double)(i + 1) * binWidth;
                bin = new HistogramBin(lower, upper);
                lower = upper;
            }
            binList.add(bin);
        }
        ArrayList<Double> valuesList = new ArrayList<Double>(numPoints);
        for (int i = 0; i < numPoints; ++i) {
            valuesList.add(new Double(values[i]));
        }
        this.synchronizeValuesAndBins(binList, valuesList);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", key);
        map.put("values", valuesList);
        map.put("bins", binList);
        map.put("numPoints", new Integer(numPoints));
        map.put("bin width", new Double(binWidth));
        this.list.add(map);
    }

    public void addSeries(Comparable key, double[] values, HistogramBin[] bins) {
        this.addSeries(key, values, values.length, bins);
    }

    public void addSeries(Comparable key, double[] values, int numPoints, HistogramBin[] bins) {
        if (key == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        if (values == null) {
            throw new IllegalArgumentException("Null 'values' argument.");
        }
        if (bins == null || bins.length < 2) {
            throw new IllegalArgumentException("The 'bins' table must contain at least 1 org.jfree.data.statistics.HistogramBin.");
        }
        ArrayList<HistogramBin> binList = new ArrayList<HistogramBin>(bins.length);
        for (int i = 0; i < bins.length; ++i) {
            binList.add(bins[i]);
        }
        ArrayList<Double> valuesList = new ArrayList<Double>(numPoints);
        for (int i = 0; i < numPoints; ++i) {
            valuesList.add(new Double(values[i]));
        }
        this.synchronizeValuesAndBins(binList, valuesList);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", key);
        map.put("values", valuesList);
        map.put("bins", binList);
        map.put("numPoints", new Integer(numPoints));
        map.put("bin width", new Double(-1.0));
        this.list.add(map);
    }

    private double getMinimum(double[] values) {
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException("Null or zero length 'values' argument.");
        }
        double min = 1.7E308;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] < min)) continue;
            min = values[i];
        }
        return min;
    }

    private double getMaximum(double[] values) {
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException("Null or zero length 'values' argument.");
        }
        double max = -1.7E308;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] > max)) continue;
            max = values[i];
        }
        return max;
    }

    public List getBins(int series) {
        Map map = (Map)this.list.get(series);
        return (List)map.get("bins");
    }

    public void setBins(int series, int bins) {
        double minimum = this.getMinimum(this.getValues(series));
        double maximum = this.getMaximum(this.getValues(series));
        this.setBins(series, bins, minimum, maximum);
    }

    public void setBins(int series, int bins, double minimum, double maximum) {
        Map map = (Map)this.list.get(series);
        List currentValues = (List)map.get("values");
        double binWidth = (maximum - minimum) / (double)bins;
        double lower = minimum;
        ArrayList<HistogramBin> binList = new ArrayList<HistogramBin>(bins);
        double EPS = 1.0E-15;
        for (int i = 0; i < bins; ++i) {
            HistogramBin bin;
            if (i == bins - 1) {
                bin = new HistogramBin(lower, maximum * (1.0 + EPS));
            } else {
                double upper = minimum + (double)(i + 1) * binWidth;
                bin = new HistogramBin(lower, upper);
                lower = upper;
            }
            binList.add(bin);
        }
        this.synchronizeValuesAndBins(binList, currentValues);
        map.put("values", currentValues);
        map.put("bins", binList);
    }

    public void setBins(int series, HistogramBin[] bins) {
        Map map = (Map)this.list.get(series);
        List currentValues = (List)map.get("values");
        ArrayList<HistogramBin> binList = new ArrayList<HistogramBin>(bins.length);
        for (int i = 0; i < bins.length; ++i) {
            binList.add(bins[i]);
        }
        this.synchronizeValuesAndBins(binList, currentValues);
        map.put("values", currentValues);
        map.put("bins", binList);
    }

    public List getValuesList(int series) {
        Map map = (Map)this.list.get(series);
        return (List)map.get("values");
    }

    public double[] getValues(int series) {
        List valuesList = (List)((Map)this.list.get(series)).get("values");
        ListIterator iter = valuesList.listIterator();
        double[] retour = new double[valuesList.size()];
        int i = 0;
        while (iter.hasNext()) {
            retour[i] = (Double)iter.next();
            ++i;
        }
        return retour;
    }

    public void setValues(int series, List valuesList) {
        Map map = (Map)this.list.get(series);
        List currentBins = (List)map.get("bins");
        this.synchronizeValuesAndBins(currentBins, valuesList);
        map.put("values", valuesList);
        map.put("bins", currentBins);
    }

    public void setValues(int series, double[] values) {
        ArrayList<Double> valuesList = new ArrayList<Double>(values.length);
        for (int i = 0; i < values.length; ++i) {
            valuesList.add(new Double(values[i]));
        }
        this.setValues(series, valuesList);
    }

    private void synchronizeValuesAndBins(List bins, List values) {
        ListIterator<HistogramBin> iterBins = bins.listIterator(0);
        ListIterator iterValues = values.listIterator();
        while (iterBins.hasNext()) {
            HistogramBin bin = (HistogramBin)iterBins.next();
            iterBins.set(new HistogramBin(bin.getStartBoundary(), bin.getEndBoundary()));
        }
        iterBins = bins.listIterator(0);
        while (iterValues.hasNext()) {
            double currentValue = (Double)iterValues.next();
            boolean continu = true;
            iterBins = bins.listIterator(0);
            while (continu && iterBins.hasNext()) {
                HistogramBin tempBin = (HistogramBin)iterBins.next();
                if (!(currentValue >= tempBin.getStartBoundary()) || !(currentValue < tempBin.getEndBoundary())) continue;
                tempBin.incrementCount();
                continu = false;
            }
        }
    }

    public int getTotal(int series) {
        Map map = (Map)this.list.get(series);
        return (Integer)map.get("numPoints");
    }

    public double getBinWidth(int series) {
        Map map = (Map)this.list.get(series);
        return (Double)map.get("bin width");
    }

    @Override
    public int getSeriesCount() {
        return this.list.size();
    }

    @Override
    public Comparable getSeriesKey(int series) {
        Map map = (Map)this.list.get(series);
        return (Comparable)map.get("key");
    }

    @Override
    public int getItemCount(int series) {
        return this.getBins(series).size();
    }

    @Override
    public Number getX(int series, int item) {
        List bins = this.getBins(series);
        HistogramBin bin = (HistogramBin)bins.get(item);
        double x = (bin.getStartBoundary() + bin.getEndBoundary()) / 2.0;
        return new Double(x);
    }

    @Override
    public Number getY(int series, int item) {
        List bins = this.getBins(series);
        HistogramBin bin = (HistogramBin)bins.get(item);
        double total = this.getTotal(series);
        double binWidth = this.getBinWidth(series);
        if (this.type == HistogramType.FREQUENCY) {
            return new Double(bin.getCount());
        }
        if (this.type == HistogramType.RELATIVE_FREQUENCY) {
            return new Double((double)bin.getCount() / total);
        }
        if (this.type == HistogramType.SCALE_AREA_TO_1) {
            return new Double((double)bin.getCount() / (binWidth * total));
        }
        throw new IllegalStateException();
    }

    @Override
    public Number getStartX(int series, int item) {
        List bins = this.getBins(series);
        HistogramBin bin = (HistogramBin)bins.get(item);
        return new Double(bin.getStartBoundary());
    }

    @Override
    public Number getEndX(int series, int item) {
        List bins = this.getBins(series);
        HistogramBin bin = (HistogramBin)bins.get(item);
        return new Double(bin.getEndBoundary());
    }

    @Override
    public Number getStartY(int series, int item) {
        return this.getY(series, item);
    }

    @Override
    public Number getEndY(int series, int item) {
        return this.getY(series, item);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomHistogramDataset)) {
            return false;
        }
        CustomHistogramDataset that = (CustomHistogramDataset)obj;
        if (!ObjectUtilities.equal((Object)this.type, (Object)that.type)) {
            return false;
        }
        return ObjectUtilities.equal((Object)this.list, (Object)that.list);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

