/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.charts;

import java.awt.Dimension;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import umontreal.iro.lecuyer.charts.Axis;
import umontreal.iro.lecuyer.charts.BoxSeriesCollection;
import umontreal.iro.lecuyer.charts.CategoryChart;

public class BoxChart
extends CategoryChart {
    protected void init(String title, String XLabel, String YLabel) {
        this.chart = ChartFactory.createBoxAndWhiskerChart(title, XLabel, YLabel, (DefaultBoxAndWhiskerCategoryDataset)this.dataset.getSeriesCollection(), true);
        ((CategoryPlot)this.chart.getPlot()).setRenderer(this.dataset.getRenderer());
        this.initAxis();
    }

    protected void initAxis() {
        this.YAxis = new Axis((NumberAxis)((CategoryPlot)this.chart.getPlot()).getRangeAxis(), false);
        this.setAutoRange();
    }

    public BoxChart() {
        this.dataset = new BoxSeriesCollection();
        this.init(null, null, null);
    }

    public BoxChart(String title, String XLabel, String YLabel, double[] data, int numPoints) {
        this.dataset = new BoxSeriesCollection(data, numPoints);
        this.init(title, XLabel, YLabel);
    }

    public BoxChart(String title, String XLabel, String YLabel, double[] ... data) {
        this.dataset = new BoxSeriesCollection(data);
        this.init(title, XLabel, YLabel);
    }

    public int add(double[] data) {
        return this.add(data, data.length);
    }

    public int add(double[] data, int numPoints) {
        int seriesIndex = this.getSeriesCollection().add(data, numPoints);
        this.initAxis();
        return seriesIndex;
    }

    public BoxSeriesCollection getSeriesCollection() {
        return (BoxSeriesCollection)this.dataset;
    }

    public void setSeriesCollection(BoxSeriesCollection dataset) {
        this.dataset = dataset;
    }

    public void setFillBox(boolean fill) {
        ((BoxAndWhiskerRenderer)this.dataset.getRenderer()).setFillBox(fill);
    }

    @Override
    public JFrame view(int width, int height) {
        JFrame myFrame = this.chart.getTitle() != null ? new JFrame("BoxChart from SSJ : " + this.chart.getTitle().getText()) : new JFrame("BoxChart from SSJ");
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setPreferredSize(new Dimension(width, height));
        myFrame.setContentPane(chartPanel);
        myFrame.pack();
        myFrame.setDefaultCloseOperation(2);
        myFrame.setLocationRelativeTo(null);
        myFrame.setVisible(true);
        return myFrame;
    }

    @Override
    public String toLatex(double width, double height) {
        throw new UnsupportedOperationException(" NOT implemented yet");
    }
}

