/*
 * Decompiled with CFR 0.152.
 */
import umontreal.iro.lecuyer.randvar.ExponentialGen;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.MRG32k3a;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.Sim;
import umontreal.iro.lecuyer.simprocs.Bin;
import umontreal.iro.lecuyer.simprocs.SimProcess;
import umontreal.iro.lecuyer.stat.Tally;

public class Visits {
    int queueSize;
    int nbLost;
    Bin visitReady = new Bin("Visit ready");
    Tally avLost = new Tally("Nb. of visitors lost per day");
    RandomVariateGen genArriv = new ExponentialGen((RandomStream)new MRG32k3a(), 20.0);
    RandomStream streamSize = new MRG32k3a();
    RandomStream streamBalk = new MRG32k3a();
    Event closing = new Event(){

        @Override
        public void actions() {
            if (Visits.this.visitReady.waitList().size() == 0) {
                Visits.this.nbLost += Visits.this.queueSize;
            }
            Sim.stop();
        }
    };

    private void oneDay() {
        this.queueSize = 0;
        this.nbLost = 0;
        SimProcess.init();
        this.visitReady.init();
        this.closing.schedule(16.0);
        new Arrival().schedule(9.75);
        for (int i = 1; i <= 3; ++i) {
            new Guide().schedule(10.0);
        }
        Sim.start();
        this.avLost.add(this.nbLost);
    }

    public void simulateRuns(int numRuns) {
        for (int i = 1; i <= numRuns; ++i) {
            this.oneDay();
        }
        this.avLost.setConfidenceIntervalStudent();
        System.out.println(this.avLost.report(0.9, 3));
    }

    public static void main(String[] args) {
        new Visits().simulateRuns(100);
    }

    class Arrival
    extends SimProcess {
        Arrival() {
        }

        @Override
        public void actions() {
            while (true) {
                this.delay(Visits.this.genArriv.nextDouble());
                double u = Visits.this.streamSize.nextDouble();
                int groupSize = u <= 0.2 ? 1 : (u <= 0.8 ? 2 : (u <= 0.9 ? 3 : 4));
                if (!this.balk()) {
                    Visits.this.queueSize += groupSize;
                    if (Visits.this.queueSize < 8 || Visits.this.visitReady.getAvailable() != 0) continue;
                    Visits.this.visitReady.put(1);
                    continue;
                }
                Visits.this.nbLost += groupSize;
            }
        }

        private boolean balk() {
            if (Visits.this.queueSize <= 10) {
                return false;
            }
            if (Visits.this.queueSize >= 40) {
                return true;
            }
            return Visits.this.streamBalk.nextDouble() < ((double)Visits.this.queueSize - 10.0) / 30.0;
        }
    }

    class Guide
    extends SimProcess {
        Guide() {
        }

        @Override
        public void actions() {
            boolean lunchDone = false;
            while (true) {
                if (Sim.time() > 12.0 && !lunchDone) {
                    this.delay(0.5);
                    lunchDone = true;
                }
                Visits.this.visitReady.take(1);
                Visits.this.queueSize = Visits.this.queueSize > 15 ? (Visits.this.queueSize -= 15) : 0;
                if (Visits.this.queueSize >= 8) {
                    Visits.this.visitReady.put(1);
                }
                this.delay(0.75);
            }
        }
    }
}

