/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import umontreal.iro.lecuyer.stat.ObservationListener;
import umontreal.iro.lecuyer.stat.StatProbe;

class SpyWindow
extends JFrame
implements ObservationListener {
    private int nObs = 0;
    private JTextArea obs = new JTextArea(25, 80);
    private JScrollPane sp = new JScrollPane(this.obs);
    private QueueObs2 qb;

    public SpyWindow(QueueObs2 qb) {
        super("Observation spy");
        this.qb = qb;
        this.sp.getViewport().setScrollMode(2);
        this.setContentPane(this.sp);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowClose());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newObservation(StatProbe probe, double x) {
        Rectangle vrect = this.sp.getViewport().getViewRect();
        Dimension vsize = this.sp.getViewport().getViewSize();
        boolean rescroll = vrect.y + vrect.height == vsize.height;
        this.obs.append("Customer " + this.nObs++ + " waited " + x + " minutes.\n");
        JScrollPane jScrollPane = this.sp;
        synchronized (jScrollPane) {
            JViewport vp = this.sp.getViewport();
            vsize = vp.getViewSize();
            vp.scrollRectToVisible(new Rectangle(0, vsize.height - 15, vsize.width, vsize.height));
        }
    }

    class WindowClose
    extends WindowAdapter {
        WindowClose() {
        }

        @Override
        public void windowClosing(WindowEvent ev) {
            ((SpyWindow)SpyWindow.this).qb.waitingTime.removeObservationListener(SpyWindow.this);
            SpyWindow.this.dispose();
        }
    }
}

