/*
 * Decompiled with CFR 0.152.
 */
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.probdist.GeometricDist;
import umontreal.iro.lecuyer.probdist.LognormalDist;
import umontreal.iro.lecuyer.probdist.PoissonDist;
import umontreal.iro.lecuyer.randvar.GammaAcceptanceRejectionGen;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.randvar.RandomVariateGenInt;
import umontreal.iro.lecuyer.rng.LFSR113;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stat.TallyStore;

public class Nonuniform {
    double lambda = 5.0;
    double p = 0.2;
    double alpha = 2.0;
    double beta = 1.0;
    double mu = 5.0;
    double sigma = 1.0;
    RandomStream stream = new LFSR113();
    RandomVariateGenInt genN = new RandomVariateGenInt(this.stream, new PoissonDist(this.lambda));
    RandomVariateGen genY = new GammaAcceptanceRejectionGen(this.stream, new GammaDist(this.alpha, this.beta));
    RandomVariateGen genW = new RandomVariateGen(this.stream, new LognormalDist(this.mu, this.sigma));

    public double generateX() {
        int j;
        double X = 0.0;
        int N = this.genN.nextInt();
        int M = GeometricDist.inverseF(this.p, this.stream.nextDouble());
        for (j = 0; j < N; ++j) {
            X += this.genY.nextDouble();
        }
        for (j = 0; j < M; ++j) {
            X += this.genW.nextDouble();
        }
        return X;
    }

    public void simulateRuns(int n) {
        TallyStore statX = new TallyStore(n);
        for (int i = 0; i < n; ++i) {
            statX.add(this.generateX());
        }
        System.out.println(statX.report());
        statX.quickSort();
        double[] data = statX.getArray();
        System.out.printf("0.10 quantile: %9.3f%n", data[(int)(0.1 * (double)n)]);
        System.out.printf("0.50 quantile: %9.3f%n", data[(int)(0.5 * (double)n)]);
        System.out.printf("0.90 quantile: %9.3f%n", data[(int)(0.9 * (double)n)]);
        System.out.printf("0.99 quantile: %9.3f%n", data[(int)(0.99 * (double)n)]);
    }

    public static void main(String[] args) {
        new Nonuniform().simulateRuns(10000);
    }
}

